/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.legendarytooltips.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.Loader;
import com.anthonyhilyard.legendarytooltips.render.TooltipDecor;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_5251;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class FrameResourceParser
implements SimpleSynchronousResourceReloadListener {
    public static final FrameResourceParser INSTANCE = new FrameResourceParser();

    private FrameResourceParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void method_14491(class_3300 resourceManager) {
        LegendaryTooltipsConfig.reset();
        try {
            for (class_3298 resource : resourceManager.method_14489(new class_2960("legendarytooltips", "frame_definitions.json"))) {
                try {
                    InputStream inputStream = resource.method_14482();
                    try {
                        JsonObject rootObject = class_3518.method_15274((Reader)new InputStreamReader(inputStream), (boolean)true);
                        if (!rootObject.has("definitions")) continue;
                        JsonArray definitions = class_3518.method_15261((JsonObject)rootObject, (String)"definitions");
                        for (int i = 0; i < definitions.size(); ++i) {
                            Object parsedImage;
                            JsonObject definitionObject = class_3518.method_15295((JsonElement)definitions.get(i), (String)String.format("definitions[%d]", i));
                            String image = TooltipDecor.DEFAULT_BORDERS.toString();
                            int index = 0;
                            int priority = 0;
                            HashMap<String, class_5251> colors = new HashMap<String, class_5251>(Map.of("startColor", LegendaryTooltipsConfig.DEFAULT_START_COLOR, "endColor", LegendaryTooltipsConfig.DEFAULT_END_COLOR, "bgColor", LegendaryTooltipsConfig.DEFAULT_BG_COLOR));
                            ArrayList<String> selectors = new ArrayList<String>();
                            for (JsonElement selectorElement : class_3518.method_15261((JsonObject)definitionObject, (String)"selectors")) {
                                selectors.add(class_3518.method_15287((JsonElement)selectorElement, (String)"selector"));
                            }
                            if (definitionObject.has("image") && class_2960.method_20207((String)(parsedImage = class_3518.method_15265((JsonObject)definitionObject, (String)"image")))) {
                                image = parsedImage;
                            }
                            if (definitionObject.has("index")) {
                                index = class_3518.method_15260((JsonObject)definitionObject, (String)"index");
                            }
                            if (definitionObject.has("priority")) {
                                priority = class_3518.method_15260((JsonObject)definitionObject, (String)"priority");
                            }
                            parsedImage = colors.keySet().iterator();
                            while (parsedImage.hasNext()) {
                                String colorKey = (String)parsedImage.next();
                                if (!definitionObject.has(colorKey)) continue;
                                class_5251 parsedColor = null;
                                if (class_3518.method_15289((JsonObject)definitionObject, (String)colorKey)) {
                                    parsedColor = LegendaryTooltipsConfig.getColor(class_3518.method_15265((JsonObject)definitionObject, (String)colorKey));
                                } else if (class_3518.method_34920((JsonObject)definitionObject, (String)colorKey)) {
                                    parsedColor = LegendaryTooltipsConfig.getColor(class_3518.method_22449((JsonObject)definitionObject, (String)colorKey));
                                }
                                if (parsedColor == null) continue;
                                colors.put(colorKey, parsedColor);
                            }
                            LegendaryTooltipsConfig.FrameDefinition definition = new LegendaryTooltipsConfig.FrameDefinition(new class_2960(image), index, ((class_5251)colors.get("startColor")).method_27716(), ((class_5251)colors.get("endColor")).method_27716(), ((class_5251)colors.get("bgColor")).method_27716(), LegendaryTooltipsConfig.FrameSource.DATA, priority);
                            LegendaryTooltipsConfig.INSTANCE.addFrameDefinition(definition, selectors);
                        }
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    throw e;
                    return;
                }
            }
        }
        catch (Exception e) {
            Loader.LOGGER.warn("An error occurred while parsing frame definitions data:\n {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public class_2960 getFabricId() {
        return new class_2960("legendarytooltips", "frame_definitions");
    }
}

