/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.fabricmc.fabric.impl.datagen.ForcedTagEntry;
import net.fabricmc.fabric.mixin.datagen.DynamicRegistryManagerAccessor;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2474;
import net.minecraft.class_2960;
import net.minecraft.class_3495;
import net.minecraft.class_3497;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public abstract class FabricTagProvider<T>
extends class_2474<T> {
    private final FabricDataGenerator fabricDataGenerator;

    public FabricTagProvider(FabricDataGenerator dataGenerator, class_2378<T> registry) {
        super((class_2403)dataGenerator, registry);
        this.fabricDataGenerator = dataGenerator;
        if (!(this instanceof DynamicRegistryTagProvider) && class_5458.field_25926.method_35842(registry.method_30517())) {
            throw new IllegalArgumentException("Using FabricTagProvider to generate dynamic registry tags is not supported, Use DynamicRegistryTagProvider instead.");
        }
    }

    protected abstract void generateTags();

    protected FabricTagBuilder<T> getOrCreateTagBuilder(class_6862<T> tag) {
        return new FabricTagBuilder(super.method_10512(tag));
    }

    protected final void method_10514() {
        this.generateTags();
    }

    public FabricDataGenerator getFabricDataGenerator() {
        return this.fabricDataGenerator;
    }

    public static abstract class DynamicRegistryTagProvider<T>
    extends FabricTagProvider<T> {
        protected DynamicRegistryTagProvider(FabricDataGenerator dataGenerator, class_5321<? extends class_2378<T>> registryKey) {
            super(dataGenerator, FabricDataGenHelper.getFakeDynamicRegistry(registryKey));
            Preconditions.checkArgument((boolean)DynamicRegistryManagerAccessor.getInfos().containsKey(registryKey), (Object)"Only dynamic registries are supported in this tag provider.");
        }
    }

    public final class FabricTagBuilder<T>
    extends class_2474.class_5124<T> {
        private final class_2474.class_5124<T> parent;

        private FabricTagBuilder(class_2474.class_5124<T> parent) {
            super(parent.field_23960, parent.field_23961);
            this.parent = parent;
        }

        public FabricTagBuilder<T> setReplace(boolean replace) {
            ((net.fabricmc.fabric.impl.datagen.FabricTagBuilder)this.field_23960).fabric_setReplace(replace);
            return this;
        }

        public FabricTagBuilder<T> add(T element) {
            this.assertStaticRegistry();
            this.parent.method_26793(element);
            return this;
        }

        public FabricTagBuilder<T> add(class_2960 id) {
            this.field_23960.method_26784(id);
            return this;
        }

        public FabricTagBuilder<T> add(class_5321<? extends T> registryKey) {
            return this.add(registryKey.method_29177());
        }

        public FabricTagBuilder<T> addOptional(class_2960 id) {
            this.parent.method_35922(id);
            return this;
        }

        public FabricTagBuilder<T> addOptional(class_5321<? extends T> registryKey) {
            return this.addOptional(registryKey.method_29177());
        }

        public FabricTagBuilder<T> addTag(class_6862<T> tag) {
            this.field_23960.method_26787(tag.comp_327());
            return this;
        }

        public FabricTagBuilder<T> addOptionalTag(class_2960 id) {
            this.parent.method_35923(id);
            return this;
        }

        public FabricTagBuilder<T> addOptionalTag(class_6862<T> tag) {
            return this.addOptionalTag(tag.comp_327());
        }

        public FabricTagBuilder<T> forceAddTag(class_6862<T> tag) {
            this.field_23960.method_27064((class_3497)new ForcedTagEntry(class_3497.method_43937((class_2960)tag.comp_327())));
            return this;
        }

        @SafeVarargs
        public final FabricTagBuilder<T> add(T ... elements) {
            this.assertStaticRegistry();
            for (T element : elements) {
                this.add(element);
            }
            return this;
        }

        public FabricTagBuilder<T> add(class_2960 ... ids) {
            for (class_2960 id : ids) {
                this.add(id);
            }
            return this;
        }

        @SafeVarargs
        public final FabricTagBuilder<T> add(class_5321<T> ... registryKeys) {
            for (class_5321<T> registryKey : registryKeys) {
                this.add((class_5321<? extends T>)registryKey);
            }
            return this;
        }

        private void assertStaticRegistry() {
            if (FabricTagProvider.this instanceof DynamicRegistryTagProvider) {
                throw new UnsupportedOperationException("Adding object instances is not supported for DynamicRegistryTagProvider.");
            }
        }
    }

    public static abstract class GameEventTagProvider
    extends FabricTagProvider<class_5712> {
        public GameEventTagProvider(FabricDataGenerator dataGenerator) {
            super(dataGenerator, class_2378.field_28264);
        }
    }

    public static abstract class EntityTypeTagProvider
    extends FabricTagProvider<class_1299<?>> {
        public EntityTypeTagProvider(FabricDataGenerator dataGenerator) {
            super(dataGenerator, class_2378.field_11145);
        }
    }

    public static abstract class FluidTagProvider
    extends FabricTagProvider<class_3611> {
        public FluidTagProvider(FabricDataGenerator dataGenerator) {
            super(dataGenerator, class_2378.field_11154);
        }
    }

    public static abstract class ItemTagProvider
    extends FabricTagProvider<class_1792> {
        @Nullable
        private final Function<class_6862<class_2248>, class_3495> blockTagBuilderProvider;

        public ItemTagProvider(FabricDataGenerator dataGenerator, @Nullable BlockTagProvider blockTagProvider) {
            super(dataGenerator, class_2378.field_11142);
            this.blockTagBuilderProvider = blockTagProvider == null ? null : x$0 -> ((FabricTagProvider)blockTagProvider).method_27169(x$0);
        }

        public ItemTagProvider(FabricDataGenerator dataGenerator) {
            this(dataGenerator, (BlockTagProvider)null);
        }

        public void copy(class_6862<class_2248> blockTag, class_6862<class_1792> itemTag) {
            class_3495 blockTagBuilder = Objects.requireNonNull(this.blockTagBuilderProvider, "Pass Block tag provider via constructor to use copy").apply(blockTag);
            class_3495 itemTagBuilder = this.method_27169(itemTag);
            blockTagBuilder.method_26782().stream().filter(entry -> entry.method_32832(arg_0 -> ((class_2378)this.field_11482).method_10250(arg_0), id -> true)).forEach(arg_0 -> ((class_3495)itemTagBuilder).method_27064(arg_0));
        }
    }

    public static abstract class BlockTagProvider
    extends FabricTagProvider<class_2248> {
        public BlockTagProvider(FabricDataGenerator dataGenerator) {
            super(dataGenerator, class_2378.field_11146);
        }
    }
}

