/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.fabricmc.fabric.impl.transfer.item.InventoryStorageImpl;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1661;

class PlayerInventoryStorageImpl
extends InventoryStorageImpl
implements PlayerInventoryStorage {
    private final DroppedStacks droppedStacks = new DroppedStacks();
    private final class_1661 playerInventory;

    PlayerInventoryStorageImpl(class_1661 playerInventory) {
        super((class_1263)playerInventory);
        this.playerInventory = playerInventory;
    }

    @Override
    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        return this.offer(resource, maxAmount, transaction);
    }

    @Override
    public long offer(ItemVariant resource, long amount, TransactionContext tx) {
        StoragePreconditions.notBlankNotNegative(resource, amount);
        long initialAmount = amount;
        List mainSlots = this.getSlots().subList(0, 36);
        for (class_1268 hand : class_1268.values()) {
            SingleSlotStorage<ItemVariant> handSlot = this.getHandSlot(hand);
            if (!((ItemVariant)handSlot.getResource()).equals(resource) || (amount -= handSlot.insert(resource, amount, tx)) != 0L) continue;
            return initialAmount;
        }
        amount -= StorageUtil.insertStacking(mainSlots, resource, amount, tx);
        return initialAmount - amount;
    }

    @Override
    public void drop(ItemVariant variant, long amount, boolean throwRandomly, boolean retainOwnership, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(variant, amount);
        if (amount > 0L && !this.playerInventory.field_7546.field_6002.method_8608()) {
            this.droppedStacks.addDrop(variant, amount, throwRandomly, retainOwnership, transaction);
        }
    }

    @Override
    public SingleSlotStorage<ItemVariant> getHandSlot(class_1268 hand) {
        if (Objects.requireNonNull(hand) == class_1268.field_5808) {
            if (class_1661.method_7380((int)this.playerInventory.field_7545)) {
                return this.getSlot(this.playerInventory.field_7545);
            }
            throw new RuntimeException("Unexpected player selected slot: " + this.playerInventory.field_7545);
        }
        if (hand == class_1268.field_5810) {
            return this.getSlot(40);
        }
        throw new UnsupportedOperationException("Unknown hand: " + hand);
    }

    private class DroppedStacks
    extends SnapshotParticipant<Integer> {
        final List<Entry> entries = new ArrayList<Entry>();

        private DroppedStacks() {
        }

        void addDrop(ItemVariant key, long amount, boolean throwRandomly, boolean retainOwnership, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            this.entries.add(new Entry(key, amount, throwRandomly, retainOwnership));
        }

        @Override
        protected Integer createSnapshot() {
            return this.entries.size();
        }

        @Override
        protected void readSnapshot(Integer snapshot) {
            int previousSize = snapshot;
            while (this.entries.size() > previousSize) {
                this.entries.remove(this.entries.size() - 1);
            }
        }

        @Override
        protected void onFinalCommit() {
            for (Entry entry : this.entries) {
                int dropped;
                for (long remainder = entry.amount; remainder > 0L; remainder -= (long)dropped) {
                    dropped = (int)Math.min((long)entry.key.getItem().method_7882(), remainder);
                    PlayerInventoryStorageImpl.this.playerInventory.field_7546.method_7329(entry.key.toStack(dropped), entry.throwRandomly, entry.retainOwnership);
                }
            }
            this.entries.clear();
        }

        private record Entry(ItemVariant key, long amount, boolean throwRandomly, boolean retainOwnership) {
        }
    }
}

