/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network.config;

import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ConfigSync {
    static final Marker NETWORK = MarkerManager.getMarker((String)"FMLNETWORK");
    public static final Marker FMLHSMARKER = MarkerManager.getMarker((String)"FMLHANDSHAKE").setParents(new Marker[]{NETWORK});
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ConfigSync INSTANCE = new ConfigSync(ConfigTracker.INSTANCE);
    public static final class_2960 SYNC_CONFIGS_CHANNEL = new class_2960("forgeconfigapiport", "sync_configs");
    public static final class_2960 MODDED_CONNECTION_CHANNEL = new class_2960("forgeconfigapiport", "modded_connection");
    private final ConfigTracker tracker;

    private ConfigSync(ConfigTracker tracker) {
        this.tracker = tracker;
    }

    public void init() {
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> {
            List<Pair<String, class_2540>> pairs = this.syncConfigs();
            for (Pair<String, class_2540> pair : pairs) {
                synchronizer.waitFor((Future)server.method_20493(() -> sender.sendPacket(SYNC_CONFIGS_CHANNEL, (class_2540)pair.getValue())));
            }
            synchronizer.waitFor((Future)server.method_20493(() -> sender.sendPacket(MODDED_CONNECTION_CHANNEL, PacketByteBufs.create())));
        });
        ServerLoginNetworking.registerGlobalReceiver((class_2960)SYNC_CONFIGS_CHANNEL, (server, handler, understood, buf, synchronizer, responseSender) -> {
            if (!understood) {
                return;
            }
            String fileName = buf.method_10800(Short.MAX_VALUE);
            LOGGER.debug(FMLHSMARKER, "Received acknowledgement for config sync for {} from client", (Object)fileName);
        });
        ServerLoginNetworking.registerGlobalReceiver((class_2960)MODDED_CONNECTION_CHANNEL, (server, handler, understood, buf, synchronizer, responseSender) -> LOGGER.debug(FMLHSMARKER, "Received acknowledgement for modded connection marker from client"));
    }

    private List<Pair<String, class_2540>> syncConfigs() {
        Map<String, byte[]> configData = this.tracker.configSets().get((Object)ModConfig.Type.SERVER).stream().collect(Collectors.toMap(ModConfig::getFileName, config -> {
            try {
                return Files.readAllBytes(config.getFullPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        return configData.entrySet().stream().map(e -> {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10814((String)e.getKey());
            buf.method_10813((byte[])e.getValue());
            return Pair.of((Object)("Config " + (String)e.getKey()), (Object)buf);
        }).collect(Collectors.toList());
    }

    public void unloadSyncedConfig() {
        this.tracker.configSets().get((Object)ModConfig.Type.SERVER).forEach(config -> config.acceptSyncedConfig(null));
    }
}

