/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.ForgeConfigAPIPort;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Path getOrCreateDirectory(Path dirPath, String dirLabel) {
        if (!Files.isDirectory(dirPath.getParent(), new LinkOption[0])) {
            FileUtils.getOrCreateDirectory(dirPath.getParent(), "parent of " + dirLabel);
        }
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            LOGGER.debug(ForgeConfigAPIPort.CORE, "Making {} directory : {}", (Object)dirLabel, (Object)dirPath);
            try {
                Files.createDirectory(dirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                if (e instanceof FileAlreadyExistsException) {
                    LOGGER.fatal(ForgeConfigAPIPort.CORE, "Failed to create {} directory - there is a file in the way", (Object)dirLabel);
                } else {
                    LOGGER.fatal(ForgeConfigAPIPort.CORE, "Problem with creating {} directory (Permissions?)", (Object)dirLabel, (Object)e);
                }
                throw new RuntimeException("Problem creating directory", e);
            }
            LOGGER.debug(ForgeConfigAPIPort.CORE, "Created {} directory : {}", (Object)dirLabel, (Object)dirPath);
        } else {
            LOGGER.debug(ForgeConfigAPIPort.CORE, "Found existing {} directory : {}", (Object)dirLabel, (Object)dirPath);
        }
        return dirPath;
    }

    public static String fileExtension(Path path) {
        String fileName = path.getFileName().toString();
        int idx = fileName.lastIndexOf(46);
        if (idx > -1) {
            return fileName.substring(idx + 1);
        }
        return "";
    }
}

