/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui.config.widgets;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_5499;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraftforge.client.gui.config.widgets.ConfigGuiWidgetFactory;
import net.minecraftforge.client.gui.config.widgets.SpecificationData;
import net.minecraftforge.client.gui.config.widgets.ValueManager;
import net.minecraftforge.client.gui.widget.ColoredEditBox;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.mixin.client.accessor.AbstractWidgetAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigGuiWidget
implements class_4069,
class_5499,
class_6379 {
    @Nullable
    private class_364 focused;
    @Nullable
    private class_6379 lastNarratable;
    private boolean dragging;

    public boolean method_25397() {
        return this.dragging;
    }

    public void method_25398(boolean isDragging) {
        this.dragging = isDragging;
    }

    @Nullable
    public class_364 method_25399() {
        return this.focused;
    }

    public void method_25395(@Nullable class_364 newFocus) {
        this.focused = newFocus;
    }

    public void method_37020(@NotNull class_6382 output) {
        List<? extends class_6379> narratables = this.narratables();
        class_437.class_6390 searchResult = class_437.method_37061(narratables, (class_6379)this.lastNarratable);
        if (searchResult != null) {
            if (searchResult.field_33827.method_37028()) {
                this.lastNarratable = searchResult.field_33825;
            }
            if (narratables.size() > 1) {
                output.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.object_list", (Object[])new Object[]{searchResult.field_33826 + 1, narratables.size()}));
                if (searchResult.field_33827 == class_6379.class_6380.field_33786) {
                    output.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.component_list.usage"));
                }
            }
            searchResult.field_33825.method_37020(output.method_37031());
        }
    }

    public abstract boolean isValid();

    public abstract Object currentValue();

    public abstract List<? extends class_6379> narratables();

    public abstract void render(class_4587 var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

    public abstract class_2561 getError();

    public abstract void resetToDefault();

    public abstract void resetToInitial();

    public static class TextWidget
    extends ConfigGuiWidget {
        public static ConfigGuiWidgetFactory FACTORY = (value, valueSpec, valueManager, spec, name) -> {
            try {
                ForgeConfigSpec.ConfigValue stringValue = value;
                return new TextWidget(stringValue, valueSpec, valueManager, spec, name);
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("The given config value for path: " + String.join((CharSequence)".", value.getPath()) + " is not a Double value!", ex);
            }
        };
        private final class_342 editBox;
        private final ForgeConfigSpec.ConfigValue<String> value;
        private final ForgeConfigSpec.ValueSpec valueSpec;
        private final ValueManager valueManager;

        public TextWidget(ForgeConfigSpec.ConfigValue<String> value, ForgeConfigSpec.ValueSpec valueSpec, ValueManager valueManager, SpecificationData specificationData, class_2561 name) {
            this.value = value;
            this.valueSpec = valueSpec;
            this.valueManager = valueManager;
            this.editBox = new ColoredEditBox(class_310.method_1551().field_1772, 0, 0, 44, 20, name){

                @Override
                public int getBorderColor() {
                    if (this.isValid()) {
                        return super.getBorderColor();
                    }
                    return 0x55FF0000;
                }

                @Override
                public int getBorderColorFocused() {
                    if (this.isValid()) {
                        return super.getBorderColor();
                    }
                    return -65536;
                }
            };
            this.editBox.method_1852(valueManager.getter().get().toString());
            this.editBox.method_1863(inputValue -> {
                if (this.isValid((String)inputValue)) {
                    valueManager.setter().accept(inputValue);
                }
            });
            this.editBox.field_22763 = !specificationData.isSynced();
            this.editBox.method_1888(this.editBox.field_22763);
        }

        private boolean isValid(String value) {
            return this.valueSpec.test(value);
        }

        @Override
        public boolean isValid() {
            return this.isValid(this.editBox.method_1882());
        }

        @Override
        public Object currentValue() {
            return this.editBox.method_1882();
        }

        @Override
        public void resetToDefault() {
            this.editBox.method_1852(this.value.getDefault());
            this.valueManager.setter().accept(this.currentValue());
        }

        @Override
        public void resetToInitial() {
            this.editBox.method_1852(this.valueManager.initial().get().toString());
            this.valueManager.setter().accept(this.currentValue());
        }

        @Override
        public class_2561 getError() {
            return this.valueSpec.getError(this.currentValue());
        }

        @Override
        public List<? extends class_6379> narratables() {
            return Collections.singletonList(this.editBox);
        }

        @Override
        public void render(class_4587 poseStack, int top, int left, int maxWidth, int maxHeight, int mouseX, int mouseY, boolean isHovered, float partialTick) {
            this.editBox.method_25358(maxWidth - 4);
            ((AbstractWidgetAccessor)this.editBox).setHeight(maxHeight);
            this.editBox.field_22760 = left + 2;
            this.editBox.field_22761 = top;
            this.editBox.method_25394(poseStack, mouseX, mouseY, partialTick);
        }

        @NotNull
        public List<class_5481> method_31047() {
            return Collections.emptyList();
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.editBox);
        }

        @NotNull
        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33785;
        }
    }

    public static class DoubleWidget
    extends NumberWidget<Double> {
        public static ConfigGuiWidgetFactory FACTORY = (value, valueSpec, valueManager, spec, name) -> {
            if (value instanceof ForgeConfigSpec.DoubleValue) {
                ForgeConfigSpec.DoubleValue doubleConfigValue = (ForgeConfigSpec.DoubleValue)value;
                return new DoubleWidget(doubleConfigValue, valueSpec, valueManager, spec, name);
            }
            throw new IllegalArgumentException("The given config value for path: " + String.join((CharSequence)".", value.getPath()) + " is not a Double value!");
        };

        public DoubleWidget(ForgeConfigSpec.ConfigValue<Double> value, ForgeConfigSpec.ValueSpec valueSpec, ValueManager valueManager, SpecificationData specificationData, class_2561 name) {
            super(value, valueSpec, valueManager, specificationData, name, Double::parseDouble);
        }
    }

    public static class LongWidget
    extends NumberWidget<Long> {
        public static ConfigGuiWidgetFactory FACTORY = (value, valueSpec, valueManager, spec, name) -> {
            if (value instanceof ForgeConfigSpec.LongValue) {
                ForgeConfigSpec.LongValue longConfigValue = (ForgeConfigSpec.LongValue)value;
                return new LongWidget(longConfigValue, valueSpec, valueManager, spec, name);
            }
            throw new IllegalArgumentException("The given config value for path: " + String.join((CharSequence)".", value.getPath()) + " is not a long value!");
        };

        public LongWidget(ForgeConfigSpec.ConfigValue<Long> value, ForgeConfigSpec.ValueSpec valueSpec, ValueManager valueManager, SpecificationData specificationData, class_2561 name) {
            super(value, valueSpec, valueManager, specificationData, name, Long::parseLong);
        }
    }

    public static class IntegerWidget
    extends NumberWidget<Integer> {
        public static ConfigGuiWidgetFactory FACTORY = (value, valueSpec, valueManager, spec, name) -> {
            if (value instanceof ForgeConfigSpec.IntValue) {
                ForgeConfigSpec.IntValue intConfigValue = (ForgeConfigSpec.IntValue)value;
                return new IntegerWidget(intConfigValue, valueSpec, valueManager, spec, name);
            }
            throw new IllegalArgumentException("The given config value for path: " + String.join((CharSequence)".", value.getPath()) + " is not a integer value!");
        };

        public IntegerWidget(ForgeConfigSpec.ConfigValue<Integer> value, ForgeConfigSpec.ValueSpec valueSpec, ValueManager valueManager, SpecificationData specificationData, class_2561 name) {
            super(value, valueSpec, valueManager, specificationData, name, Integer::parseInt);
        }
    }

    public static abstract class NumberWidget<T extends Number>
    extends ConfigGuiWidget {
        private final class_342 editBox;
        private final ForgeConfigSpec.ConfigValue<T> value;
        private final ForgeConfigSpec.ValueSpec valueSpec;
        private final ValueManager valueManager;
        private final Function<String, T> parser;

        public NumberWidget(ForgeConfigSpec.ConfigValue<T> value, ForgeConfigSpec.ValueSpec valueSpec, ValueManager valueManager, SpecificationData specificationData, class_2561 name, Function<String, T> parser) {
            this.value = value;
            this.valueSpec = valueSpec;
            this.valueManager = valueManager;
            this.editBox = new ColoredEditBox(class_310.method_1551().field_1772, 0, 0, 44, 20, name){

                @Override
                public int getBorderColor() {
                    if (this.isValid()) {
                        return super.getBorderColor();
                    }
                    return 0x55FF0000;
                }

                @Override
                public int getBorderColorFocused() {
                    if (this.isValid()) {
                        return super.getBorderColor();
                    }
                    return -65536;
                }
            };
            this.parser = parser;
            this.editBox.method_1852(valueManager.getter().get().toString());
            this.editBox.method_1863(inputValue -> {
                if (this.isValid((String)inputValue)) {
                    valueManager.setter().accept(parser.apply((String)inputValue));
                }
            });
            this.editBox.field_22763 = !specificationData.isSynced();
            this.editBox.method_1888(this.editBox.field_22763);
        }

        @Override
        public boolean isValid() {
            return this.isValid(this.editBox.method_1882());
        }

        @Override
        public Object currentValue() {
            try {
                return this.parser.apply(this.editBox.method_1882());
            }
            catch (NumberFormatException e) {
                return this.editBox.method_1882();
            }
        }

        @Override
        public void resetToDefault() {
            this.editBox.method_1852(((Number)this.value.getDefault()).toString());
            this.valueManager.setter().accept(this.currentValue());
        }

        @Override
        public void resetToInitial() {
            this.editBox.method_1852(this.valueManager.initial().get().toString());
            this.valueManager.setter().accept(this.currentValue());
        }

        @Override
        public class_2561 getError() {
            return this.valueSpec.getError(this.currentValue());
        }

        @Override
        public List<? extends class_6379> narratables() {
            return Collections.singletonList(this.editBox);
        }

        @Override
        public void render(class_4587 poseStack, int top, int left, int maxWidth, int maxHeight, int mouseX, int mouseY, boolean isHovered, float partialTick) {
            this.editBox.method_25358(maxWidth - 4);
            ((AbstractWidgetAccessor)this.editBox).setHeight(maxHeight);
            this.editBox.field_22760 = left + 2;
            this.editBox.field_22761 = top;
            this.editBox.method_25394(poseStack, mouseX, mouseY, partialTick);
        }

        @NotNull
        public List<class_5481> method_31047() {
            return Collections.emptyList();
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.editBox);
        }

        @NotNull
        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33785;
        }

        private boolean isValid(String value) {
            try {
                return this.isValid((Number)this.parser.apply(value));
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        private boolean isValid(T value) {
            return this.valueSpec.test(value);
        }
    }

    public static class EnumWidget<T extends Enum<T>>
    extends ConfigGuiWidget {
        private final class_5676<T> enumButton;
        private final ForgeConfigSpec.ValueSpec spec;
        private final ValueManager valueManager;

        public static <Z extends Enum<Z>> ConfigGuiWidgetFactory getFactory() {
            return (value, valueSpec, valueManager, spec, name) -> {
                if (value instanceof ForgeConfigSpec.EnumValue) {
                    ForgeConfigSpec.EnumValue enumConfigValue = (ForgeConfigSpec.EnumValue)value;
                    return new EnumWidget(enumConfigValue, valueSpec, valueManager, spec, name);
                }
                throw new IllegalArgumentException("The given config value for path: " + String.join((CharSequence)".", value.getPath()) + " is not a boolean value!");
            };
        }

        public EnumWidget(ForgeConfigSpec.EnumValue<T> value, ForgeConfigSpec.ValueSpec spec, ValueManager valueManager, SpecificationData specificationData, class_2561 name) {
            this.spec = spec;
            this.valueManager = valueManager;
            this.enumButton = class_5676.method_32606(t -> class_2561.method_43470((String)t.name())).method_32620(List.of((Enum[])value.getEnumClass().getEnumConstants())).method_32616().method_32623(class_5676::method_32611).method_32617(0, 0, 44, 20, name, (p_170215_, p_170216_) -> valueManager.setter().accept(p_170216_));
            this.enumButton.field_22763 = !specificationData.isSynced();
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Object currentValue() {
            return this.enumButton.method_32603();
        }

        @Override
        public void resetToDefault() {
            this.enumButton.method_32605((Object)((Enum)this.spec.getDefault()));
            this.valueManager.setter().accept(this.enumButton.method_32603());
        }

        @Override
        public void resetToInitial() {
            this.enumButton.method_32605((Object)((Enum)this.valueManager.initial().get()));
            this.valueManager.setter().accept(this.enumButton.method_32603());
        }

        @Override
        public class_2561 getError() {
            return this.spec.getError(this.currentValue());
        }

        @Override
        public List<? extends class_6379> narratables() {
            return Collections.singletonList(this.enumButton);
        }

        @Override
        public void render(class_4587 poseStack, int top, int left, int maxWidth, int maxHeight, int mouseX, int mouseY, boolean isHovered, float partialTick) {
            this.enumButton.method_25358(maxWidth);
            ((AbstractWidgetAccessor)this.enumButton).setHeight(maxHeight);
            this.enumButton.field_22760 = left;
            this.enumButton.field_22761 = top;
            this.enumButton.method_25394(poseStack, mouseX, mouseY, partialTick);
        }

        @NotNull
        public List<class_5481> method_31047() {
            return this.enumButton.method_31047();
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.enumButton);
        }

        @NotNull
        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33785;
        }
    }

    public static class BooleanWidget
    extends ConfigGuiWidget {
        public static ConfigGuiWidgetFactory FACTORY = (value, valueSpec, valueManager, spec, name) -> {
            if (value instanceof ForgeConfigSpec.BooleanValue) {
                ForgeConfigSpec.BooleanValue booleanConfigValue = (ForgeConfigSpec.BooleanValue)value;
                return new BooleanWidget(booleanConfigValue, valueSpec, valueManager, spec, name);
            }
            throw new IllegalArgumentException("The given config value for path: " + String.join((CharSequence)".", value.getPath()) + " is not a boolean value!");
        };
        private final class_5676<Boolean> checkbox;
        private final ForgeConfigSpec.ValueSpec spec;
        private final ValueManager valueManager;

        public BooleanWidget(ForgeConfigSpec.ConfigValue<Boolean> value, ForgeConfigSpec.ValueSpec spec, ValueManager valueManager, SpecificationData specificationData, class_2561 name) {
            this.spec = spec;
            this.valueManager = valueManager;
            this.checkbox = class_5676.method_32613((boolean)value.get()).method_32616().method_32623(class_5676::method_32611).method_32617(0, 0, 44, 20, name, (p_170215_, p_170216_) -> valueManager.setter().accept(p_170216_));
            this.checkbox.field_22763 = !specificationData.isSynced();
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Object currentValue() {
            return this.checkbox.method_32603();
        }

        @Override
        public List<? extends class_6379> narratables() {
            return Collections.singletonList(this.checkbox);
        }

        @Override
        public void render(class_4587 poseStack, int top, int left, int maxWidth, int maxHeight, int mouseX, int mouseY, boolean isHovered, float partialTick) {
            this.checkbox.method_25358(maxWidth);
            ((AbstractWidgetAccessor)this.checkbox).setHeight(maxHeight);
            this.checkbox.field_22760 = left;
            this.checkbox.field_22761 = top;
            this.checkbox.method_25394(poseStack, mouseX, mouseY, partialTick);
        }

        @Override
        public class_2561 getError() {
            return this.spec.getError(this.currentValue());
        }

        @Override
        public void resetToDefault() {
            this.checkbox.method_32605((Object)((Boolean)this.spec.getDefault()));
            this.valueManager.setter().accept(this.checkbox.method_32603());
        }

        @Override
        public void resetToInitial() {
            this.checkbox.method_32605((Object)((Boolean)this.valueManager.initial().get()));
            this.valueManager.setter().accept(this.checkbox.method_32603());
        }

        @NotNull
        public List<class_5481> method_31047() {
            return this.checkbox.method_31047();
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.checkbox);
        }

        @NotNull
        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33785;
        }
    }
}

