/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui.config.widgets;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraftforge.client.gui.config.widgets.ConfigGuiWidget;
import net.minecraftforge.client.gui.config.widgets.ConfigGuiWidgetFactory;
import net.minecraftforge.client.gui.config.widgets.SpecificationData;
import net.minecraftforge.client.gui.config.widgets.ValueManager;
import net.minecraftforge.client.gui.widget.ImageContentButton;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class ConfigGuiScreen
extends class_437 {
    private static final class_2960 FORGE_EXPERIMENTAL_WARNING_ICON = new class_2960("forge", "textures/gui/experimental_warning.png");
    private static final class_2960 FORGE_NEEDS_WORLD_RELOAD_ICON = new class_2960("forge", "textures/gui/needs_world_reload.png");
    private static final class_2960 FORGE_RESET_TO_INITIAL_ICON = new class_2960("forge", "textures/gui/reset_to_initial.png");
    private static final class_2960 FORGE_RESET_TO_DEFAULT_ICON = new class_2960("forge", "textures/gui/reset_to_default.png");
    private static final class_2960 FORGE_SEARCH_ICON = new class_2960("forge", "textures/gui/search.png");
    private final Map<List<String>, Object> currentValues = Maps.newHashMap();
    private final Map<List<String>, Object> initialValues = Maps.newHashMap();
    private final Collection<SpecificationData> specs;
    private final Set<ConfigEntry> invalidEntries = Sets.newHashSet();
    private final Runnable onClose;
    private ConfigEntryList configEntryList;
    private class_4185 doneButton;
    private ImageContentButton resetToInitialButton = null;
    private ImageContentButton resetToDefaultButton = null;
    @Nullable
    private List<class_5481> tooltip;

    public ConfigGuiScreen(class_2561 title, Collection<SpecificationData> specs, Runnable onClose) {
        super(title);
        this.specs = specs;
        this.onClose = onClose;
    }

    @NotNull
    private static Comparator<List<String>> createListComparator() {
        return (o1, o2) -> {
            if (o1.size() == o2.size()) {
                for (int i = 0; i < o1.size(); ++i) {
                    int result = ((String)o1.get(i)).compareTo((String)o2.get(i));
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
            return o1.size() - o2.size();
        };
    }

    public void method_25419() {
        super.method_25419();
        this.configEntryList.onSave();
        this.onClose.run();
    }

    protected void method_25426() {
        Objects.requireNonNull(this.field_22787).field_1774.method_1462(true);
        super.method_25426();
        this.configEntryList = new ConfigEntryList();
        this.method_25429((class_364)this.configEntryList);
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 155 + 160, this.field_22790 - 29, 150, 20, class_5244.field_24335, p_101073_ -> {
            this.configEntryList.onCancel();
            this.method_25419();
        }));
        this.doneButton = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 155, this.field_22790 - 29, 150, 20, class_5244.field_24334, p_101059_ -> this.method_25419()));
        class_342 searchBox = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 + 32, 16, (this.field_22789 - 100) / 2, 20, (class_2561)class_2561.method_43471((String)"forge.configgui.search")));
        searchBox.method_1863(searchString -> this.configEntryList.initializeEntries(searchString.trim()));
        this.resetToInitialButton = (ImageContentButton)this.method_37063((class_364)new ImageContentButton(this.field_22789 / 2 - 155 + 316, this.field_22790 - 29, 24, 20, 0, 2, 0, FORGE_RESET_TO_INITIAL_ICON, 24, 24, botton -> this.configEntryList.resetToInitial(), (class_2561)class_2561.method_43471((String)"forge.configgui.resetAllToInitial")));
        this.resetToDefaultButton = (ImageContentButton)this.method_37063((class_364)new ImageContentButton(this.field_22789 / 2 - 155 + 342, this.field_22790 - 29, 24, 20, 0, 2, 0, FORGE_RESET_TO_DEFAULT_ICON, 24, 24, botton -> this.configEntryList.resetToDefault(), (class_2561)class_2561.method_43471((String)"forge.configgui.resetAllToDefault")));
    }

    public void method_25432() {
        Objects.requireNonNull(this.field_22787).field_1774.method_1462(false);
    }

    public void method_25394(@NotNull class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.tooltip = null;
        this.configEntryList.method_25394(poseStack, mouseX, mouseY, partialTick);
        ConfigGuiScreen.method_27535((class_4587)poseStack, (class_327)this.field_22793, (class_2561)this.field_22785, (int)25, (int)20, (int)0xFFFFFF);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        if (this.tooltip != null) {
            this.method_25417(poseStack, this.tooltip, mouseX, mouseY);
        }
        this.renderSearchIcon(poseStack);
        this.resetToInitialButton.setActive(this.configEntryList.hasEntriesWhichCanBeResetToInitial(Collections.emptyList()));
        this.resetToDefaultButton.setActive(this.configEntryList.hasEntriesWhichCanBeResetToDefault(Collections.emptyList()));
    }

    private void renderSearchIcon(class_4587 stack) {
        RenderSystem.setShaderTexture((int)0, (class_2960)FORGE_SEARCH_ICON);
        class_332.method_25290((class_4587)stack, (int)(this.field_22789 / 2 + 12), (int)20, (float)0.0f, (float)0.0f, (int)14, (int)14, (int)14, (int)14);
    }

    void setTooltip(@Nullable List<class_5481> p_101082_) {
        this.tooltip = p_101082_;
    }

    private void updateDoneButton() {
        this.doneButton.field_22763 = this.invalidEntries.isEmpty();
    }

    void markInvalid(ConfigEntry entry) {
        this.invalidEntries.add(entry);
        this.updateDoneButton();
    }

    void clearInvalid(ConfigEntry entry) {
        this.invalidEntries.remove((Object)entry);
        this.updateDoneButton();
    }

    public boolean method_25422() {
        return this.invalidEntries.isEmpty();
    }

    public class ConfigEntryList
    extends class_4265<AbstractListEntry> {
        public ConfigEntryList() {
            super(Objects.requireNonNull(ConfigGuiScreen.this.field_22787), ConfigGuiScreen.this.field_22789, ConfigGuiScreen.this.field_22790, 43, ConfigGuiScreen.this.field_22790 - 32, 24);
            this.initializeEntries("");
        }

        public int method_25322() {
            return ConfigGuiScreen.this.field_22789 - 50;
        }

        public void method_25394(@NotNull class_4587 p_101205_, int p_101206_, int p_101207_, float p_101208_) {
            ConfigGuiScreen.this.setTooltip(null);
            super.method_25394(p_101205_, p_101206_, p_101207_, p_101208_);
        }

        public int method_25329() {
            return this.method_25342() + this.method_25322();
        }

        private void initializeEntries(String searchString) {
            this.method_25339();
            HashMap map = Maps.newHashMap();
            ConfigGuiScreen.this.specs.forEach(spec -> this.initializeConfigSpecification(searchString, map, (SpecificationData)spec));
        }

        private void initializeConfigSpecification(String searchString, Map<List<String>, ConfigEntry> map, SpecificationData spec) {
            if (!spec.configSpec().isLoaded()) {
                return;
            }
            spec.configSpec().getValues().valueMap().values().forEach(configValue -> this.handleConfigValue(spec, map, configValue));
            HashSet groups = new HashSet();
            map.entrySet().stream().sorted(Map.Entry.comparingByKey(ConfigGuiScreen.createListComparator())).forEach(configEntry -> this.initializeEntry(searchString, spec, groups, (Map.Entry<List<String>, ConfigEntry>)configEntry));
            map.clear();
        }

        private void initializeEntry(String searchString, SpecificationData spec, Set<List<String>> groups, Map.Entry<List<String>, ConfigEntry> configEntry) {
            if (!(searchString.isEmpty() || searchString.isBlank() || Arrays.stream(searchString.split(" ")).allMatch(searchEntry -> ((ConfigEntry)((Object)((Object)configEntry.getValue()))).getLabel().getString().toLowerCase().contains((CharSequence)searchEntry)))) {
                return;
            }
            Set<List<String>> entryGroup = this.createGroups(configEntry.getKey());
            for (List<String> group : entryGroup) {
                if (groups.contains(group)) continue;
                groups.add(group);
                String label = spec.configSpec().getLevelTranslationKey(group);
                if (label == null) continue;
                this.method_25321((class_350.class_351)new CategoryEntry(group, (class_2561)class_2561.method_43471((String)label)));
            }
            this.method_25321((class_350.class_351)configEntry.getValue());
        }

        private Set<List<String>> createGroups(List<String> group) {
            if (group.isEmpty()) {
                return Sets.newHashSet();
            }
            ArrayList<String> groupKeys = new ArrayList<String>(group);
            groupKeys.remove(groupKeys.size() - 1);
            HashSet<List<String>> groups = new HashSet<List<String>>();
            ArrayList workingList = Lists.newArrayList();
            for (String s : group) {
                workingList.add(s);
                groups.add(new ArrayList(workingList));
            }
            return groups;
        }

        private void handleConfigValue(SpecificationData spec, Map<List<String>, ConfigEntry> map, Object value) {
            if (value instanceof AbstractConfig) {
                AbstractConfig innerConfig = (AbstractConfig)value;
                innerConfig.valueMap().values().forEach(value1 -> this.handleConfigValue(spec, map, value1));
                return;
            }
            if (value instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)value;
                if (!ConfigGuiScreen.this.initialValues.containsKey(configValue.getPath())) {
                    ConfigGuiScreen.this.initialValues.put(configValue.getPath(), configValue.get());
                    ConfigGuiScreen.this.currentValues.put(configValue.getPath(), configValue.get());
                }
                map.put(configValue.getPath(), new ConfigEntry(spec, configValue, new ValueManager(() -> ConfigGuiScreen.this.initialValues.get(configValue.getPath()), () -> ConfigGuiScreen.this.currentValues.get(configValue.getPath()), v -> ConfigGuiScreen.this.currentValues.put(configValue.getPath(), v))));
            }
        }

        public void onSave() {
            ConfigGuiScreen.this.currentValues.forEach((entry, value) -> this.method_25396().stream().filter(ConfigEntry.class::isInstance).map(ConfigEntry.class::cast).filter(e -> e.configValue.getPath().equals(entry)).findFirst().ifPresent(e -> e.configValue.set(value)));
            ConfigGuiScreen.this.specs.forEach(spec -> {
                if (spec.isSynced()) {
                    return;
                }
                if (!spec.configSpec().isLoaded()) {
                    return;
                }
                spec.configSpec().save();
            });
        }

        public void onCancel() {
            ConfigGuiScreen.this.initialValues.forEach((entry, value) -> this.method_25396().stream().filter(ConfigEntry.class::isInstance).map(ConfigEntry.class::cast).filter(e -> e.configValue.getPath().equals(entry)).findFirst().ifPresent(e -> e.configValue.set(value)));
        }

        public void resetToInitial() {
            this.method_25396().stream().filter(ConfigEntry.class::isInstance).map(ConfigEntry.class::cast).filter(e -> e.widget != null).forEach(e -> e.widget.resetToInitial());
        }

        public void resetToDefault() {
            this.method_25396().stream().filter(ConfigEntry.class::isInstance).map(ConfigEntry.class::cast).filter(e -> e.widget != null).forEach(e -> e.widget.resetToDefault());
        }

        public void resetToDefault(List<String> pathPrefix) {
            this.method_25396().stream().filter(ConfigEntry.class::isInstance).map(ConfigEntry.class::cast).filter(e -> this.isPrefixList(pathPrefix, e.configValue.getPath())).filter(e -> e.widget != null).forEach(e -> e.widget.resetToDefault());
        }

        public void resetToInitial(List<String> pathPrefix) {
            this.method_25396().stream().filter(ConfigEntry.class::isInstance).map(ConfigEntry.class::cast).filter(e -> this.isPrefixList(pathPrefix, e.configValue.getPath())).filter(e -> e.widget != null).forEach(e -> e.widget.resetToInitial());
        }

        public boolean hasEntriesWhichCanBeResetToInitial(List<String> pathPrefix) {
            return this.method_25396().stream().filter(ConfigEntry.class::isInstance).map(ConfigEntry.class::cast).filter(e -> this.isPrefixList(pathPrefix, e.configValue.getPath())).anyMatch(ConfigEntry::canBeResetToInitial);
        }

        public boolean hasEntriesWhichCanBeResetToDefault(List<String> pathPrefix) {
            return this.method_25396().stream().filter(ConfigEntry.class::isInstance).map(ConfigEntry.class::cast).filter(e -> this.isPrefixList(pathPrefix, e.configValue.getPath())).anyMatch(ConfigEntry::canBeResetToDefault);
        }

        public boolean isPrefixList(List<String> prefix, List<String> candidate) {
            if (prefix.size() > candidate.size()) {
                return false;
            }
            for (int i = 0; i < prefix.size(); ++i) {
                if (prefix.get(i).equals(candidate.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public class CategoryEntry
    extends AbstractListEntry {
        private final List<String> pathPrefix;
        private final class_2561 label;
        private final ImageContentButton resetToInitialButton;
        private final ImageContentButton resetToDefaultButton;

        public CategoryEntry(List<String> pathPrefix, class_2561 header) {
            this.pathPrefix = pathPrefix;
            this.label = header;
            this.resetToDefaultButton = new ImageContentButton(0, 0, 24, 20, 0, 2, 0, FORGE_RESET_TO_DEFAULT_ICON, 24, 24, botton -> ConfigGuiScreen.this.configEntryList.resetToDefault(this.pathPrefix), (class_2561)class_2561.method_43471((String)"forge.configgui.resetGroupToDefault"));
            this.resetToInitialButton = new ImageContentButton(0, 0, 24, 20, 0, 2, 0, FORGE_RESET_TO_INITIAL_ICON, 24, 24, botton -> ConfigGuiScreen.this.configEntryList.resetToInitial(this.pathPrefix), (class_2561)class_2561.method_43471((String)"forge.configgui.resetGroupToInitial"));
        }

        @Override
        public void method_25343(@NotNull class_4587 poseStack, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float partialTick) {
            class_332.method_27534((class_4587)poseStack, (class_327)Objects.requireNonNull(((ConfigGuiScreen)ConfigGuiScreen.this).field_22787).field_1772, (class_2561)this.label, (int)(left + entryWidth / 2), (int)(top + 5), (int)0xFFFFFF);
            this.resetToInitialButton.setActive(ConfigGuiScreen.this.configEntryList.hasEntriesWhichCanBeResetToInitial(this.pathPrefix));
            this.resetToInitialButton.field_22760 = left + entryWidth - 52;
            this.resetToInitialButton.field_22761 = top;
            this.resetToInitialButton.method_25394(poseStack, mouseX, mouseY, partialTick);
            this.resetToDefaultButton.setActive(ConfigGuiScreen.this.configEntryList.hasEntriesWhichCanBeResetToDefault(this.pathPrefix));
            this.resetToDefaultButton.field_22760 = left + entryWidth - 26;
            this.resetToDefaultButton.field_22761 = top;
            this.resetToDefaultButton.method_25394(poseStack, mouseX, mouseY, partialTick);
            if (this.resetToInitialButton.method_37303() && this.resetToInitialButton.method_25367()) {
                ConfigGuiScreen.this.setTooltip(class_310.method_1551().field_1772.method_1728((class_5348)this.resetToInitialButton.method_25369(), ConfigGuiScreen.this.field_22789 / 2));
            } else if (this.resetToDefaultButton.method_37303() && this.resetToDefaultButton.method_25367()) {
                ConfigGuiScreen.this.setTooltip(class_310.method_1551().field_1772.method_1728((class_5348)this.resetToDefaultButton.method_25369(), ConfigGuiScreen.this.field_22789 / 2));
            }
        }

        @Override
        @NotNull
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)((Object)this.resetToInitialButton), (Object)((Object)this.resetToDefaultButton));
        }

        @Override
        @NotNull
        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                @NotNull
                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(@NotNull class_6382 output) {
                    output.method_37034(class_6381.field_33788, CategoryEntry.this.label);
                }
            });
        }
    }

    public class ConfigEntry
    extends AbstractListEntry {
        private final class_2561 label;
        private final List<class_5481> labelLines;
        private final ConfigGuiWidget widget;
        private final ForgeConfigSpec.ConfigValue<?> configValue;
        private final ForgeConfigSpec.ValueSpec valueSpec;
        private ImageContentButton resetToInitialButton = null;
        private ImageContentButton resetToDefaultButton = null;

        public ConfigEntry(SpecificationData spec, ForgeConfigSpec.ConfigValue<?> configValue, ValueManager valueManager) {
            this.configValue = configValue;
            this.valueSpec = (ForgeConfigSpec.ValueSpec)spec.configSpec().getRaw(configValue.getPath());
            String labelTranslationKey = this.valueSpec.getTranslationKey();
            Object tooltipTranslationKey = labelTranslationKey != null ? labelTranslationKey + ".tooltip" : this.valueSpec.getComment();
            this.label = labelTranslationKey != null ? class_2561.method_43471((String)labelTranslationKey) : class_2561.method_43470((String)String.join((CharSequence)".", configValue.getPath()));
            this.labelLines = class_310.method_1551().field_1772.method_1728((class_5348)this.label, ConfigGuiScreen.this.field_22789 - 160);
            this.tooltip = tooltipTranslationKey != null ? class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43471((String)tooltipTranslationKey), ConfigGuiScreen.this.field_22789 / 2) : null;
            ConfigGuiWidgetFactory factory = configValue.getScreenWidgetFactorySupplier().get();
            ConfigGuiWidget configGuiWidget = this.widget = factory != null ? factory.create(configValue, this.valueSpec, valueManager, spec, this.label) : null;
            if (this.widget != null) {
                this.resetToDefaultButton = new ImageContentButton(0, 0, 24, 20, 0, 2, 0, FORGE_RESET_TO_DEFAULT_ICON, 24, 24, botton -> this.widget.resetToDefault(), (class_2561)class_2561.method_43471((String)"forge.configgui.resetToDefault"));
                this.resetToInitialButton = new ImageContentButton(0, 0, 24, 20, 0, 2, 0, FORGE_RESET_TO_INITIAL_ICON, 24, 24, botton -> this.widget.resetToInitial(), (class_2561)class_2561.method_43471((String)"forge.configgui.resetToInitial"));
            }
        }

        @Override
        public void method_25343(@NotNull class_4587 poseStack, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float partialTick) {
            this.renderLabel(poseStack, top, left);
            if (this.widget != null) {
                this.widget.render(poseStack, top, ConfigGuiScreen.this.field_22789 - 150, 72, entryHeight, mouseX, mouseY, isHovered, partialTick);
                this.resetToInitialButton.setActive(this.canBeResetToInitial());
                this.resetToInitialButton.field_22760 = left + entryWidth - 52;
                this.resetToInitialButton.field_22761 = top;
                this.resetToInitialButton.method_25394(poseStack, mouseX, mouseY, partialTick);
                this.resetToDefaultButton.setActive(this.canBeResetToDefault());
                this.resetToDefaultButton.field_22760 = left + entryWidth - 26;
                this.resetToDefaultButton.field_22761 = top;
                this.resetToDefaultButton.method_25394(poseStack, mouseX, mouseY, partialTick);
                if (this.widget.isValid()) {
                    ConfigGuiScreen.this.clearInvalid(this);
                } else {
                    ConfigGuiScreen.this.markInvalid(this);
                }
                if (isHovered) {
                    if (this.resetToInitialButton.method_25367()) {
                        ConfigGuiScreen.this.setTooltip(class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43471((String)"forge.configgui.resetToInitial"), ConfigGuiScreen.this.field_22789 / 2));
                    } else if (this.resetToDefaultButton.method_25367()) {
                        ConfigGuiScreen.this.setTooltip(class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43471((String)"forge.configgui.resetToDefault"), ConfigGuiScreen.this.field_22789 / 2));
                    } else {
                        ConfigGuiScreen.this.setTooltip(this.widget.method_31047());
                    }
                }
            }
            this.renderRequiresReloadIndicator(poseStack, mouseX, mouseY, top, left, isHovered);
            this.renderWarning(poseStack, mouseX, mouseY, top, left, isHovered);
        }

        @Override
        @NotNull
        public List<? extends class_6379> method_37025() {
            return this.widget != null ? Lists.newArrayList((Object[])new class_6379[]{this.widget, this.resetToInitialButton, this.resetToDefaultButton}) : Collections.emptyList();
        }

        @Override
        @NotNull
        public List<? extends class_364> method_25396() {
            return this.widget != null ? Lists.newArrayList((Object[])new class_6379[]{this.widget, this.resetToInitialButton, this.resetToDefaultButton}) : Collections.emptyList();
        }

        public class_2561 getLabel() {
            return this.label;
        }

        protected void renderLabel(class_4587 poseStack, int top, int left) {
            if (this.labelLines.size() == 1) {
                class_310.method_1551().field_1772.method_27528(poseStack, this.labelLines.get(0), (float)left + 24.0f, (float)(top + 5), 0xFFFFFF);
            } else if (this.labelLines.size() >= 2) {
                class_310.method_1551().field_1772.method_27528(poseStack, this.labelLines.get(0), (float)left + 24.0f, (float)top, 0xFFFFFF);
                class_310.method_1551().field_1772.method_27528(poseStack, this.labelLines.get(1), (float)left + 24.0f, (float)(top + 10), 0xFFFFFF);
            }
        }

        private void renderWarning(class_4587 stack, int mouseX, int mouseY, int top, int left, boolean isHovered) {
            if (this.widget != null && !this.widget.isValid()) {
                RenderSystem.setShaderTexture((int)0, (class_2960)FORGE_EXPERIMENTAL_WARNING_ICON);
                class_332.method_25290((class_4587)stack, (int)(left - 2), (int)(top - 2), (float)0.0f, (float)0.0f, (int)22, (int)22, (int)22, (int)22);
                if (isHovered && mouseX > left + 1 && mouseX < left + 23 && mouseY > top + 1 && mouseY < top + 23) {
                    class_2561 errorComponent = this.widget.getError();
                    List tooltip = class_310.method_1551().field_1772.method_1728((class_5348)(errorComponent != null ? errorComponent : class_2561.method_43471((String)"forge.configgui.entryInvalid")), ConfigGuiScreen.this.field_22789 / 2);
                    ConfigGuiScreen.this.setTooltip(tooltip);
                }
            }
        }

        private void renderRequiresReloadIndicator(class_4587 stack, int mouseX, int mouseY, int top, int left, boolean isHovered) {
            if (this.widget != null && this.widget.isValid() && ConfigGuiScreen.this.initialValues.get(this.configValue.getPath()) != null && this.canBeResetToInitial() && this.valueSpec.needsWorldRestart()) {
                RenderSystem.setShaderTexture((int)0, (class_2960)FORGE_NEEDS_WORLD_RELOAD_ICON);
                class_332.method_25290((class_4587)stack, (int)(left - 2), (int)(top - 2), (float)0.0f, (float)0.0f, (int)22, (int)22, (int)22, (int)22);
                if (isHovered && mouseX > left + 1 && mouseX < left + 23 && mouseY > top + 1 && mouseY < top + 23) {
                    List tooltip = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43471((String)"forge.configgui.requiresWorldRestartToTakeEffect"), ConfigGuiScreen.this.field_22789 / 2);
                    ConfigGuiScreen.this.setTooltip(tooltip);
                }
            }
        }

        private boolean canBeResetToDefault() {
            return this.widget != null && this.widget.currentValue() != this.configValue.getDefault();
        }

        private boolean canBeResetToInitial() {
            return this.widget != null && !ConfigGuiScreen.this.initialValues.get(this.configValue.getPath()).equals(ConfigGuiScreen.this.currentValues.get(this.configValue.getPath()));
        }
    }

    public static abstract class AbstractListEntry
    extends class_4265.class_4266<AbstractListEntry> {
        @Nullable
        protected List<class_5481> tooltip = null;

        protected AbstractListEntry() {
        }

        public abstract void method_25343(@NotNull class_4587 var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        @NotNull
        public abstract List<? extends class_6379> method_37025();

        @NotNull
        public abstract List<? extends class_364> method_25396();

        @Nullable
        public List<class_5481> getTooltip() {
            return this.tooltip;
        }
    }
}

