/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.container;

import java.util.Arrays;
import net.blay09.mods.balm.api.container.EmptyContainer;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class CombinedContainer
implements class_1263 {
    private final class_1263[] containers;
    private final int[] baseIndex;
    private final int totalSlots;

    public CombinedContainer(class_1263 ... containers) {
        this.containers = containers;
        this.baseIndex = new int[containers.length];
        int index = 0;
        for (int i = 0; i < containers.length; ++i) {
            this.baseIndex[i] = index += containers[i].method_5439();
        }
        this.totalSlots = index;
    }

    private int getContainerIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndex.length; ++i) {
            if (slot - this.baseIndex[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    private class_1263 getContainerFromIndex(int index) {
        return index >= 0 && index < this.containers.length ? this.containers[index] : EmptyContainer.INSTANCE;
    }

    private int getSlotFromIndex(int slot, int index) {
        return index > 0 && index < this.baseIndex.length ? slot - this.baseIndex[index - 1] : slot;
    }

    public int method_5439() {
        return this.totalSlots;
    }

    public boolean method_5442() {
        return Arrays.stream(this.containers).allMatch(class_1263::method_5442);
    }

    public class_1799 method_5438(int slot) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        class_1263 container = this.getContainerFromIndex(containerIndex);
        return container.method_5438(this.getSlotFromIndex(slot, containerIndex));
    }

    public class_1799 method_5434(int slot, int amount) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        class_1263 container = this.getContainerFromIndex(containerIndex);
        return container.method_5434(this.getSlotFromIndex(slot, containerIndex), amount);
    }

    public class_1799 method_5441(int slot) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        class_1263 container = this.getContainerFromIndex(containerIndex);
        return container.method_5441(this.getSlotFromIndex(slot, containerIndex));
    }

    public void method_5447(int slot, class_1799 itemStack) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        class_1263 container = this.getContainerFromIndex(containerIndex);
        container.method_5447(this.getSlotFromIndex(slot, containerIndex), itemStack);
    }

    public void method_5431() {
        for (class_1263 container : this.containers) {
            container.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        return Arrays.stream(this.containers).allMatch(container -> container.method_5443(player));
    }

    public void method_5448() {
        for (class_1263 container : this.containers) {
            container.method_5448();
        }
    }
}

