/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xaero.map.server.events.ServerEvents;
import xaero.map.server.level.LevelMapProperties;
import xaero.map.server.level.LevelMapPropertiesIO;

public class WorldMapServer {
    public static Logger LOGGER = LogManager.getLogger();
    private Map<Path, LevelMapProperties> levelProperties = new HashMap<Path, LevelMapProperties>();
    private LevelMapPropertiesIO propertiesIO = new LevelMapPropertiesIO();
    private ServerEvents serverEvents;

    public void load() {
        LOGGER.info("Loading Xaero's World Map - Stage 1/2 (Server)");
        this.serverEvents = new ServerEvents(this);
    }

    public void loadLater() {
        LOGGER.info("Loading Xaero's World Map - Stage 2/2 (Server)");
    }

    public LevelMapProperties getLevelProperties(Path path) {
        LevelMapProperties properties = this.levelProperties.get(path);
        if (properties == null) {
            properties = new LevelMapProperties();
            try {
                this.propertiesIO.load(path, properties);
            }
            catch (FileNotFoundException fnfe) {
                this.propertiesIO.save(path, properties);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.levelProperties.put(path, properties);
        }
        return properties;
    }

    public ServerEvents getServerEvents() {
        return this.serverEvents;
    }
}

