/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.util.Key;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Jankson;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonElement;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonNull;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonObject;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonPrimitive;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.api.DeserializationException;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.api.Marshaller;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.api.SyntaxError;

public class ShulkerBoxTooltipConfigSerializer
implements ConfigSerializer<Configuration> {
    private final Config definition;
    private final Jankson jankson;

    public ShulkerBoxTooltipConfigSerializer(Config definition, Class<?> configClass) {
        this(definition, configClass, ShulkerBoxTooltipConfigSerializer.buildJankson());
    }

    protected ShulkerBoxTooltipConfigSerializer(Config definition, Class<?> configClass, Jankson jankson) {
        this.definition = definition;
        this.jankson = jankson;
    }

    private static Jankson buildJankson() {
        Jankson.Builder builder = Jankson.builder();
        builder.registerDeserializer(JsonObject.class, Configuration.class, ShulkerBoxTooltipConfigSerializer::fromJson);
        builder.registerSerializer(Configuration.class, ShulkerBoxTooltipConfigSerializer::toJson);
        if (ShulkerBoxTooltip.isClient()) {
            builder.registerDeserializer(String.class, Key.class, (str, marshaller) -> {
                if (!ShulkerBoxTooltip.isClient()) {
                    return null;
                }
                return Key.fromTranslationKey(str);
            });
            builder.registerDeserializer(JsonObject.class, Key.class, (obj, marshaller) -> {
                if (!ShulkerBoxTooltip.isClient()) {
                    return null;
                }
                return Key.fromTranslationKey((String)obj.get(String.class, "code"));
            });
            builder.registerSerializer(Key.class, (key, marshaller) -> {
                JsonObject object = new JsonObject();
                if (!ShulkerBoxTooltip.isClient()) {
                    object.put("code", (JsonElement)JsonNull.INSTANCE);
                } else {
                    object.put("code", (JsonElement)new JsonPrimitive((Object)key.get().m_84874_()));
                }
                return object;
            });
        }
        return builder.build();
    }

    private static Configuration fromJson(JsonObject obj, Marshaller marshaller) {
        Configuration.ControlsCategory controlsCategory;
        Configuration cfg = new Configuration();
        Configuration.PreviewCategory previewCategory = (Configuration.PreviewCategory)marshaller.marshall(Configuration.PreviewCategory.class, (JsonElement)obj.getObject("preview"));
        Configuration.TooltipCategory tooltipCategory = (Configuration.TooltipCategory)marshaller.marshall(Configuration.TooltipCategory.class, (JsonElement)obj.getObject("tooltip"));
        Configuration.ServerCategory serverCategory = (Configuration.ServerCategory)marshaller.marshall(Configuration.ServerCategory.class, (JsonElement)obj.getObject("server"));
        if (previewCategory != null) {
            cfg.preview = previewCategory;
        }
        if (tooltipCategory != null) {
            cfg.tooltip = tooltipCategory;
        }
        if (serverCategory != null) {
            cfg.server = serverCategory;
        }
        if (ShulkerBoxTooltip.isClient() && (controlsCategory = (Configuration.ControlsCategory)marshaller.marshall(Configuration.ControlsCategory.class, (JsonElement)obj.getObject("controls"))) != null) {
            cfg.controls = controlsCategory;
        }
        return cfg;
    }

    private static JsonObject toJson(Configuration cfg, Marshaller marshaller) {
        JsonObject obj = new JsonObject();
        obj.put("preview", marshaller.serialize((Object)cfg.preview));
        obj.put("tooltip", marshaller.serialize((Object)cfg.tooltip));
        if (ShulkerBoxTooltip.isClient()) {
            obj.put("controls", marshaller.serialize((Object)cfg.controls));
        }
        obj.put("server", marshaller.serialize((Object)cfg.server));
        return obj;
    }

    public void serialize(Configuration config) throws ConfigSerializer.SerializationException {
        Path configPath = this.getConfigPath();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
            writer.write(this.jankson.toJson((Object)config).toJson(true, true));
            writer.close();
        }
        catch (IOException e) {
            throw new ConfigSerializer.SerializationException((Throwable)e);
        }
    }

    private Path getLegacyConfigPath() {
        return ShulkerBoxTooltip.getConfigDir().resolve(this.definition.name() + ".json");
    }

    private Configuration deserializeLegacy() {
        Path legacyConfigPath = this.getLegacyConfigPath();
        if (Files.exists(legacyConfigPath, new LinkOption[0])) {
            ShulkerBoxTooltip.LOGGER.info("[ShulkerBoxTooltip] Found legacy configuration file, attempting to load...");
            try {
                File file = legacyConfigPath.toFile();
                Configuration config = (Configuration)this.jankson.fromJson(this.jankson.load(file), Configuration.class);
                file.delete();
                ShulkerBoxTooltip.LOGGER.info("[ShulkerBoxTooltip] Loaded legacy configuration file!");
                return config;
            }
            catch (IOException | SyntaxError e) {
                ShulkerBoxTooltip.LOGGER.error("[ShulkerBoxTooltip] Could not load legacy configuration file", e);
            }
        }
        return null;
    }

    private Path getConfigPath() {
        return ShulkerBoxTooltip.getConfigDir().resolve(this.definition.name() + ".json5");
    }

    public Configuration deserialize() throws ConfigSerializer.SerializationException {
        Configuration config = this.deserializeLegacy();
        if (config != null) {
            return config;
        }
        Path configPath = this.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                JsonObject obj = this.jankson.load(configPath.toFile());
                return (Configuration)this.jankson.fromJsonCarefully(obj, Configuration.class);
            }
            catch (IOException | DeserializationException | SyntaxError e) {
                throw new ConfigSerializer.SerializationException(e);
            }
        }
        ShulkerBoxTooltip.LOGGER.info("[ShulkerBoxTooltip] Could not find configuration file, creating default file");
        return this.createDefault();
    }

    public Configuration createDefault() {
        return new Configuration();
    }
}

