/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.api;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltipClient;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProviderRegistry;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface ShulkerBoxTooltipApi {
    @Nullable
    public static PreviewProvider getPreviewProviderForStack(ItemStack stack) {
        return PreviewProviderRegistry.getInstance().get(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isPreviewAvailable(PreviewContext context) {
        if (ShulkerBoxTooltip.config.preview.enable) {
            PreviewProvider provider = ShulkerBoxTooltipApi.getPreviewProviderForStack(context.stack());
            return provider != null && provider.shouldDisplay(context) && ShulkerBoxTooltipApi.getCurrentPreviewType(provider.isFullPreviewAvailable(context)) != PreviewType.NO_PREVIEW;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static PreviewType getCurrentPreviewType(boolean hasFullPreviewMode) {
        boolean shouldDisplay = ShulkerBoxTooltipClient.shouldDisplayPreview();
        if (shouldDisplay && !hasFullPreviewMode) {
            return PreviewType.COMPACT;
        }
        if (ShulkerBoxTooltip.config.preview.swapModes) {
            if (shouldDisplay) {
                return ShulkerBoxTooltipApi.isFullPreviewKeyPressed() ? PreviewType.COMPACT : PreviewType.FULL;
            }
        } else if (shouldDisplay) {
            return ShulkerBoxTooltipApi.isFullPreviewKeyPressed() ? PreviewType.FULL : PreviewType.COMPACT;
        }
        return PreviewType.NO_PREVIEW;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isPreviewKeyPressed() {
        return ShulkerBoxTooltipClient.isPreviewKeyPressed();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isFullPreviewKeyPressed() {
        return ShulkerBoxTooltipClient.isFullPreviewKeyPressed();
    }

    public static boolean hasModAvailable(ServerPlayer player) {
        return ServerNetworking.hasModAvailable(player);
    }

    public void registerProviders(PreviewProviderRegistry var1);
}

