/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking;

import io.netty.buffer.ByteBuf;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.AbstractNetworkAddon;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.GenericFutureListenerHolder;
import net.fabricmc.fabric.impl.networking.GlobalReceiverRegistry;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.minecraft.class_151;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_7648;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChanneledNetworkAddon<H>
extends AbstractNetworkAddon<H>
implements PacketSender {
    protected final class_2535 connection;
    protected final GlobalReceiverRegistry<H> receiver;
    protected final Set<class_2960> sendableChannels;
    protected final Set<class_2960> sendableChannelsView;

    protected AbstractChanneledNetworkAddon(GlobalReceiverRegistry<H> receiver, class_2535 connection, String description) {
        this(receiver, connection, new HashSet<class_2960>(), description);
    }

    protected AbstractChanneledNetworkAddon(GlobalReceiverRegistry<H> receiver, class_2535 connection, Set<class_2960> sendableChannels, String description) {
        super(receiver, description);
        this.connection = connection;
        this.receiver = receiver;
        this.sendableChannels = sendableChannels;
        this.sendableChannelsView = Collections.unmodifiableSet(sendableChannels);
    }

    public abstract void lateInit();

    protected void registerPendingChannels(ChannelInfoHolder holder) {
        Collection<class_2960> pending = holder.getPendingChannelsNames();
        if (!pending.isEmpty()) {
            this.register(new ArrayList<class_2960>(pending));
            pending.clear();
        }
    }

    protected boolean handle(class_2960 channelName, class_2540 originalBuf) {
        this.logger.debug("Handling inbound packet from channel with name \"{}\"", (Object)channelName);
        if (NetworkingImpl.REGISTER_CHANNEL.equals((Object)channelName)) {
            this.receiveRegistration(true, PacketByteBufs.slice((ByteBuf)originalBuf));
            return true;
        }
        if (NetworkingImpl.UNREGISTER_CHANNEL.equals((Object)channelName)) {
            this.receiveRegistration(false, PacketByteBufs.slice((ByteBuf)originalBuf));
            return true;
        }
        @Nullable H handler = this.getHandler(channelName);
        if (handler == null) {
            return false;
        }
        class_2540 buf = PacketByteBufs.slice((ByteBuf)originalBuf);
        try {
            this.receive(handler, buf);
        }
        catch (Throwable ex) {
            this.logger.error("Encountered exception while handling in channel with name \"{}\"", (Object)channelName, (Object)ex);
            throw ex;
        }
        return true;
    }

    protected abstract void receive(H var1, class_2540 var2);

    protected void sendInitialChannelRegistrationPacket() {
        class_2540 buf = this.createRegistrationPacket(this.getReceivableChannels());
        if (buf != null) {
            this.sendPacket(NetworkingImpl.REGISTER_CHANNEL, buf);
        }
    }

    @Nullable
    protected class_2540 createRegistrationPacket(Collection<class_2960> channels) {
        if (channels.isEmpty()) {
            return null;
        }
        class_2540 buf = PacketByteBufs.create();
        boolean first = true;
        for (class_2960 channel : channels) {
            if (first) {
                first = false;
            } else {
                buf.writeByte(0);
            }
            buf.writeBytes(channel.toString().getBytes(StandardCharsets.US_ASCII));
        }
        return buf;
    }

    protected void receiveRegistration(boolean register, class_2540 buf) {
        ArrayList<class_2960> ids = new ArrayList<class_2960>();
        StringBuilder active = new StringBuilder();
        while (buf.isReadable()) {
            byte b = buf.readByte();
            if (b != 0) {
                active.append(AsciiString.b2c((byte)b));
                continue;
            }
            this.addId(ids, active);
            active = new StringBuilder();
        }
        this.addId(ids, active);
        this.schedule(register ? () -> this.register(ids) : () -> this.unregister(ids));
    }

    void register(List<class_2960> ids) {
        this.sendableChannels.addAll(ids);
        this.invokeRegisterEvent(ids);
    }

    void unregister(List<class_2960> ids) {
        this.sendableChannels.removeAll(ids);
        this.invokeUnregisterEvent(ids);
    }

    @Override
    public void sendPacket(class_2596<?> packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.method_10743(packet);
    }

    @Override
    public void sendPacket(class_2596<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
        this.sendPacket(packet, GenericFutureListenerHolder.create(callback));
    }

    @Override
    public void sendPacket(class_2596<?> packet, class_7648 callback) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.method_10752(packet, callback);
    }

    protected abstract void schedule(Runnable var1);

    protected abstract void invokeRegisterEvent(List<class_2960> var1);

    protected abstract void invokeUnregisterEvent(List<class_2960> var1);

    private void addId(List<class_2960> ids, StringBuilder sb) {
        String literal = sb.toString();
        try {
            ids.add(new class_2960(literal));
        }
        catch (class_151 ex) {
            this.logger.warn("Received invalid channel identifier \"{}\" from connection {}", (Object)literal, (Object)this.connection);
        }
    }

    public Set<class_2960> getSendableChannels() {
        return this.sendableChannelsView;
    }
}

