/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.loader.client;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_315;
import net.minecraft.class_3262;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_315.class})
public class GameOptionsMixin {
    @Shadow
    public List<String> field_1887;
    @Shadow
    @Final
    static Logger field_1834;

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void onLoad(CallbackInfo ci) {
        File dataDir = FabricLoader.getInstance().getGameDir().resolve("data").toFile();
        if (!dataDir.exists() && !dataDir.mkdirs()) {
            field_1834.warn("[Fabric Resource Loader] Could not create data directory: " + dataDir.getAbsolutePath());
        }
        File trackerFile = new File(dataDir, "fabricDefaultResourcePacks.dat");
        HashSet<class_2960> trackedPacks = new HashSet<class_2960>();
        if (trackerFile.exists()) {
            try {
                class_2487 data = class_2507.method_30613((File)trackerFile);
                class_2499 values = data.method_10554("values", 8);
                for (int i = 0; i < values.size(); ++i) {
                    trackedPacks.add(new class_2960(values.method_10608(i)));
                }
            }
            catch (IOException e) {
                field_1834.warn("[Fabric Resource Loader] Could not read " + trackerFile.getAbsolutePath(), (Throwable)e);
            }
        }
        HashSet removedPacks = new HashSet(trackedPacks);
        LinkedHashSet<String> resourcePacks = new LinkedHashSet<String>(this.field_1887);
        ArrayList profiles = new ArrayList();
        ModResourcePackCreator.CLIENT_RESOURCE_PACK_PROVIDER.register(profiles::add);
        for (Object profile : profiles) {
            ModNioResourcePack builtinPack;
            if (profile.method_29483() == ModResourcePackCreator.RESOURCE_PACK_SOURCE) {
                resourcePacks.add(profile.method_14463());
                continue;
            }
            class_3262 pack = profile.method_14458();
            if (!(pack instanceof ModNioResourcePack) || !(builtinPack = (ModNioResourcePack)pack).getActivationType().isEnabledByDefault()) continue;
            if (trackedPacks.add(builtinPack.getId())) {
                resourcePacks.add(profile.method_14463());
                continue;
            }
            removedPacks.remove(builtinPack.getId());
        }
        try {
            class_2499 values = new class_2499();
            for (class_2960 id : trackedPacks) {
                if (removedPacks.contains(id)) continue;
                values.add((Object)class_2519.method_23256((String)id.toString()));
            }
            class_2487 nbt = new class_2487();
            nbt.method_10566("values", (class_2520)values);
            class_2507.method_30614((class_2487)nbt, (File)trackerFile);
        }
        catch (IOException e) {
            field_1834.warn("[Fabric Resource Loader] Could not write to " + trackerFile.getAbsolutePath(), (Throwable)e);
        }
        this.field_1887 = new ArrayList<String>(resourcePacks);
    }
}

