/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.impl.resource.loader.FabricNamespaceResourceManagerEntry;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.fabric.mixin.resource.loader.NamespaceResourceManagerAccessor;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3266;
import net.minecraft.class_3294;

public abstract class GroupResourcePack
implements class_3262 {
    protected final class_3264 type;
    protected final List<ModResourcePack> packs;
    protected final Map<String, List<ModResourcePack>> namespacedPacks = new Object2ObjectOpenHashMap();

    public GroupResourcePack(class_3264 type, List<ModResourcePack> packs) {
        this.type = type;
        this.packs = packs;
        this.packs.forEach(pack -> pack.method_14406(this.type).forEach(namespace -> this.namespacedPacks.computeIfAbsent((String)namespace, value -> new ArrayList()).add(pack)));
    }

    public InputStream method_14405(class_3264 type, class_2960 id) throws IOException {
        List<ModResourcePack> packs = this.namespacedPacks.get(id.method_12836());
        if (packs != null) {
            for (int i = packs.size() - 1; i >= 0; --i) {
                class_3262 pack = packs.get(i);
                if (!pack.method_14411(type, id)) continue;
                return pack.method_14405(type, id);
            }
        }
        throw new class_3266(null, String.format("%s/%s/%s", type.method_14413(), id.method_12836(), id.method_12832()));
    }

    public Collection<class_2960> method_14408(class_3264 type, String namespace, String prefix, Predicate<class_2960> predicate) {
        List<ModResourcePack> packs = this.namespacedPacks.get(namespace);
        if (packs == null) {
            return Collections.emptyList();
        }
        HashSet<class_2960> resources = new HashSet<class_2960>();
        for (int i = packs.size() - 1; i >= 0; --i) {
            class_3262 pack = packs.get(i);
            Collection modResources = pack.method_14408(type, namespace, prefix, predicate);
            resources.addAll(modResources);
        }
        return resources;
    }

    public boolean method_14411(class_3264 type, class_2960 id) {
        List<ModResourcePack> packs = this.namespacedPacks.get(id.method_12836());
        if (packs == null) {
            return false;
        }
        for (int i = packs.size() - 1; i >= 0; --i) {
            class_3262 pack = packs.get(i);
            if (!pack.method_14411(type, id)) continue;
            return true;
        }
        return false;
    }

    public Set<String> method_14406(class_3264 type) {
        return this.namespacedPacks.keySet();
    }

    public void appendResources(NamespaceResourceManagerAccessor manager, class_2960 id, List<class_3294.class_7083> resources) {
        List<ModResourcePack> packs = this.namespacedPacks.get(id.method_12836());
        if (packs == null) {
            return;
        }
        class_2960 metadataId = NamespaceResourceManagerAccessor.fabric$accessor_getMetadataPath(id);
        for (ModResourcePack pack : packs) {
            if (!pack.method_14411(manager.getType(), id)) continue;
            class_3294 class_32942 = (class_3294)manager;
            Objects.requireNonNull(class_32942);
            class_3294.class_7083 entry = new class_3294.class_7083(class_32942, id, metadataId, (class_3262)pack);
            ((FabricNamespaceResourceManagerEntry)entry).setFabricPackSource(ModResourcePackCreator.RESOURCE_PACK_SOURCE);
            resources.add(entry);
        }
    }

    public String getFullName() {
        return this.method_14409() + " (" + this.packs.stream().map(class_3262::method_14409).collect(Collectors.joining(", ")) + ")";
    }

    public void close() {
        this.packs.forEach(class_3262::close);
    }
}

