/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Function;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.fabric.impl.client.indigo.IndigoMixinConfigPlugin;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoConfig;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class Indigo
implements ClientModInitializer {
    public static final boolean ALWAYS_TESSELATE_INDIGO;
    public static final boolean ENSURE_VERTEX_FORMAT_COMPATIBILITY;
    public static final AoConfig AMBIENT_OCCLUSION_MODE;
    public static final boolean DEBUG_COMPARE_LIGHTING;
    public static final boolean FIX_SMOOTH_LIGHTING_OFFSET;
    public static final boolean FIX_EXTERIOR_VERTEX_LIGHTING;
    public static final boolean FIX_LUMINOUS_AO_SHADE;
    public static final Logger LOGGER;

    private static boolean asBoolean(String property, boolean defValue) {
        switch (Indigo.asTriState(property)) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        return defValue;
    }

    private static <T extends Enum> T asEnum(String property, T defValue) {
        if (property == null || property.isEmpty()) {
            return defValue;
        }
        for (Enum obj : (Enum[])defValue.getClass().getEnumConstants()) {
            if (!property.equalsIgnoreCase(obj.name())) continue;
            return (T)obj;
        }
        return defValue;
    }

    private static TriState asTriState(String property) {
        if (property == null || property.isEmpty()) {
            return TriState.DEFAULT;
        }
        switch (property.toLowerCase(Locale.ROOT)) {
            case "true": {
                return TriState.TRUE;
            }
            case "false": {
                return TriState.FALSE;
            }
        }
        return TriState.DEFAULT;
    }

    public void onInitializeClient() {
        if (IndigoMixinConfigPlugin.shouldApplyIndigo()) {
            LOGGER.info("[Indigo] Registering Indigo renderer!");
            if (IndigoMixinConfigPlugin.shouldForceCompatibility()) {
                LOGGER.info("[Indigo] Compatibility mode enabled.");
            }
            RendererAccess.INSTANCE.registerRenderer((Renderer)IndigoRenderer.INSTANCE);
        } else {
            LOGGER.info("[Indigo] Different rendering plugin detected; not applying Indigo.");
        }
    }

    static {
        boolean forceCompatibility;
        LOGGER = LoggerFactory.getLogger(Indigo.class);
        File configDir = FabricLoader.getInstance().getConfigDir().resolve("fabric").toFile();
        if (!configDir.exists() && !configDir.mkdir()) {
            LOGGER.warn("[Indigo] Could not create configuration directory: " + configDir.getAbsolutePath());
        }
        File configFile = new File(configDir, "indigo-renderer.properties");
        Properties properties = new Properties();
        if (configFile.exists()) {
            try (FileInputStream stream = new FileInputStream(configFile);){
                properties.load(stream);
            }
            catch (IOException e) {
                LOGGER.warn("[Indigo] Could not read property file '" + configFile.getAbsolutePath() + "'", (Throwable)e);
            }
        }
        ENSURE_VERTEX_FORMAT_COMPATIBILITY = forceCompatibility = IndigoMixinConfigPlugin.shouldForceCompatibility();
        ALWAYS_TESSELATE_INDIGO = !forceCompatibility && Indigo.asBoolean((String)properties.computeIfAbsent("always-tesselate-blocks", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), true);
        AMBIENT_OCCLUSION_MODE = Indigo.asEnum((String)properties.computeIfAbsent("ambient-occlusion-mode", (Function<? super Object, ?>)((Function<Object, Object>)a -> "hybrid")), AoConfig.HYBRID);
        DEBUG_COMPARE_LIGHTING = Indigo.asBoolean((String)properties.computeIfAbsent("debug-compare-lighting", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), false);
        FIX_SMOOTH_LIGHTING_OFFSET = Indigo.asBoolean((String)properties.computeIfAbsent("fix-smooth-lighting-offset", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), true);
        FIX_EXTERIOR_VERTEX_LIGHTING = Indigo.asBoolean((String)properties.computeIfAbsent("fix-exterior-vertex-lighting", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), true);
        FIX_LUMINOUS_AO_SHADE = Indigo.asBoolean((String)properties.computeIfAbsent("fix-luminous-block-ambient-occlusion", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), false);
        try (FileOutputStream stream = new FileOutputStream(configFile);){
            properties.store(stream, "Indigo properties file");
        }
        catch (IOException e) {
            LOGGER.warn("[Indigo] Could not store property file '" + configFile.getAbsolutePath() + "'", (Throwable)e);
        }
    }
}

