/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.base;

import dev.onyxstudios.cca.internal.base.asm.StaticComponentLoadingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ComponentsInternals {
    public static final Logger LOGGER = LogManager.getLogger((String)"Cardinal Components API");

    @Nonnull
    public static <R> R createFactory(Class<R> factoryClass) {
        try {
            Object[] constructors = factoryClass.getConstructors();
            if (constructors.length != 1) {
                throw new IllegalArgumentException("Expected 1 constructor declaration in " + factoryClass + ", got " + Arrays.toString(constructors));
            }
            Object ret = constructors[0].newInstance(new Object[0]);
            return (R)ret;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new StaticComponentLoadingException("Failed to instantiate generated component factory", e);
        }
    }
}

