/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.registry.sync;

import com.mojang.serialization.Lifecycle;
import java.util.Set;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.impl.registry.sync.RegistrySyncManager;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2370.class})
public abstract class MixinSimpleRegistry<T>
extends class_2378<T> {
    @Unique
    private static final Logger FARBIC_LOGGER = LoggerFactory.getLogger((String)"FabricRegistrySync");
    @Unique
    private static final Set<String> VANILLA_NAMESPACES = Set.of("minecraft", "brigadier");

    protected MixinSimpleRegistry(class_5321<class_2378<T>> arg, Lifecycle lifecycle) {
        super(arg, lifecycle);
    }

    @Inject(method={"add"}, at={@At(value="RETURN")})
    private <V extends T> void add(class_5321<class_2378<T>> registryKey, V entry, Lifecycle lifecycle, CallbackInfoReturnable<V> info) {
        this.onChange(registryKey);
    }

    @Inject(method={"set"}, at={@At(value="RETURN")})
    private <V extends T> void set(int rawId, class_5321<class_2378<T>> registryKey, V entry, Lifecycle lifecycle, CallbackInfoReturnable<V> info) {
        this.onChange(registryKey);
    }

    @Unique
    private void onChange(class_5321<class_2378<T>> registryKey) {
        RegistryAttributeHolder holder;
        if (!(!RegistrySyncManager.postBootstrap && VANILLA_NAMESPACES.contains(registryKey.method_29177().method_12836()) || (holder = RegistryAttributeHolder.get(this)).hasAttribute(RegistryAttribute.MODDED))) {
            class_2960 id = this.method_30517().method_29177();
            FARBIC_LOGGER.debug("Registry {} has been marked as modded, registry entry {} was changed", (Object)id, (Object)registryKey.method_29177());
            RegistryAttributeHolder.get(this).addAttribute(RegistryAttribute.MODDED);
        }
    }
}

