/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.hypherionmc.shaded.moonconfig.core.CommentedConfig;
import me.hypherionmc.shaded.moonconfig.core.Config;
import me.hypherionmc.shaded.moonconfig.core.UnmodifiableConfig;
import me.hypherionmc.shaded.moonconfig.core.conversion.ObjectConverter;
import me.hypherionmc.shaded.moonconfig.core.file.CommentedFileConfig;
import me.hypherionmc.simplerpclib.RPCConstants;
import me.hypherionmc.simplerpclib.configuration.ClientConfig;
import me.hypherionmc.simplerpclib.configuration.ServerConfig;
import me.hypherionmc.simplerpclib.configuration.ServerEntriesConfig;
import me.hypherionmc.simplerpclib.configuration.objects.Dimension;
import me.hypherionmc.simplerpclib.configuration.objects.GeneralConfig;
import me.hypherionmc.simplerpclib.discord.RichPresenceCore;

public class ConfigEngine {
    public static ClientConfig loadConfig(RichPresenceCore core) {
        File langDir = new File(core.getConfigPath() + "/simple-rpc/");
        File oldDefaultConf = new File(core.getConfigPath() + "/config/simple-rpc.toml");
        File defaultConf = new File(langDir.getAbsolutePath() + "/simple-rpc.toml");
        File bakConf = new File(core.getConfigPath() + "/config/simple-rpc.bak");
        if (!langDir.exists()) {
            langDir.mkdirs();
        }
        if (bakConf.exists()) {
            bakConf.delete();
        }
        if (oldDefaultConf.exists()) {
            ConfigEngine.migrateConfig(defaultConf, oldDefaultConf);
        }
        File translatedConf = new File(langDir.getAbsolutePath() + "/simple-rpc_" + core.getLangCode() + ".toml");
        ClientConfig clientConfig = null;
        try {
            File finalConfig;
            if (!defaultConf.exists()) {
                clientConfig = new ClientConfig();
                clientConfig.dimension_overrides.dimensions.add(new Dimension("overworld", "%player% is in The Overworld", "", "overworld", "In the Overworld", "mclogo", "%mods% mods installed"));
                clientConfig.dimension_overrides.dimensions.add(new Dimension("the_nether", "%player% is in The Nether", "", "nether", "In the Nether", "mclogo", "%mods% mods installed"));
                clientConfig.dimension_overrides.dimensions.add(new Dimension("the_end", "%player% is in The End", "", "end", "In the End", "mclogo", "%mods% mods installed"));
                ConfigEngine.saveConfig(clientConfig, defaultConf);
                RPCConstants.logger.warn("A config file has been created.\nPlease edit " + defaultConf.getAbsolutePath() + " to specify your RPC details");
            }
            File file = finalConfig = translatedConf.exists() ? translatedConf : defaultConf;
            if (finalConfig.exists()) {
                finalConfig = ConfigEngine.migrateConfig(finalConfig);
            }
            if ((clientConfig = ConfigEngine.loadConfig(finalConfig)) == null) {
                RPCConstants.logger.error("Could not load config file. Something unknown went wrong");
            } else {
                clientConfig.configPath = finalConfig.getAbsolutePath();
            }
        }
        catch (Exception e) {
            RPCConstants.logger.error("Could not load config file. Something went wrong!", (Throwable)e);
        }
        return clientConfig == null ? new ClientConfig() : clientConfig;
    }

    private static ClientConfig loadConfig(File configPath) {
        Config.setInsertionOrderPreserved(true);
        ObjectConverter converter = new ObjectConverter();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configPath).build();
        config.load();
        return converter.toObject((UnmodifiableConfig)config, ClientConfig::new);
    }

    public static void saveConfig(Object conf, File configPath) {
        Config.setInsertionOrderPreserved(true);
        ObjectConverter converter = new ObjectConverter();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configPath).build();
        converter.toConfig(conf, (Config)config);
        config.save();
    }

    private static File migrateConfig(File configFile) {
        return ConfigEngine.migrateConfig(configFile, null);
    }

    private static File migrateConfig(File configFile, File migrateConf) {
        Config.setInsertionOrderPreserved(true);
        CommentedFileConfig oldConfig = (CommentedFileConfig)CommentedFileConfig.builder(migrateConf == null ? configFile : migrateConf).build();
        CommentedFileConfig newConfig = (CommentedFileConfig)CommentedFileConfig.builder(configFile).build();
        oldConfig.load();
        if (oldConfig.getInt("general.version") != GeneralConfig.version) {
            ObjectConverter converter = new ObjectConverter();
            converter.toConfig((Object)new ClientConfig(), (Config)newConfig);
            oldConfig.valueMap().forEach((s, o) -> {
                if (s.equalsIgnoreCase("world_images")) {
                    newConfig.set("dimension_overrides.enabled", oldConfig.get("world_images.enabled"));
                    List commentedConfigs = (List)oldConfig.get("world_images.worlds");
                    ArrayList newCommentedConfigs = new ArrayList();
                    if (!commentedConfigs.isEmpty()) {
                        commentedConfigs.forEach(commentedConfig -> {
                            CommentedConfig retConfig = CommentedConfig.inMemory();
                            retConfig.set("name", commentedConfig.get("worldname"));
                            retConfig.set("description", (Object)"");
                            retConfig.set("state", (Object)"");
                            retConfig.set("largeImageKey", commentedConfig.get("largeImageKey"));
                            retConfig.set("largeImageText", commentedConfig.get("largeImageText"));
                            retConfig.set("smallImageKey", commentedConfig.get("smallImageKey"));
                            retConfig.set("smallImageText", commentedConfig.get("smallImageText"));
                            newCommentedConfigs.add(retConfig);
                        });
                    }
                    newConfig.set("dimension_overrides.dimensions", newCommentedConfigs);
                } else if (o instanceof CommentedConfig) {
                    CommentedConfig config1 = (CommentedConfig)o;
                    config1.valueMap().forEach((ss, oo) -> {
                        if (ss.equalsIgnoreCase("clientID")) {
                            ss = "applicationID";
                        }
                        newConfig.set(s + "." + ss, oo);
                    });
                } else {
                    newConfig.set((String)s, o);
                }
            });
            List commentedConfig = (List)newConfig.get("dimension_overrides.dimensions");
            if (!commentedConfig.isEmpty()) {
                commentedConfig.forEach(dim -> {
                    if (!dim.contains("buttons")) {
                        dim.add("buttons", new ArrayList());
                    }
                });
                newConfig.set("dimension_overrides.dimensions", (Object)commentedConfig);
            }
            configFile.renameTo(new File(configFile.getAbsolutePath().replace(".toml", ".bak")));
            newConfig.set("general.version", (Object)GeneralConfig.version);
            newConfig.save();
            newConfig.close();
            oldConfig.close();
            if (migrateConf != null) {
                migrateConf.delete();
            }
        }
        return newConfig.getFile();
    }

    public static ServerEntriesConfig loadServerEntries(RichPresenceCore core) {
        ServerEntriesConfig config = null;
        try {
            File langDir = new File(core.getConfigPath() + "/simple-rpc/");
            if (!langDir.exists()) {
                langDir.mkdirs();
            }
            File configFile = new File(langDir + "/server-entries_" + core.getLangCode() + ".toml");
            File configFile2 = new File(langDir + "/server-entries.toml");
            if (!configFile.exists() && !configFile2.exists()) {
                ServerEntriesConfig config1 = new ServerEntriesConfig();
                ConfigEngine.saveConfig(config1, configFile2);
            }
            if (configFile.exists() && (config = ConfigEngine.loadServerEntries(configFile)) != null) {
                config.configPath = configFile.getAbsolutePath();
            }
            if (!configFile.exists() && configFile2.exists() && (config = ConfigEngine.loadServerEntries(configFile2)) != null) {
                config.configPath = configFile2.getAbsolutePath();
            }
        }
        catch (Exception e) {
            RPCConstants.logger.error("Could not load config file. Something went wrong!", (Throwable)e);
        }
        return config == null ? new ServerEntriesConfig() : config;
    }

    private static ServerEntriesConfig loadServerEntries(File configPath) {
        try {
            Config.setInsertionOrderPreserved(true);
            ObjectConverter converter = new ObjectConverter();
            CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configPath).build();
            config.load();
            return converter.toObject((UnmodifiableConfig)config, ServerEntriesConfig::new);
        }
        catch (Exception exception) {
            return new ServerEntriesConfig();
        }
    }

    public static ServerConfig loadServerConfig(String configPath) {
        ServerConfig config = null;
        try {
            File confDir = new File(configPath + "/config/");
            File configFile = new File(configPath + "/config/simple-rpc-server.toml");
            if (!confDir.exists()) {
                confDir.mkdirs();
            }
            if (!configFile.exists()) {
                ServerConfig conf = new ServerConfig();
                conf.dimension_overrides.dimensions.add(new Dimension("overworld", "%player% is in The Overworld", "", "overworld", "In the Overworld", "mclogo", "%mods% mods installed"));
                conf.dimension_overrides.dimensions.add(new Dimension("the_nether", "%player% is in The Nether", "", "nether", "In the Nether", "mclogo", "%mods% mods installed"));
                conf.dimension_overrides.dimensions.add(new Dimension("the_end", "%player% is in The End", "", "end", "In the End", "mclogo", "%mods% mods installed"));
                ConfigEngine.saveConfig(conf, configFile);
                RPCConstants.logger.error("A config file has been created.\nPlease edit " + configFile.getAbsolutePath() + " to specify your RPC details");
            }
            if (configFile.exists()) {
                configFile = ConfigEngine.migrateOldServerConfig(configFile);
            }
            if ((config = ConfigEngine.loadServerConfig(configFile)) == null) {
                RPCConstants.logger.error("Could not load config file. Something went wrong!");
            }
        }
        catch (Exception e) {
            RPCConstants.logger.error("Could not load config file. Something went wrong!", (Throwable)e);
        }
        return config == null ? new ServerConfig() : config;
    }

    private static ServerConfig loadServerConfig(File configPath) {
        Config.setInsertionOrderPreserved(true);
        ObjectConverter converter = new ObjectConverter();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configPath).build();
        config.load();
        return converter.toObject((UnmodifiableConfig)config, ServerConfig::new);
    }

    public static File migrateOldServerConfig(File configFile) {
        Config.setInsertionOrderPreserved(true);
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configFile).build();
        CommentedFileConfig config2 = (CommentedFileConfig)CommentedFileConfig.builder(configFile).build();
        config2.load();
        config2.clear();
        config.load();
        if (config.getInt("general.version") != ServerConfig.version) {
            ObjectConverter converter = new ObjectConverter();
            converter.toConfig((Object)new ServerConfig(), (Config)config2);
            config.valueMap().forEach((s, o) -> {
                if (s.equalsIgnoreCase("world_images")) {
                    config2.set("dimension_overrides.enabled", config.get("world_images.enabled"));
                    List commentedConfigs = (List)config.get("world_images.worlds");
                    ArrayList newCommentedConfigs = new ArrayList();
                    if (!commentedConfigs.isEmpty()) {
                        commentedConfigs.forEach(commentedConfig -> {
                            CommentedConfig retConfig = CommentedConfig.inMemory();
                            retConfig.set("name", commentedConfig.get("worldname"));
                            retConfig.set("description", (Object)"");
                            retConfig.set("state", (Object)"");
                            retConfig.set("largeImageKey", commentedConfig.get("largeImageKey"));
                            retConfig.set("largeImageText", commentedConfig.get("largeImageText"));
                            retConfig.set("smallImageKey", commentedConfig.get("smallImageKey"));
                            retConfig.set("smallImageText", commentedConfig.get("smallImageText"));
                            newCommentedConfigs.add(retConfig);
                        });
                    }
                    config2.set("dimension_overrides.dimensions", newCommentedConfigs);
                } else if (o instanceof CommentedConfig) {
                    CommentedConfig config1 = (CommentedConfig)o;
                    config1.valueMap().forEach((ss, oo) -> config2.set(s + "." + ss, oo));
                } else {
                    config2.set((String)s, o);
                }
            });
            List commentedConfig = (List)config2.get("dimension_overrides.dimensions");
            if (!commentedConfig.isEmpty()) {
                commentedConfig.forEach(dim -> {
                    if (!dim.contains("buttons")) {
                        dim.add("buttons", new ArrayList());
                    }
                });
                config2.set("dimension_overrides.dimensions", (Object)commentedConfig);
            }
            configFile.renameTo(new File(configFile.getAbsolutePath().replace(".toml", ".bak")));
            config2.set("general.version", (Object)ServerConfig.version);
            config2.save();
        }
        return config2.getFile();
    }
}

