/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import net.minecraft.class_1041;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_768;
import snownee.jade.Jade;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.overlay.RayTracing;

public class TooltipRenderer {
    private final Tooltip tooltip;
    private final boolean showIcon;
    private class_241 totalSize;
    private float contentHeight;
    IElement icon;

    public TooltipRenderer(Tooltip tooltip, boolean showIcon) {
        this.showIcon = showIcon;
        this.tooltip = tooltip;
        if (showIcon) {
            this.icon = RayTracing.INSTANCE.getIcon();
        }
        this.computeSize();
    }

    public float getPadding() {
        return 2.0f;
    }

    public void computeSize() {
        float width = 0.0f;
        float height = 0.0f;
        for (Tooltip.Line line : this.tooltip.lines) {
            class_241 size = line.getSize();
            width = Math.max(width, size.field_1343);
            height += size.field_1342;
        }
        this.contentHeight = height;
        float padding = this.getPadding() * 2.0f;
        if (this.hasIcon()) {
            class_241 size = this.icon.getCachedSize();
            width += 2.0f + size.field_1343;
            height = Math.max(height, size.field_1342 - 2.0f);
        }
        this.totalSize = new class_241(width += padding + 4.0f, height += padding);
    }

    public void draw(class_4587 matrixStack) {
        float padding = this.getPadding();
        float x = padding + 3.0f;
        float y = padding + 1.0f;
        if (this.hasIcon()) {
            x += this.icon.getCachedSize().field_1343 + 2.0f;
            if (this.icon.getCachedSize().field_1342 > this.contentHeight) {
                y += (this.icon.getCachedSize().field_1342 - this.contentHeight) / 2.0f - 1.0f;
            }
        }
        for (Tooltip.Line line : this.tooltip.lines) {
            class_241 size = line.getSize();
            line.render(matrixStack, x, y, this.totalSize.field_1343 - padding - 1.0f, size.field_1342);
            y += size.field_1342;
        }
        if (this.tooltip.sneakyDetails) {
            class_310 mc = class_310.method_1551();
            x = (this.totalSize.field_1343 - (float)mc.field_1772.method_1727("\u25be") + 1.0f) / 2.0f;
            float yOffset = OverlayRenderer.ticks / 5.0f % 8.0f - 2.0f;
            if (yOffset > 4.0f) {
                return;
            }
            y = this.totalSize.field_1342 - 6.0f + yOffset;
            float alpha = 1.0f - Math.abs(yOffset) / 2.0f;
            int alphaChannel = (int)(255.0f * class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f));
            if (alphaChannel > 4) {
                mc.field_1772.method_1729(matrixStack, "\u25be", x, y, 0xFFFFFF | alphaChannel << 24);
            }
        }
    }

    public Tooltip getTooltip() {
        return this.tooltip;
    }

    public boolean hasIcon() {
        return this.showIcon && Jade.CONFIG.get().getOverlay().shouldShowIcon() && this.icon != null;
    }

    public class_768 getPosition() {
        class_1041 window = class_310.method_1551().method_22683();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        int x = (int)((float)window.method_4486() * overlay.tryFlip(overlay.getOverlayPosX()));
        int y = (int)((float)window.method_4502() * (1.0f - overlay.getOverlayPosY()));
        int width = (int)this.totalSize.field_1343;
        int height = (int)this.totalSize.field_1342;
        return new class_768(x, y, width, height);
    }

    public class_241 getSize() {
        return this.totalSize;
    }
}

