/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import snownee.jade.Jade;
import snownee.jade.api.IToggleableProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.impl.config.ConfigEntry;
import snownee.jade.util.JsonConfig;
import snownee.jade.util.PlatformProxy;

public class PluginConfig
implements IPluginConfig {
    public static final PluginConfig INSTANCE = new PluginConfig();
    public static final String FILE_NAME = "jade/plugins.json";
    private final Map<class_2960, ConfigEntry> configs = Maps.newHashMap();

    private PluginConfig() {
    }

    public void addConfig(ConfigEntry entry) {
        this.configs.put(entry.getId(), entry);
    }

    @Override
    public Set<class_2960> getKeys(String namespace) {
        return this.getKeys().stream().filter(id -> id.method_12836().equals(namespace)).collect(Collectors.toSet());
    }

    @Override
    public Set<class_2960> getKeys() {
        return this.configs.keySet();
    }

    @Override
    public boolean get(IToggleableProvider provider) {
        if (provider.isRequired()) {
            return true;
        }
        return this.get(provider.getUid(), provider.enabledByDefault());
    }

    @Override
    public boolean get(class_2960 key, boolean defaultValue) {
        ConfigEntry entry = this.configs.get(key);
        return entry == null ? defaultValue : entry.getValue();
    }

    public Set<ConfigEntry> getSyncableConfigs() {
        return this.configs.values().stream().filter(ConfigEntry::isSynced).collect(Collectors.toSet());
    }

    public List<String> getNamespaces() {
        return this.configs.keySet().stream().sorted((o1, o2) -> o1.method_12836().compareToIgnoreCase(o2.method_12836())).map(class_2960::method_12836).distinct().collect(Collectors.toList());
    }

    public ConfigEntry getEntry(class_2960 key) {
        return this.configs.get(key);
    }

    public void set(class_2960 key, boolean value) {
        ConfigEntry entry = this.configs.computeIfAbsent(key, k -> new ConfigEntry((class_2960)k, value, true));
        entry.setValue(value);
    }

    public void reload() {
        File configFile = new File(PlatformProxy.getConfigDirectory(), FILE_NAME);
        if (!configFile.exists()) {
            this.writeConfig(configFile, true);
        } else {
            Map config;
            try (FileReader reader = new FileReader(configFile, StandardCharsets.UTF_8);){
                config = (Map)new Gson().fromJson((Reader)reader, new TypeToken<Map<String, Map<String, Boolean>>>(){}.getType());
            }
            catch (Exception e) {
                e.printStackTrace();
                config = Maps.newHashMap();
            }
            HashSet found = Sets.newHashSet();
            config.forEach((namespace, subMap) -> subMap.forEach((path, value) -> {
                class_2960 id = new class_2960(namespace, path);
                if (!this.configs.containsKey(id)) {
                    return;
                }
                this.set(id, (boolean)value);
                found.add(id);
            }));
            Set<class_2960> allKeys = this.getKeys();
            boolean flag = false;
            for (class_2960 id : allKeys) {
                if (found.contains(id)) continue;
                this.set(id, this.getEntry(id).getDefaultValue());
                flag = true;
            }
            if (flag) {
                this.save();
            }
        }
    }

    public void save() {
        File configFile = new File(PlatformProxy.getConfigDirectory(), FILE_NAME);
        this.writeConfig(configFile, false);
    }

    private void writeConfig(File file, boolean reset) {
        HashMap config = Maps.newHashMap();
        this.configs.values().forEach(e -> {
            Map modConfig = config.computeIfAbsent(e.getId().method_12836(), k -> Maps.newHashMap());
            if (reset) {
                e.setValue(e.getDefaultValue());
            }
            modConfig.put(e.getId().method_12832(), e.getValue());
        });
        String json = JsonConfig.DEFAULT_GSON.toJson((Object)config);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            writer.write(json);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public IWailaConfig getWailaConfig() {
        return Jade.CONFIG.get();
    }
}

