/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome.modification;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_3031;
import net.minecraft.class_3414;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6012;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class BiomeModificationContextImpl
implements BiomeModificationContext {
    private final class_5455 registries;
    private final class_5321<class_1959> biomeKey;
    private final class_1959 biome;
    private final BiomeModificationContext.WeatherContext weather;
    private final BiomeModificationContext.EffectsContext effects;
    private final GenerationSettingsContextImpl generationSettings;
    private final SpawnSettingsContextImpl spawnSettings;

    public BiomeModificationContextImpl(class_5455 registries, class_5321<class_1959> biomeKey, class_1959 biome) {
        this.registries = registries;
        this.biomeKey = biomeKey;
        this.biome = biome;
        this.weather = new WeatherContextImpl();
        this.effects = new EffectsContextImpl();
        this.generationSettings = new GenerationSettingsContextImpl();
        this.spawnSettings = new SpawnSettingsContextImpl();
    }

    @Override
    public BiomeModificationContext.WeatherContext getWeather() {
        return this.weather;
    }

    @Override
    public BiomeModificationContext.EffectsContext getEffects() {
        return this.effects;
    }

    @Override
    public BiomeModificationContext.GenerationSettingsContext getGenerationSettings() {
        return this.generationSettings;
    }

    @Override
    public BiomeModificationContext.SpawnSettingsContext getSpawnSettings() {
        return this.spawnSettings;
    }

    void freeze() {
        this.generationSettings.freeze();
        this.spawnSettings.freeze();
    }

    private class WeatherContextImpl
    implements BiomeModificationContext.WeatherContext {
        private final class_1959.class_5482 weather;

        private WeatherContextImpl() {
            this.weather = BiomeModificationContextImpl.this.biome.field_26393;
        }

        @Override
        public void setPrecipitation(class_1959.class_1963 precipitation) {
            this.weather.comp_843 = Objects.requireNonNull(precipitation);
        }

        @Override
        public void setTemperature(float temperature) {
            this.weather.comp_844 = temperature;
        }

        @Override
        public void setTemperatureModifier(class_1959.class_5484 temperatureModifier) {
            this.weather.comp_845 = Objects.requireNonNull(temperatureModifier);
        }

        @Override
        public void setDownfall(float downfall) {
            this.weather.comp_846 = downfall;
        }
    }

    private class EffectsContextImpl
    implements BiomeModificationContext.EffectsContext {
        private final class_4763 effects;

        private EffectsContextImpl() {
            this.effects = BiomeModificationContextImpl.this.biome.method_24377();
        }

        @Override
        public void setFogColor(int color) {
            this.effects.field_22067 = color;
        }

        @Override
        public void setWaterColor(int color) {
            this.effects.field_22068 = color;
        }

        @Override
        public void setWaterFogColor(int color) {
            this.effects.field_22069 = color;
        }

        @Override
        public void setSkyColor(int color) {
            this.effects.field_26418 = color;
        }

        @Override
        public void setFoliageColor(Optional<Integer> color) {
            this.effects.field_26419 = Objects.requireNonNull(color);
        }

        @Override
        public void setGrassColor(Optional<Integer> color) {
            this.effects.field_26420 = Objects.requireNonNull(color);
        }

        @Override
        public void setGrassColorModifier(@NotNull class_4763.class_5486 colorModifier) {
            this.effects.field_26421 = Objects.requireNonNull(colorModifier);
        }

        @Override
        public void setParticleConfig(Optional<class_4761> particleConfig) {
            this.effects.field_22070 = Objects.requireNonNull(particleConfig);
        }

        @Override
        public void setAmbientSound(Optional<class_3414> sound) {
            this.effects.field_22491 = Objects.requireNonNull(sound);
        }

        @Override
        public void setMoodSound(Optional<class_4968> sound) {
            this.effects.field_22492 = Objects.requireNonNull(sound);
        }

        @Override
        public void setAdditionsSound(Optional<class_4967> sound) {
            this.effects.field_22493 = Objects.requireNonNull(sound);
        }

        @Override
        public void setMusic(Optional<class_5195> sound) {
            this.effects.field_24113 = Objects.requireNonNull(sound);
        }
    }

    private class GenerationSettingsContextImpl
    implements BiomeModificationContext.GenerationSettingsContext {
        private final class_2378<class_2922<?>> carvers;
        private final class_2378<class_6796> features;
        private final class_5485 generationSettings;
        private boolean rebuildFlowerFeatures;

        GenerationSettingsContextImpl() {
            this.carvers = BiomeModificationContextImpl.this.registries.method_30530(class_2378.field_25913);
            this.features = BiomeModificationContextImpl.this.registries.method_30530(class_2378.field_35758);
            this.generationSettings = BiomeModificationContextImpl.this.biome.method_30970();
            this.unfreezeCarvers();
            this.unfreezeFeatures();
            this.rebuildFlowerFeatures = false;
        }

        private void unfreezeCarvers() {
            EnumMap carversByStep = new EnumMap(class_2893.class_2894.class);
            carversByStep.putAll(this.generationSettings.field_26415);
            this.generationSettings.field_26415 = carversByStep;
        }

        private void unfreezeFeatures() {
            this.generationSettings.field_26416 = new ArrayList(this.generationSettings.field_26416);
        }

        public void freeze() {
            this.freezeCarvers();
            this.freezeFeatures();
            if (this.rebuildFlowerFeatures) {
                this.rebuildFlowerFeatures();
            }
        }

        private void freezeCarvers() {
            this.generationSettings.field_26415 = ImmutableMap.copyOf((Map)this.generationSettings.field_26415);
        }

        private void freezeFeatures() {
            this.generationSettings.field_26416 = ImmutableList.copyOf((Collection)this.generationSettings.field_26416);
            this.generationSettings.field_34465 = Suppliers.memoize(() -> this.generationSettings.field_26416.stream().flatMap(class_6885::method_40239).map(class_6880::comp_349).collect(Collectors.toSet()));
        }

        private void rebuildFlowerFeatures() {
            this.generationSettings.field_26640 = Suppliers.memoize(() -> (List)this.generationSettings.field_26416.stream().flatMap(class_6885::method_40239).map(class_6880::comp_349).flatMap(class_6796::method_39643).filter(configuredFeature -> configuredFeature.comp_332() == class_3031.field_21219).collect(ImmutableList.toImmutableList()));
        }

        @Override
        public boolean removeFeature(class_2893.class_2895 step, class_5321<class_6796> placedFeatureKey) {
            List featureSteps;
            class_6796 configuredFeature = (class_6796)this.features.method_31140(placedFeatureKey);
            int stepIndex = step.ordinal();
            if (stepIndex >= (featureSteps = this.generationSettings.field_26416).size()) {
                return false;
            }
            class_6885 featuresInStep = (class_6885)featureSteps.get(stepIndex);
            ArrayList features = new ArrayList(featuresInStep.method_40239().toList());
            if (features.removeIf(feature -> feature.comp_349() == configuredFeature)) {
                featureSteps.set(stepIndex, class_6885.method_40242(features));
                this.rebuildFlowerFeatures = true;
                return true;
            }
            return false;
        }

        @Override
        public void addFeature(class_2893.class_2895 step, class_5321<class_6796> entry) {
            List featureSteps = this.generationSettings.field_26416;
            int index = step.ordinal();
            while (index >= featureSteps.size()) {
                featureSteps.add(class_6885.method_40242(Collections.emptyList()));
            }
            featureSteps.set(index, this.plus((class_6885)featureSteps.get(index), (class_6880)this.features.method_40264(entry).orElseThrow()));
            this.rebuildFlowerFeatures = true;
        }

        @Override
        public void addCarver(class_2893.class_2894 step, class_5321<class_2922<?>> entry) {
            this.generationSettings.field_26415.put(step, this.plus((class_6885)this.generationSettings.field_26415.get(step), (class_6880)this.carvers.method_40264(entry).orElseThrow()));
        }

        @Override
        public boolean removeCarver(class_2893.class_2894 step, class_5321<class_2922<?>> configuredCarverKey) {
            class_2922 carver = (class_2922)this.carvers.method_31140(configuredCarverKey);
            ArrayList genCarvers = new ArrayList(((class_6885)this.generationSettings.field_26415.get(step)).method_40239().toList());
            if (genCarvers.removeIf(entry -> entry.comp_349() == carver)) {
                this.generationSettings.field_26415.put(step, class_6885.method_40242(genCarvers));
                return true;
            }
            return false;
        }

        private <T> class_6885<T> plus(class_6885<T> values, class_6880<T> entry) {
            ArrayList list = new ArrayList(values.method_40239().toList());
            list.add(entry);
            return class_6885.method_40242(list);
        }
    }

    private class SpawnSettingsContextImpl
    implements BiomeModificationContext.SpawnSettingsContext {
        private final class_5483 spawnSettings;
        private final EnumMap<class_1311, List<class_5483.class_1964>> fabricSpawners;

        SpawnSettingsContextImpl() {
            this.spawnSettings = BiomeModificationContextImpl.this.biome.method_30966();
            this.fabricSpawners = new EnumMap(class_1311.class);
            this.unfreezeSpawners();
            this.unfreezeSpawnCost();
        }

        private void unfreezeSpawners() {
            this.fabricSpawners.clear();
            for (class_1311 spawnGroup : class_1311.values()) {
                class_6012 entries = (class_6012)this.spawnSettings.field_26405.get(spawnGroup);
                if (entries != null) {
                    this.fabricSpawners.put(spawnGroup, new ArrayList(entries.method_34994()));
                    continue;
                }
                this.fabricSpawners.put(spawnGroup, new ArrayList());
            }
        }

        private void unfreezeSpawnCost() {
            this.spawnSettings.field_26406 = new HashMap(this.spawnSettings.field_26406);
        }

        public void freeze() {
            this.freezeSpawners();
            this.freezeSpawnCosts();
        }

        private void freezeSpawners() {
            HashMap<class_1311, class_6012> spawners = new HashMap<class_1311, class_6012>(this.spawnSettings.field_26405);
            for (Map.Entry<class_1311, List<class_5483.class_1964>> entry : this.fabricSpawners.entrySet()) {
                if (entry.getValue().isEmpty()) {
                    spawners.put(entry.getKey(), class_6012.method_34990());
                    continue;
                }
                spawners.put(entry.getKey(), class_6012.method_34988(entry.getValue()));
            }
            this.spawnSettings.field_26405 = ImmutableMap.copyOf(spawners);
        }

        private void freezeSpawnCosts() {
            this.spawnSettings.field_26406 = ImmutableMap.copyOf((Map)this.spawnSettings.field_26406);
        }

        @Override
        public void setCreatureSpawnProbability(float probability) {
            this.spawnSettings.field_26404 = probability;
        }

        @Override
        public void addSpawn(class_1311 spawnGroup, class_5483.class_1964 spawnEntry) {
            Objects.requireNonNull(spawnGroup);
            Objects.requireNonNull(spawnEntry);
            this.fabricSpawners.get(spawnGroup).add(spawnEntry);
        }

        @Override
        public boolean removeSpawns(BiPredicate<class_1311, class_5483.class_1964> predicate) {
            boolean anyRemoved = false;
            for (class_1311 group : class_1311.values()) {
                if (!this.fabricSpawners.get(group).removeIf(entry -> predicate.test(group, (class_5483.class_1964)entry))) continue;
                anyRemoved = true;
            }
            return anyRemoved;
        }

        @Override
        public void setSpawnCost(class_1299<?> entityType, double mass, double gravityLimit) {
            Objects.requireNonNull(entityType);
            this.spawnSettings.field_26406.put(entityType, new class_5483.class_5265(gravityLimit, mass));
        }

        @Override
        public void clearSpawnCost(class_1299<?> entityType) {
            this.spawnSettings.field_26406.remove(entityType);
        }
    }
}

