/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.biome.v1;

import java.util.Optional;
import java.util.function.BiPredicate;
import net.fabricmc.fabric.impl.biome.modification.BuiltInRegistryKeys;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_3414;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_6796;
import org.jetbrains.annotations.NotNull;

public interface BiomeModificationContext {
    public WeatherContext getWeather();

    public EffectsContext getEffects();

    public GenerationSettingsContext getGenerationSettings();

    public SpawnSettingsContext getSpawnSettings();

    public static interface SpawnSettingsContext {
        public void setCreatureSpawnProbability(float var1);

        public void addSpawn(class_1311 var1, class_5483.class_1964 var2);

        public boolean removeSpawns(BiPredicate<class_1311, class_5483.class_1964> var1);

        default public boolean removeSpawnsOfEntityType(class_1299<?> entityType) {
            return this.removeSpawns((spawnGroup, spawnEntry) -> spawnEntry.field_9389 == entityType);
        }

        default public void clearSpawns(class_1311 group) {
            this.removeSpawns((spawnGroup, spawnEntry) -> spawnGroup == group);
        }

        default public void clearSpawns() {
            this.removeSpawns((spawnGroup, spawnEntry) -> true);
        }

        public void setSpawnCost(class_1299<?> var1, double var2, double var4);

        public void clearSpawnCost(class_1299<?> var1);
    }

    public static interface GenerationSettingsContext {
        public boolean removeFeature(class_2893.class_2895 var1, class_5321<class_6796> var2);

        default public boolean removeFeature(class_5321<class_6796> placedFeatureKey) {
            boolean anyFound = false;
            for (class_2893.class_2895 step : class_2893.class_2895.values()) {
                if (!this.removeFeature(step, placedFeatureKey)) continue;
                anyFound = true;
            }
            return anyFound;
        }

        default public boolean removeBuiltInFeature(class_6796 placedFeature) {
            return this.removeFeature(BuiltInRegistryKeys.get(placedFeature));
        }

        default public boolean removeBuiltInFeature(class_2893.class_2895 step, class_6796 placedFeature) {
            return this.removeFeature(step, BuiltInRegistryKeys.get(placedFeature));
        }

        public void addFeature(class_2893.class_2895 var1, class_5321<class_6796> var2);

        default public void addBuiltInFeature(class_2893.class_2895 step, class_6796 placedFeature) {
            this.addFeature(step, BuiltInRegistryKeys.get(placedFeature));
        }

        public void addCarver(class_2893.class_2894 var1, class_5321<class_2922<?>> var2);

        default public void addBuiltInCarver(class_2893.class_2894 step, class_2922<?> configuredCarver) {
            this.addCarver(step, BuiltInRegistryKeys.get(configuredCarver));
        }

        public boolean removeCarver(class_2893.class_2894 var1, class_5321<class_2922<?>> var2);

        default public boolean removeCarver(class_5321<class_2922<?>> configuredCarverKey) {
            boolean anyFound = false;
            for (class_2893.class_2894 step : class_2893.class_2894.values()) {
                if (!this.removeCarver(step, configuredCarverKey)) continue;
                anyFound = true;
            }
            return anyFound;
        }

        default public boolean removeBuiltInCarver(class_2922<?> configuredCarver) {
            return this.removeCarver(BuiltInRegistryKeys.get(configuredCarver));
        }

        default public boolean removeBuiltInCarver(class_2893.class_2894 step, class_2922<?> configuredCarver) {
            return this.removeCarver(step, BuiltInRegistryKeys.get(configuredCarver));
        }
    }

    public static interface EffectsContext {
        public void setFogColor(int var1);

        public void setWaterColor(int var1);

        public void setWaterFogColor(int var1);

        public void setSkyColor(int var1);

        public void setFoliageColor(Optional<Integer> var1);

        default public void setFoliageColor(int color) {
            this.setFoliageColor(Optional.of(color));
        }

        default public void clearFoliageColor() {
            this.setFoliageColor(Optional.empty());
        }

        public void setGrassColor(Optional<Integer> var1);

        default public void setGrassColor(int color) {
            this.setGrassColor(Optional.of(color));
        }

        default public void clearGrassColor() {
            this.setGrassColor(Optional.empty());
        }

        public void setGrassColorModifier(@NotNull class_4763.class_5486 var1);

        public void setParticleConfig(Optional<class_4761> var1);

        default public void setParticleConfig(@NotNull class_4761 particleConfig) {
            this.setParticleConfig(Optional.of(particleConfig));
        }

        default public void clearParticleConfig() {
            this.setParticleConfig(Optional.empty());
        }

        public void setAmbientSound(Optional<class_3414> var1);

        default public void setAmbientSound(@NotNull class_3414 sound) {
            this.setAmbientSound(Optional.of(sound));
        }

        default public void clearAmbientSound() {
            this.setAmbientSound(Optional.empty());
        }

        public void setMoodSound(Optional<class_4968> var1);

        default public void setMoodSound(@NotNull class_4968 sound) {
            this.setMoodSound(Optional.of(sound));
        }

        default public void clearMoodSound() {
            this.setMoodSound(Optional.empty());
        }

        public void setAdditionsSound(Optional<class_4967> var1);

        default public void setAdditionsSound(@NotNull class_4967 sound) {
            this.setAdditionsSound(Optional.of(sound));
        }

        default public void clearAdditionsSound() {
            this.setAdditionsSound(Optional.empty());
        }

        public void setMusic(Optional<class_5195> var1);

        default public void setMusic(@NotNull class_5195 sound) {
            this.setMusic(Optional.of(sound));
        }

        default public void clearMusic() {
            this.setMusic(Optional.empty());
        }
    }

    public static interface WeatherContext {
        public void setPrecipitation(class_1959.class_1963 var1);

        public void setTemperature(float var1);

        public void setTemperatureModifier(class_1959.class_5484 var1);

        public void setDownfall(float var1);
    }
}

