/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.platform;

import architectury_inject_architectury_common_797164d19c104913a2e9368bddebb171_61c026cca77b748ccc331636e204dadf0d9b76d250af8de462e36ed9614d0aaaarchitectury6243devjar.PlatformMethods;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Mod;
import dev.architectury.platform.fabric.PlatformImpl;
import dev.architectury.utils.Env;
import java.nio.file.Path;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.minecraft.class_155;

public final class Platform {
    private static int simpleLoaderCache = -1;

    private Platform() {
    }

    public static boolean isFabric() {
        Platform.updateLoaderCache();
        return simpleLoaderCache == 0;
    }

    public static boolean isForge() {
        Platform.updateLoaderCache();
        return simpleLoaderCache == 1;
    }

    private static void updateLoaderCache() {
        if (simpleLoaderCache != -1) {
            return;
        }
        switch (PlatformMethods.getCurrentTarget()) {
            case "fabric": {
                simpleLoaderCache = 0;
                break;
            }
            case "forge": {
                simpleLoaderCache = 1;
            }
        }
    }

    public static String getMinecraftVersion() {
        return class_155.method_16673().getId();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getGameFolder() {
        return PlatformImpl.getGameFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigFolder() {
        return PlatformImpl.getConfigFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getModsFolder() {
        return PlatformImpl.getModsFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Env getEnvironment() {
        return PlatformImpl.getEnvironment();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static EnvType getEnv() {
        return PlatformImpl.getEnv();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String id) {
        return PlatformImpl.isModLoaded(id);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Mod getMod(String id) {
        return PlatformImpl.getMod(id);
    }

    public static Optional<Mod> getOptionalMod(String id) {
        try {
            return Optional.of(Platform.getMod(id));
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Collection<Mod> getMods() {
        return PlatformImpl.getMods();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Collection<String> getModIds() {
        return PlatformImpl.getModIds();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDevelopmentEnvironment() {
        return PlatformImpl.isDevelopmentEnvironment();
    }
}

