/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer;

import com.google.common.base.Preconditions;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.minecraft.class_3532;

public abstract class RenderMaterialImpl {
    private static final BlendMode[] BLEND_MODES = BlendMode.values();
    private static final int BLEND_MODE_MASK = class_3532.method_15339((int)BlendMode.values().length) - 1;
    private static final int COLOR_DISABLE_FLAG = BLEND_MODE_MASK + 1;
    private static final int EMISSIVE_FLAG = COLOR_DISABLE_FLAG << 1;
    private static final int DIFFUSE_FLAG = EMISSIVE_FLAG << 1;
    private static final int AO_FLAG = DIFFUSE_FLAG << 1;
    public static final int VALUE_COUNT = AO_FLAG << 1;
    private static final Value[] VALUES = new Value[VALUE_COUNT];
    protected int bits;

    public static Value byIndex(int index) {
        return VALUES[index];
    }

    public BlendMode blendMode(int textureIndex) {
        return BLEND_MODES[this.bits & BLEND_MODE_MASK];
    }

    public boolean disableColorIndex(int textureIndex) {
        return (this.bits & COLOR_DISABLE_FLAG) != 0;
    }

    public int spriteDepth() {
        return 1;
    }

    public boolean emissive(int textureIndex) {
        return (this.bits & EMISSIVE_FLAG) != 0;
    }

    public boolean disableDiffuse(int textureIndex) {
        return (this.bits & DIFFUSE_FLAG) != 0;
    }

    public boolean disableAo(int textureIndex) {
        return (this.bits & AO_FLAG) != 0;
    }

    static {
        for (int i = 0; i < VALUE_COUNT; ++i) {
            RenderMaterialImpl.VALUES[i] = new Value(i);
        }
    }

    public static class Value
    extends RenderMaterialImpl
    implements RenderMaterial {
        private Value(int bits) {
            this.bits = bits;
        }

        public int index() {
            return this.bits;
        }
    }

    public static class Finder
    extends RenderMaterialImpl
    implements MaterialFinder {
        public RenderMaterial find() {
            return VALUES[this.bits];
        }

        public MaterialFinder clear() {
            this.bits = 0;
            return this;
        }

        public MaterialFinder blendMode(int textureIndex, BlendMode blendMode) {
            if (blendMode == null) {
                blendMode = BlendMode.DEFAULT;
            }
            this.bits = this.bits & ~BLEND_MODE_MASK | blendMode.ordinal();
            return this;
        }

        public MaterialFinder disableColorIndex(int textureIndex, boolean disable) {
            this.bits = disable ? this.bits | COLOR_DISABLE_FLAG : this.bits & ~COLOR_DISABLE_FLAG;
            return this;
        }

        public MaterialFinder spriteDepth(int depth) {
            Preconditions.checkArgument((depth == 1 ? 1 : 0) != 0, (String)"Unsupported sprite depth: %s", (int)depth);
            return this;
        }

        public MaterialFinder emissive(int textureIndex, boolean isEmissive) {
            this.bits = isEmissive ? this.bits | EMISSIVE_FLAG : this.bits & ~EMISSIVE_FLAG;
            return this;
        }

        public MaterialFinder disableDiffuse(int textureIndex, boolean disable) {
            this.bits = disable ? this.bits | DIFFUSE_FLAG : this.bits & ~DIFFUSE_FLAG;
            return this;
        }

        public MaterialFinder disableAo(int textureIndex, boolean disable) {
            this.bits = disable ? this.bits | AO_FLAG : this.bits & ~AO_FLAG;
            return this;
        }
    }
}

