/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import me.hypherionmc.shaded.moonconfig.core.file.FileWatcher;
import me.hypherionmc.simplerpc.SimpleRPCClient;
import me.hypherionmc.simplerpclib.RPCConstants;
import me.hypherionmc.simplerpclib.configuration.ConfigEngine;
import me.hypherionmc.simplerpclib.configuration.ServerConfig;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SimpleRPCServer {
    public static ServerConfig serverConfig;
    private static FileWatcher serverConfigWatcher;
    private static MinecraftServer server;

    public static void init() {
        serverConfig = ConfigEngine.loadServerConfig((String)".");
        try {
            serverConfigWatcher.addWatch(new File("./config/simple-rpc-server.toml"), () -> {
                serverConfig = ConfigEngine.loadServerConfig((String)".");
                if (server != null) {
                    SimpleRPCClient.sidedHandler.sendClientPacket(server, serverConfig);
                }
            });
        }
        catch (Exception e) {
            RPCConstants.logger.error("Failed to register Server Config watcher", (Throwable)e);
        }
    }

    public static void playerJoinServer(class_3222 player) {
        if (serverConfig != null) {
            SimpleRPCClient.sidedHandler.sendToPlayer(server, player, serverConfig);
        }
    }

    public static void serverTick(MinecraftServer mcServer) {
        server = mcServer;
    }

    public static class_2540 serializeConfig(class_2540 buf, ServerConfig config) {
        try {
            buf.writeBoolean(config.enabled);
            buf.writeBoolean(config.multi_player.enabled);
            buf.method_10814(config.multi_player.description);
            buf.method_10814(config.multi_player.state);
            buf.method_10814(config.multi_player.largeImageKey);
            buf.method_10814(config.multi_player.largeImageText);
            buf.method_10814(config.multi_player.smallImageKey);
            buf.method_10814(config.multi_player.smallImageText);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(config.multi_player.buttonsList);
            oos.flush();
            buf.method_10813(bos.toByteArray());
            ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
            ObjectOutputStream oos2 = new ObjectOutputStream(bos2);
            oos2.writeObject(config.dimension_overrides);
            oos2.flush();
            buf.method_10813(bos2.toByteArray());
            return buf;
        }
        catch (Exception exception) {
            return buf;
        }
    }

    static {
        serverConfigWatcher = new FileWatcher();
    }
}

