/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.async.jfr;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.lucko.spark.common.sampler.async.AsyncStackTraceElement;
import me.lucko.spark.common.sampler.async.jfr.Dictionary;

public class JfrReader
implements Closeable {
    private static final int BUFFER_SIZE = 0x200000;
    private static final int CHUNK_HEADER_SIZE = 68;
    private static final int CHUNK_SIGNATURE = 1179406848;
    private final FileChannel ch;
    private ByteBuffer buf;
    private long filePosition;
    public boolean incomplete;
    public long startNanos = Long.MAX_VALUE;
    public long endNanos = Long.MIN_VALUE;
    public long startTicks = Long.MAX_VALUE;
    public long ticksPerSec;
    public final Dictionary<JfrClass> types = new Dictionary();
    public final Map<String, JfrClass> typesByName = new HashMap<String, JfrClass>();
    public final Dictionary<String> threads = new Dictionary();
    public final Dictionary<ClassRef> classes = new Dictionary();
    public final Dictionary<byte[]> symbols = new Dictionary();
    public final Dictionary<MethodRef> methods = new Dictionary();
    public final Dictionary<StackTrace> stackTraces = new Dictionary();
    public final Dictionary<AsyncStackTraceElement> stackFrames = new Dictionary();
    public final Map<Integer, String> frameTypes = new HashMap<Integer, String>();
    public final Map<Integer, String> threadStates = new HashMap<Integer, String>();
    public final Map<String, String> settings = new HashMap<String, String>();
    private int executionSample;
    private int nativeMethodSample;
    private int allocationInNewTLAB;
    private int allocationOutsideTLAB;
    private int allocationSample;
    private int monitorEnter;
    private int threadPark;
    private int activeSetting;
    private boolean activeSettingHasStack;

    public JfrReader(Path path) throws IOException {
        this.ch = FileChannel.open(path, StandardOpenOption.READ);
        this.buf = ByteBuffer.allocateDirect(0x200000);
        this.buf.flip();
        this.ensureBytes(68);
        if (!this.readChunk(0)) {
            throw new IOException("Incomplete JFR file");
        }
    }

    @Override
    public void close() throws IOException {
        this.ch.close();
    }

    public long durationNanos() {
        return this.endNanos - this.startNanos;
    }

    public List<Event> readAllEvents() throws IOException {
        return this.readAllEvents(null);
    }

    public <E extends Event> List<E> readAllEvents(Class<E> cls) throws IOException {
        E event;
        ArrayList<E> events = new ArrayList<E>();
        while ((event = this.readEvent(cls)) != null) {
            events.add(event);
        }
        Collections.sort(events);
        return events;
    }

    public Event readEvent() throws IOException {
        return this.readEvent(null);
    }

    public <E extends Event> E readEvent(Class<E> cls) throws IOException {
        while (this.ensureBytes(68)) {
            int pos = this.buf.position();
            int size = this.getVarint();
            int type = this.getVarint();
            if (type == 76 && this.buf.getInt(pos) == 1179406848) {
                if (!this.readChunk(pos)) break;
                continue;
            }
            if (type == this.executionSample || type == this.nativeMethodSample) {
                if (cls == null || cls == ExecutionSample.class) {
                    return (E)this.readExecutionSample();
                }
            } else if (type == this.allocationInNewTLAB) {
                if (cls == null || cls == AllocationSample.class) {
                    return (E)this.readAllocationSample(true);
                }
            } else if (type == this.allocationOutsideTLAB || type == this.allocationSample) {
                if (cls == null || cls == AllocationSample.class) {
                    return (E)this.readAllocationSample(false);
                }
            } else if (type == this.monitorEnter) {
                if (cls == null || cls == ContendedLock.class) {
                    return (E)this.readContendedLock(false);
                }
            } else if (type == this.threadPark) {
                if (cls == null || cls == ContendedLock.class) {
                    return (E)this.readContendedLock(true);
                }
            } else if (type == this.activeSetting) {
                this.readActiveSetting();
            }
            if ((pos += size) <= this.buf.limit()) {
                this.buf.position(pos);
                continue;
            }
            this.seek(this.filePosition + (long)pos);
        }
        return null;
    }

    private ExecutionSample readExecutionSample() {
        long time = this.getVarlong();
        int tid = this.getVarint();
        int stackTraceId = this.getVarint();
        int threadState = this.getVarint();
        return new ExecutionSample(time, tid, stackTraceId, threadState);
    }

    private AllocationSample readAllocationSample(boolean tlab) {
        long time = this.getVarlong();
        int tid = this.getVarint();
        int stackTraceId = this.getVarint();
        int classId = this.getVarint();
        long allocationSize = this.getVarlong();
        long tlabSize = tlab ? this.getVarlong() : 0L;
        return new AllocationSample(time, tid, stackTraceId, classId, allocationSize, tlabSize);
    }

    private ContendedLock readContendedLock(boolean hasTimeout) {
        long time = this.getVarlong();
        long duration = this.getVarlong();
        int tid = this.getVarint();
        int stackTraceId = this.getVarint();
        int classId = this.getVarint();
        if (hasTimeout) {
            this.getVarlong();
        }
        long until = this.getVarlong();
        long address = this.getVarlong();
        return new ContendedLock(time, tid, stackTraceId, duration, classId);
    }

    private void readActiveSetting() {
        long time = this.getVarlong();
        long duration = this.getVarlong();
        int tid = this.getVarint();
        if (this.activeSettingHasStack) {
            this.getVarint();
        }
        long id = this.getVarlong();
        String name = this.getString();
        String value = this.getString();
        this.settings.put(name, value);
    }

    private boolean readChunk(int pos) throws IOException {
        if (pos + 68 > this.buf.limit() || this.buf.getInt(pos) != 1179406848) {
            throw new IOException("Not a valid JFR file");
        }
        int version = this.buf.getInt(pos + 4);
        if (version < 131072 || version > 196607) {
            throw new IOException("Unsupported JFR version: " + (version >>> 16) + "." + (version & 0xFFFF));
        }
        long cpOffset = this.buf.getLong(pos + 16);
        long metaOffset = this.buf.getLong(pos + 24);
        if (cpOffset == 0L || metaOffset == 0L) {
            this.incomplete = true;
            return false;
        }
        this.startNanos = Math.min(this.startNanos, this.buf.getLong(pos + 32));
        this.endNanos = Math.max(this.endNanos, this.buf.getLong(pos + 32) + this.buf.getLong(pos + 40));
        this.startTicks = Math.min(this.startTicks, this.buf.getLong(pos + 48));
        this.ticksPerSec = this.buf.getLong(pos + 56);
        this.types.clear();
        this.typesByName.clear();
        long chunkStart = this.filePosition + (long)pos;
        this.readMeta(chunkStart + metaOffset);
        this.readConstantPool(chunkStart + cpOffset);
        this.cacheEventTypes();
        this.seek(chunkStart + 68L);
        return true;
    }

    private void readMeta(long metaOffset) throws IOException {
        this.seek(metaOffset);
        this.ensureBytes(5);
        this.ensureBytes(this.getVarint() - this.buf.position());
        this.getVarint();
        this.getVarlong();
        this.getVarlong();
        this.getVarlong();
        String[] strings = new String[this.getVarint()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = this.getString();
        }
        this.readElement(strings);
    }

    private Element readElement(String[] strings) {
        String name = strings[this.getVarint()];
        int attributeCount = this.getVarint();
        HashMap<String, String> attributes = new HashMap<String, String>(attributeCount);
        for (int i = 0; i < attributeCount; ++i) {
            attributes.put(strings[this.getVarint()], strings[this.getVarint()]);
        }
        Element e = this.createElement(name, attributes);
        int childCount = this.getVarint();
        for (int i = 0; i < childCount; ++i) {
            e.addChild(this.readElement(strings));
        }
        return e;
    }

    private Element createElement(String name, Map<String, String> attributes) {
        switch (name) {
            case "class": {
                JfrClass type = new JfrClass(attributes);
                if (!attributes.containsKey("superType")) {
                    this.types.put(type.id, type);
                }
                this.typesByName.put(type.name, type);
                return type;
            }
            case "field": {
                return new JfrField(attributes);
            }
        }
        return new Element();
    }

    private void readConstantPool(long cpOffset) throws IOException {
        long delta;
        do {
            this.seek(cpOffset);
            this.ensureBytes(5);
            this.ensureBytes(this.getVarint() - this.buf.position());
            this.getVarint();
            this.getVarlong();
            this.getVarlong();
            delta = this.getVarlong();
            this.getVarint();
            int poolCount = this.getVarint();
            for (int i = 0; i < poolCount; ++i) {
                int type = this.getVarint();
                this.readConstants(this.types.get(type));
            }
        } while (delta != 0L && (cpOffset += delta) > 0L);
    }

    private void readConstants(JfrClass type) {
        switch (type.name) {
            case "jdk.types.ChunkHeader": {
                this.buf.position(this.buf.position() + 71);
                break;
            }
            case "java.lang.Thread": {
                this.readThreads(type.field("group") != null);
                break;
            }
            case "java.lang.Class": {
                this.readClasses(type.field("hidden") != null);
                break;
            }
            case "jdk.types.Symbol": {
                this.readSymbols();
                break;
            }
            case "jdk.types.Method": {
                this.readMethods();
                break;
            }
            case "jdk.types.StackTrace": {
                this.readStackTraces();
                break;
            }
            case "jdk.types.FrameType": {
                this.readMap(this.frameTypes);
                break;
            }
            case "jdk.types.ThreadState": {
                this.readMap(this.threadStates);
                break;
            }
            default: {
                this.readOtherConstants(type.fields);
            }
        }
    }

    private void readThreads(boolean hasGroup) {
        int count = this.threads.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            String osName = this.getString();
            int osThreadId = this.getVarint();
            String javaName = this.getString();
            long javaThreadId = this.getVarlong();
            if (hasGroup) {
                this.getVarlong();
            }
            this.threads.put(id, javaName != null ? javaName : osName);
        }
    }

    private void readClasses(boolean hasHidden) {
        int count = this.classes.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            long loader = this.getVarlong();
            long name = this.getVarlong();
            long pkg = this.getVarlong();
            int modifiers = this.getVarint();
            if (hasHidden) {
                this.getVarint();
            }
            this.classes.put(id, new ClassRef(name));
        }
    }

    private void readMethods() {
        int count = this.methods.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            long cls = this.getVarlong();
            long name = this.getVarlong();
            long sig = this.getVarlong();
            int modifiers = this.getVarint();
            int hidden = this.getVarint();
            this.methods.put(id, new MethodRef(cls, name, sig));
        }
        this.stackFrames.preallocate(count);
    }

    private void readStackTraces() {
        int count = this.stackTraces.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            int truncated = this.getVarint();
            StackTrace stackTrace = this.readStackTrace();
            this.stackTraces.put(id, stackTrace);
        }
    }

    private StackTrace readStackTrace() {
        int depth = this.getVarint();
        long[] methods = new long[depth];
        byte[] types = new byte[depth];
        int[] locations = new int[depth];
        for (int i = 0; i < depth; ++i) {
            methods[i] = this.getVarlong();
            int line = this.getVarint();
            int bci = this.getVarint();
            locations[i] = line << 16 | bci & 0xFFFF;
            types[i] = this.buf.get();
        }
        return new StackTrace(methods, types, locations);
    }

    private void readSymbols() {
        int count = this.symbols.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            if (this.buf.get() != 3) {
                throw new IllegalArgumentException("Invalid symbol encoding");
            }
            this.symbols.put(id, this.getBytes());
        }
    }

    private void readMap(Map<Integer, String> map) {
        int count = this.getVarint();
        for (int i = 0; i < count; ++i) {
            map.put(this.getVarint(), this.getString());
        }
    }

    private void readOtherConstants(List<JfrField> fields) {
        int stringType = this.getTypeId("java.lang.String");
        boolean[] numeric = new boolean[fields.size()];
        for (int i = 0; i < numeric.length; ++i) {
            JfrField f = fields.get(i);
            numeric[i] = f.constantPool || f.type != stringType;
        }
        int count = this.getVarint();
        for (int i = 0; i < count; ++i) {
            this.getVarlong();
            this.readFields(numeric);
        }
    }

    private void readFields(boolean[] numeric) {
        for (boolean n : numeric) {
            if (n) {
                this.getVarlong();
                continue;
            }
            this.getString();
        }
    }

    private void cacheEventTypes() {
        this.executionSample = this.getTypeId("jdk.ExecutionSample");
        this.nativeMethodSample = this.getTypeId("jdk.NativeMethodSample");
        this.allocationInNewTLAB = this.getTypeId("jdk.ObjectAllocationInNewTLAB");
        this.allocationOutsideTLAB = this.getTypeId("jdk.ObjectAllocationOutsideTLAB");
        this.allocationSample = this.getTypeId("jdk.ObjectAllocationSample");
        this.monitorEnter = this.getTypeId("jdk.JavaMonitorEnter");
        this.threadPark = this.getTypeId("jdk.ThreadPark");
        this.activeSetting = this.getTypeId("jdk.ActiveSetting");
        this.activeSettingHasStack = this.activeSetting >= 0 && this.typesByName.get("jdk.ActiveSetting").field("stackTrace") != null;
    }

    private int getTypeId(String typeName) {
        JfrClass type = this.typesByName.get(typeName);
        return type != null ? type.id : -1;
    }

    private int getVarint() {
        int result = 0;
        int shift = 0;
        while (true) {
            byte b = this.buf.get();
            result |= (b & 0x7F) << shift;
            if (b >= 0) {
                return result;
            }
            shift += 7;
        }
    }

    private long getVarlong() {
        long result = 0L;
        for (int shift = 0; shift < 56; shift += 7) {
            byte b = this.buf.get();
            result |= ((long)b & 0x7FL) << shift;
            if (b < 0) continue;
            return result;
        }
        return result | ((long)this.buf.get() & 0xFFL) << 56;
    }

    private String getString() {
        switch (this.buf.get()) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
            case 3: {
                return new String(this.getBytes(), StandardCharsets.UTF_8);
            }
            case 4: {
                char[] chars = new char[this.getVarint()];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = (char)this.getVarint();
                }
                return new String(chars);
            }
            case 5: {
                return new String(this.getBytes(), StandardCharsets.ISO_8859_1);
            }
        }
        throw new IllegalArgumentException("Invalid string encoding");
    }

    private byte[] getBytes() {
        byte[] bytes = new byte[this.getVarint()];
        this.buf.get(bytes);
        return bytes;
    }

    private void seek(long pos) throws IOException {
        this.filePosition = pos;
        this.ch.position(pos);
        this.buf.rewind().flip();
    }

    private boolean ensureBytes(int needed) throws IOException {
        if (this.buf.remaining() >= needed) {
            return true;
        }
        this.filePosition += (long)this.buf.position();
        if (this.buf.capacity() < needed) {
            ByteBuffer newBuf = ByteBuffer.allocateDirect(needed);
            newBuf.put(this.buf);
            this.buf = newBuf;
        } else {
            this.buf.compact();
        }
        while (this.ch.read(this.buf) > 0 && this.buf.position() < needed) {
        }
        this.buf.flip();
        return this.buf.limit() > 0;
    }

    public static abstract class Event
    implements Comparable<Event> {
        public final long time;
        public final int tid;
        public final int stackTraceId;

        protected Event(long time, int tid, int stackTraceId) {
            this.time = time;
            this.tid = tid;
            this.stackTraceId = stackTraceId;
        }

        @Override
        public int compareTo(Event o) {
            return Long.compare(this.time, o.time);
        }

        public int hashCode() {
            return this.stackTraceId;
        }

        public boolean sameGroup(Event o) {
            return this.getClass() == o.getClass();
        }

        public long value() {
            return 1L;
        }
    }

    public static class ExecutionSample
    extends Event {
        public final int threadState;

        public ExecutionSample(long time, int tid, int stackTraceId, int threadState) {
            super(time, tid, stackTraceId);
            this.threadState = threadState;
        }
    }

    public static class AllocationSample
    extends Event {
        public final int classId;
        public final long allocationSize;
        public final long tlabSize;

        public AllocationSample(long time, int tid, int stackTraceId, int classId, long allocationSize, long tlabSize) {
            super(time, tid, stackTraceId);
            this.classId = classId;
            this.allocationSize = allocationSize;
            this.tlabSize = tlabSize;
        }

        @Override
        public int hashCode() {
            return this.classId * 127 + this.stackTraceId + (this.tlabSize == 0L ? 17 : 0);
        }

        @Override
        public boolean sameGroup(Event o) {
            if (o instanceof AllocationSample) {
                AllocationSample a = (AllocationSample)o;
                return this.classId == a.classId && this.tlabSize == 0L == (a.tlabSize == 0L);
            }
            return false;
        }

        @Override
        public long value() {
            return this.tlabSize != 0L ? this.tlabSize : this.allocationSize;
        }
    }

    public static class ContendedLock
    extends Event {
        public final long duration;
        public final int classId;

        public ContendedLock(long time, int tid, int stackTraceId, long duration, int classId) {
            super(time, tid, stackTraceId);
            this.duration = duration;
            this.classId = classId;
        }

        @Override
        public int hashCode() {
            return this.classId * 127 + this.stackTraceId;
        }

        @Override
        public boolean sameGroup(Event o) {
            if (o instanceof ContendedLock) {
                ContendedLock c = (ContendedLock)o;
                return this.classId == c.classId;
            }
            return false;
        }

        @Override
        public long value() {
            return this.duration;
        }
    }

    static class Element {
        Element() {
        }

        void addChild(Element e) {
        }
    }

    static class JfrClass
    extends Element {
        final int id;
        final String name;
        final List<JfrField> fields;

        JfrClass(Map<String, String> attributes) {
            this.id = Integer.parseInt(attributes.get("id"));
            this.name = attributes.get("name");
            this.fields = new ArrayList<JfrField>(2);
        }

        @Override
        void addChild(Element e) {
            if (e instanceof JfrField) {
                this.fields.add((JfrField)e);
            }
        }

        JfrField field(String name) {
            for (JfrField field : this.fields) {
                if (!field.name.equals(name)) continue;
                return field;
            }
            return null;
        }
    }

    static class JfrField
    extends Element {
        final String name;
        final int type;
        final boolean constantPool;

        JfrField(Map<String, String> attributes) {
            this.name = attributes.get("name");
            this.type = Integer.parseInt(attributes.get("class"));
            this.constantPool = "true".equals(attributes.get("constantPool"));
        }
    }

    public static class ClassRef {
        public final long name;

        public ClassRef(long name) {
            this.name = name;
        }
    }

    public static class MethodRef {
        public final long cls;
        public final long name;
        public final long sig;

        public MethodRef(long cls, long name, long sig) {
            this.cls = cls;
            this.name = name;
            this.sig = sig;
        }
    }

    public static class StackTrace {
        public final long[] methods;
        public final byte[] types;
        public final int[] locations;

        public StackTrace(long[] methods, byte[] types, int[] locations) {
            this.methods = methods;
            this.types = types;
            this.locations = locations;
        }
    }

    public static class EventAggregator {
        private static final int INITIAL_CAPACITY = 1024;
        private final boolean threads;
        private final boolean total;
        private Event[] keys;
        private long[] values;
        private int size;

        public EventAggregator(boolean threads, boolean total) {
            this.threads = threads;
            this.total = total;
            this.keys = new Event[1024];
            this.values = new long[1024];
        }

        public void collect(Event e) {
            int mask = this.keys.length - 1;
            int i = this.hashCode(e) & mask;
            while (this.keys[i] != null) {
                if (this.sameGroup(this.keys[i], e)) {
                    int n = i;
                    this.values[n] = this.values[n] + (this.total ? e.value() : 1L);
                    return;
                }
                i = i + 1 & mask;
            }
            this.keys[i] = e;
            long l = this.values[i] = this.total ? e.value() : 1L;
            if (++this.size * 2 > this.keys.length) {
                this.resize(this.keys.length * 2);
            }
        }

        public long getValue(Event e) {
            int mask = this.keys.length - 1;
            int i = this.hashCode(e) & mask;
            while (this.keys[i] != null && !this.sameGroup(this.keys[i], e)) {
                i = i + 1 & mask;
            }
            return this.values[i];
        }

        public void forEach(Visitor visitor) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == null) continue;
                visitor.visit(this.keys[i], this.values[i]);
            }
        }

        private int hashCode(Event e) {
            return e.hashCode() + (this.threads ? e.tid * 31 : 0);
        }

        private boolean sameGroup(Event e1, Event e2) {
            return e1.stackTraceId == e2.stackTraceId && (!this.threads || e1.tid == e2.tid) && e1.sameGroup(e2);
        }

        private void resize(int newCapacity) {
            Event[] newKeys = new Event[newCapacity];
            long[] newValues = new long[newCapacity];
            int mask = newKeys.length - 1;
            block0: for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == null) continue;
                int j = this.hashCode(this.keys[i]) & mask;
                while (true) {
                    if (newKeys[j] == null) {
                        newKeys[j] = this.keys[i];
                        newValues[j] = this.values[i];
                        continue block0;
                    }
                    j = j + 1 & mask;
                }
            }
            this.keys = newKeys;
            this.values = newValues;
        }

        public static interface Visitor {
            public void visit(Event var1, long var2);
        }
    }
}

