/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.StringListListEntry;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class StringListBuilder
extends FieldBuilder<List<String>, StringListListEntry> {
    private Function<String, Optional<class_2561>> cellErrorSupplier;
    private Consumer<List<String>> saveConsumer = null;
    private Function<List<String>, Optional<class_2561[]>> tooltipSupplier = list -> Optional.empty();
    private final List<String> value;
    private boolean expanded = false;
    private Function<StringListListEntry, StringListListEntry.StringListCell> createNewInstance;
    private class_2561 addTooltip = class_2561.method_43471((String)"text.cloth-config.list.add");
    private class_2561 removeTooltip = class_2561.method_43471((String)"text.cloth-config.list.remove");
    private boolean deleteButtonEnabled = true;
    private boolean insertInFront = false;

    public StringListBuilder(class_2561 resetButtonKey, class_2561 fieldNameKey, List<String> value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    public Function<String, Optional<class_2561>> getCellErrorSupplier() {
        return this.cellErrorSupplier;
    }

    public StringListBuilder setCellErrorSupplier(Function<String, Optional<class_2561>> cellErrorSupplier) {
        this.cellErrorSupplier = cellErrorSupplier;
        return this;
    }

    public StringListBuilder setErrorSupplier(Function<List<String>, Optional<class_2561>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this;
    }

    public StringListBuilder setDeleteButtonEnabled(boolean deleteButtonEnabled) {
        this.deleteButtonEnabled = deleteButtonEnabled;
        return this;
    }

    public StringListBuilder setInsertInFront(boolean insertInFront) {
        this.insertInFront = insertInFront;
        return this;
    }

    public StringListBuilder setAddButtonTooltip(class_2561 addTooltip) {
        this.addTooltip = addTooltip;
        return this;
    }

    public StringListBuilder setRemoveButtonTooltip(class_2561 removeTooltip) {
        this.removeTooltip = removeTooltip;
        return this;
    }

    public StringListBuilder requireRestart() {
        this.requireRestart(true);
        return this;
    }

    public StringListBuilder setCreateNewInstance(Function<StringListListEntry, StringListListEntry.StringListCell> createNewInstance) {
        this.createNewInstance = createNewInstance;
        return this;
    }

    public StringListBuilder setExpanded(boolean expanded) {
        this.expanded = expanded;
        return this;
    }

    public StringListBuilder setSaveConsumer(Consumer<List<String>> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public StringListBuilder setDefaultValue(Supplier<List<String>> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public StringListBuilder setDefaultValue(List<String> defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    public StringListBuilder setTooltipSupplier(Supplier<Optional<class_2561[]>> tooltipSupplier) {
        this.tooltipSupplier = list -> (Optional)tooltipSupplier.get();
        return this;
    }

    public StringListBuilder setTooltipSupplier(Function<List<String>, Optional<class_2561[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public StringListBuilder setTooltip(Optional<class_2561[]> tooltip) {
        this.tooltipSupplier = list -> tooltip;
        return this;
    }

    public StringListBuilder setTooltip(class_2561 ... tooltip) {
        this.tooltipSupplier = list -> Optional.ofNullable(tooltip);
        return this;
    }

    @Override
    @NotNull
    public StringListListEntry build() {
        StringListListEntry entry = new StringListListEntry(this.getFieldNameKey(), this.value, this.expanded, null, this.saveConsumer, this.defaultValue, this.getResetButtonKey(), this.isRequireRestart(), this.deleteButtonEnabled, this.insertInFront);
        if (this.createNewInstance != null) {
            entry.setCreateNewInstance(this.createNewInstance);
        }
        entry.setCellErrorSupplier(this.cellErrorSupplier);
        entry.setTooltipSupplier(() -> this.tooltipSupplier.apply((List<String>)entry.getValue()));
        entry.setAddTooltip(this.addTooltip);
        entry.setRemoveTooltip(this.removeTooltip);
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return entry;
    }
}

