/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.blay09.mods.craftingtweaks.api.ButtonAlignment;
import net.blay09.mods.craftingtweaks.api.ButtonPosition;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingGridDecorator;
import net.blay09.mods.craftingtweaks.api.GridBalanceHandler;
import net.blay09.mods.craftingtweaks.api.GridClearHandler;
import net.blay09.mods.craftingtweaks.api.GridGuiSettings;
import net.blay09.mods.craftingtweaks.api.GridRotateHandler;
import net.blay09.mods.craftingtweaks.api.GridTransferHandler;
import net.blay09.mods.craftingtweaks.api.NoopHandler;
import net.blay09.mods.craftingtweaks.api.TweakType;
import net.blay09.mods.craftingtweaks.api.impl.DefaultGridClearHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2960;

public class DefaultCraftingGrid
implements CraftingGrid,
CraftingGridDecorator,
GridGuiSettings {
    private final class_2960 id;
    private final int start;
    private final int size;
    private final Set<TweakType> hiddenButtons = new HashSet<TweakType>();
    private final Map<TweakType, ButtonPosition> buttonPositions = new HashMap<TweakType, ButtonPosition>();
    private GridClearHandler<class_1703> clearHandler = CraftingGrid.super.clearHandler();
    private GridBalanceHandler<class_1703> balanceHandler = CraftingGrid.super.balanceHandler();
    private GridRotateHandler<class_1703> rotateHandler = CraftingGrid.super.rotateHandler();
    private GridTransferHandler<class_1703> transferHandler = CraftingGrid.super.transferHandler();
    private ButtonAlignment buttonAlignment = ButtonAlignment.LEFT;

    public DefaultCraftingGrid(class_2960 id, int start, int size) {
        this.id = id;
        this.start = start;
        this.size = size;
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public int getGridStartSlot(class_1657 player, class_1703 menu) {
        return this.start;
    }

    @Override
    public int getGridSize(class_1657 player, class_1703 menu) {
        return this.size;
    }

    @Override
    public CraftingGridDecorator disableTweak(TweakType tweak) {
        switch (tweak) {
            case Clear: {
                this.clearHandler = new NoopHandler();
                break;
            }
            case Balance: {
                this.balanceHandler = new NoopHandler();
                break;
            }
            case Rotate: {
                this.rotateHandler = new NoopHandler();
            }
        }
        return this;
    }

    @Override
    public CraftingGridDecorator disableAllTweaks() {
        this.disableTweak(TweakType.Balance);
        this.disableTweak(TweakType.Rotate);
        this.disableTweak(TweakType.Clear);
        return this;
    }

    @Override
    public CraftingGridDecorator usePhantomItems() {
        GridClearHandler<class_1703> gridClearHandler = this.clearHandler;
        if (gridClearHandler instanceof DefaultGridClearHandler) {
            DefaultGridClearHandler defaultClearHandler = (DefaultGridClearHandler)gridClearHandler;
            defaultClearHandler.setPhantomItems(true);
        }
        return this;
    }

    @Override
    public GridClearHandler<class_1703> clearHandler() {
        return this.clearHandler;
    }

    @Override
    public GridBalanceHandler<class_1703> balanceHandler() {
        return this.balanceHandler;
    }

    @Override
    public GridTransferHandler<class_1703> transferHandler() {
        return this.transferHandler;
    }

    @Override
    public GridRotateHandler<class_1703> rotateHandler() {
        return this.rotateHandler;
    }

    @Override
    public CraftingGridDecorator rotateHandler(GridRotateHandler<class_1703> rotateHandler) {
        this.rotateHandler = rotateHandler;
        return this;
    }

    @Override
    public CraftingGridDecorator balanceHandler(GridBalanceHandler<class_1703> balanceHandler) {
        this.balanceHandler = balanceHandler;
        return this;
    }

    @Override
    public CraftingGridDecorator clearHandler(GridClearHandler<class_1703> clearHandler) {
        this.clearHandler = clearHandler;
        return this;
    }

    @Override
    public CraftingGridDecorator transferHandler(GridTransferHandler<class_1703> transferHandler) {
        this.transferHandler = transferHandler;
        return this;
    }

    @Override
    public CraftingGridDecorator hideTweakButton(TweakType tweak) {
        this.hiddenButtons.add(tweak);
        return this;
    }

    @Override
    public CraftingGridDecorator hideAllTweakButtons() {
        this.hideTweakButton(TweakType.Clear);
        this.hideTweakButton(TweakType.Balance);
        this.hideTweakButton(TweakType.Rotate);
        return this;
    }

    @Override
    public CraftingGridDecorator setButtonAlignment(ButtonAlignment alignment) {
        this.buttonAlignment = alignment;
        return this;
    }

    @Override
    public CraftingGridDecorator setButtonPosition(TweakType tweak, int x, int y) {
        this.buttonPositions.put(tweak, new ButtonPosition(x, y));
        return this;
    }

    @Override
    public boolean isButtonVisible(TweakType tweak) {
        return !this.hiddenButtons.contains((Object)tweak);
    }

    @Override
    public ButtonAlignment getButtonAlignment() {
        return this.buttonAlignment;
    }

    @Override
    public Optional<ButtonPosition> getButtonPosition(TweakType tweak) {
        return Optional.ofNullable(this.buttonPositions.get((Object)tweak));
    }
}

