/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import snownee.jade.Jade;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IToggleableProvider;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.callback.JadeAfterRenderCallback;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.callback.JadeItemModNameCallback;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.fabric.CustomEnchantPower;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.BlockAccessorImpl;
import snownee.jade.impl.EntityAccessorImpl;
import snownee.jade.impl.HierarchyLookup;
import snownee.jade.impl.PriorityStore;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.ConfigEntry;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.ElementHelper;
import snownee.jade.overlay.DisplayHelper;

public class WailaClientRegistration
implements IWailaClientRegistration {
    public static final WailaClientRegistration INSTANCE = new WailaClientRegistration();
    public final HierarchyLookup<IBlockComponentProvider> blockIconProviders;
    public final HierarchyLookup<IBlockComponentProvider> blockComponentProviders;
    public final HierarchyLookup<IEntityComponentProvider> entityIconProviders;
    public final HierarchyLookup<IEntityComponentProvider> entityComponentProviders;
    public final Set<class_2248> hideBlocks = Sets.newHashSet();
    public final Set<class_1299<?>> hideEntities = Sets.newHashSet();
    public final Set<class_2248> pickBlocks = Sets.newHashSet();
    public final List<JadeAfterRenderCallback> afterRenderCallbacks = Lists.newArrayList();
    public final List<JadeBeforeRenderCallback> beforeRenderCallbacks = Lists.newArrayList();
    public final List<JadeRayTraceCallback> rayTraceCallbacks = Lists.newArrayList();
    public final List<JadeTooltipCollectedCallback> tooltipCollectedCallbacks = Lists.newArrayList();
    public final List<JadeItemModNameCallback> itemModNameCallbacks = Lists.newArrayList();
    public final Map<class_2248, CustomEnchantPower> customEnchantPowers = Maps.newHashMap();

    WailaClientRegistration() {
        this.blockIconProviders = new HierarchyLookup(class_2248.class);
        this.blockComponentProviders = new HierarchyLookup(class_2248.class);
        this.entityIconProviders = new HierarchyLookup(class_1297.class);
        this.entityComponentProviders = new HierarchyLookup(class_1297.class);
    }

    @Override
    public void registerBlockIcon(IBlockComponentProvider provider, Class<? extends class_2248> block) {
        this.blockIconProviders.register(block, provider);
        this.tryAddConfig(provider);
    }

    @Override
    public void registerBlockComponent(IBlockComponentProvider provider, Class<? extends class_2248> block) {
        this.blockComponentProviders.register(block, provider);
        this.tryAddConfig(provider);
    }

    @Override
    public void registerEntityIcon(IEntityComponentProvider provider, Class<? extends class_1297> entity) {
        this.entityIconProviders.register(entity, provider);
        this.tryAddConfig(provider);
    }

    @Override
    public void registerEntityComponent(IEntityComponentProvider provider, Class<? extends class_1297> entity) {
        this.entityComponentProviders.register(entity, provider);
        this.tryAddConfig(provider);
    }

    public List<IBlockComponentProvider> getBlockProviders(class_2248 block, Predicate<IBlockComponentProvider> filter) {
        return this.blockComponentProviders.get(block).stream().filter(filter).toList();
    }

    public List<IBlockComponentProvider> getBlockIconProviders(class_2248 block, Predicate<IBlockComponentProvider> filter) {
        return this.blockIconProviders.get(block).stream().filter(filter).toList();
    }

    public List<IEntityComponentProvider> getEntityProviders(class_1297 entity, Predicate<IEntityComponentProvider> filter) {
        return this.entityComponentProviders.get(entity).stream().filter(filter).toList();
    }

    public List<IEntityComponentProvider> getEntityIconProviders(class_1297 entity, Predicate<IEntityComponentProvider> filter) {
        return this.entityIconProviders.get(entity).stream().filter(filter).toList();
    }

    @Override
    public void hideTarget(class_2248 block) {
        this.hideBlocks.add(block);
    }

    @Override
    public void hideTarget(class_1299<?> entityType) {
        this.hideEntities.add(entityType);
    }

    @Override
    public void usePickedResult(class_2248 block) {
        this.pickBlocks.add(block);
    }

    @Override
    public boolean shouldHide(class_2680 state) {
        return this.hideBlocks.contains(state.method_26204());
    }

    @Override
    public boolean shouldPick(class_2680 state) {
        return this.pickBlocks.contains(state.method_26204());
    }

    @Override
    public boolean shouldHide(class_1297 entity) {
        return this.hideEntities.contains(entity.method_5864());
    }

    @Override
    public IElementHelper getElementHelper() {
        return ElementHelper.INSTANCE;
    }

    @Override
    public IDisplayHelper getDisplayHelper() {
        return DisplayHelper.INSTANCE;
    }

    @Override
    public IWailaConfig getConfig() {
        return Jade.CONFIG.get();
    }

    @Override
    public void addConfig(class_2960 key, boolean defaultValue) {
        if (!PluginConfig.INSTANCE.getKeys().contains(key)) {
            PluginConfig.INSTANCE.addConfig(new ConfigEntry(key, defaultValue, false));
        }
    }

    private void tryAddConfig(IToggleableProvider provider) {
        if (!provider.isRequired()) {
            this.addConfig(provider.getUid(), provider.enabledByDefault());
        }
    }

    public void loadComplete() {
        PriorityStore<IJadeProvider> priorities = WailaCommonRegistration.INSTANCE.priorities;
        this.blockComponentProviders.loadComplete(priorities);
        this.blockIconProviders.loadComplete(priorities);
        this.entityComponentProviders.loadComplete(priorities);
        this.entityIconProviders.loadComplete(priorities);
    }

    @Override
    public void addAfterRenderCallback(JadeAfterRenderCallback callback) {
        Objects.requireNonNull(callback);
        this.afterRenderCallbacks.add(callback);
    }

    @Override
    public void addBeforeRenderCallback(JadeBeforeRenderCallback callback) {
        Objects.requireNonNull(callback);
        this.beforeRenderCallbacks.add(callback);
    }

    @Override
    public void addRayTraceCallback(JadeRayTraceCallback callback) {
        Objects.requireNonNull(callback);
        this.rayTraceCallbacks.add(callback);
    }

    @Override
    public void addTooltipCollectedCallback(JadeTooltipCollectedCallback callback) {
        Objects.requireNonNull(callback);
        this.tooltipCollectedCallbacks.add(callback);
    }

    @Override
    public void addItemModNameCallback(JadeItemModNameCallback callback) {
        Objects.requireNonNull(callback);
        this.itemModNameCallbacks.add(callback);
    }

    @Override
    public BlockAccessor.Builder blockAccessor() {
        return new BlockAccessorImpl.Builder();
    }

    @Override
    public EntityAccessor.Builder entityAccessor() {
        return new EntityAccessorImpl.Builder();
    }

    @Override
    public void registerCustomEnchantPower(class_2248 block, CustomEnchantPower customEnchantPower) {
        this.customEnchantPowers.put(block, customEnchantPower);
    }
}

