/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.class_2960;
import snownee.jade.Jade;
import snownee.jade.util.JsonConfig;
import snownee.jade.util.PlatformProxy;

public class PriorityStore<T> {
    private final Object2IntMap<class_2960> priorities = new Object2IntLinkedOpenHashMap();
    private final Function<T, class_2960> uidGetter;
    private final ToIntFunction<T> defaultGetter;
    private final String fileName;

    public PriorityStore(String filename, ToIntFunction<T> defaultGetter, Function<T, class_2960> uidGetter) {
        this.fileName = filename;
        this.defaultGetter = defaultGetter;
        this.uidGetter = uidGetter;
    }

    public void put(T provider) {
        Objects.requireNonNull(provider);
        class_2960 uid = this.uidGetter.apply(provider);
        Objects.requireNonNull(uid);
        this.priorities.put((Object)uid, this.defaultGetter.applyAsInt(provider));
    }

    public void updateConfig() {
        Path saveFile = PlatformProxy.getConfigDirectory().toPath().resolve(this.fileName + ".json");
        Map map = null;
        if (Files.exists(saveFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(saveFile, Charsets.UTF_8);){
                Type type = new TypeToken<LinkedHashMap<class_2960, Integer>>(){}.getType();
                map = (Map)JsonConfig.DEFAULT_GSON.fromJson((Reader)reader, type);
            }
            catch (Exception e) {
                Jade.LOGGER.catching((Throwable)e);
            }
        }
        if (map == null) {
            map = Maps.newLinkedHashMap();
        } else {
            for (Map.Entry e : map.entrySet()) {
                if (e.getValue() == null) continue;
                this.priorities.put((Object)((class_2960)e.getKey()), ((Integer)e.getValue()).intValue());
            }
        }
        LinkedHashMap map0 = map;
        new Thread(() -> {
            for (class_2960 id : this.priorities.keySet()) {
                if (map0.containsKey(id)) continue;
                map0.put(id, null);
            }
            try {
                Files.write(saveFile, JsonConfig.DEFAULT_GSON.toJson((Object)map0).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (Exception e) {
                Jade.LOGGER.catching((Throwable)e);
            }
        }).start();
    }

    public int get(T value) {
        return this.get(this.uidGetter.apply(value));
    }

    public int get(class_2960 id) {
        return this.priorities.getInt((Object)id);
    }
}

