/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config.value;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4587;
import snownee.jade.gui.config.value.OptionValue;

public class InputOptionValue<T>
extends OptionValue<T> {
    public static final Predicate<String> ANY = s -> true;
    public static final Predicate<String> INTEGER = s -> s.matches("^[0-9]*$");
    public static final Predicate<String> FLOAT = s -> s.matches("[-+]?([0-9]*\\.[0-9]+|[0-9]+)") || s.endsWith(".") || s.isEmpty();
    private final class_342 textField;

    public InputOptionValue(String optionName, T value, Consumer<T> setter, Predicate<String> validator) {
        super(optionName, setter);
        this.value = value;
        this.textField = new WatchedTextfield(this, this.client.field_1772, 0, 0, 98, 18);
        this.textField.method_1852(String.valueOf(value));
        this.textField.method_1890(validator);
    }

    @Override
    protected void drawValue(class_4587 matrixStack, int entryWidth, int entryHeight, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.textField.field_22760 = x;
        this.textField.field_22761 = y + entryHeight / 6;
        this.textField.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public class_339 getListener() {
        return this.textField;
    }

    private void setValue(String text) {
        if (this.value instanceof String) {
            this.value = text;
        }
        try {
            if (this.value instanceof Integer) {
                this.value = Integer.valueOf(text);
            } else if (this.value instanceof Short) {
                this.value = Short.valueOf(text);
            } else if (this.value instanceof Byte) {
                this.value = Byte.valueOf(text);
            } else if (this.value instanceof Long) {
                this.value = Long.valueOf(text);
            } else if (this.value instanceof Double) {
                this.value = Double.valueOf(text);
            } else if (this.value instanceof Float) {
                this.value = Float.valueOf(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.save();
    }

    private static class WatchedTextfield
    extends class_342 {
        private final InputOptionValue<?> watcher;

        public WatchedTextfield(InputOptionValue<?> watcher, class_327 fontRenderer, int x, int y, int width, int height) {
            super(fontRenderer, x, y, width, height, (class_2561)class_2561.method_43470((String)""));
            this.watcher = watcher;
        }

        public void method_1867(String string) {
            super.method_1867(string);
            this.watcher.setValue(this.method_1882());
        }

        public void method_1852(String value) {
            super.method_1852(value);
            this.watcher.setValue(this.method_1882());
        }

        public void method_1877(int count) {
            super.method_1877(count);
            this.watcher.setValue(this.method_1882());
        }

        public void method_1875(int pos) {
            super.method_1875(pos);
            this.watcher.setValue(this.method_1882());
        }
    }
}

