/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.hopper;

import me.jellysquid.mods.lithium.api.inventory.LithiumDefaultedList;
import me.jellysquid.mods.lithium.common.hopper.ComparatorUpdatePattern;
import me.jellysquid.mods.lithium.common.hopper.HopperHelper;
import me.jellysquid.mods.lithium.common.hopper.LithiumDoubleStackList;
import me.jellysquid.mods.lithium.common.hopper.StorableItemStack;
import me.jellysquid.mods.lithium.mixin.block.hopper.DefaultedListAccessor;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_3532;

public class LithiumStackList
extends class_2371<class_1799>
implements LithiumDefaultedList {
    final int maxCountPerStack;
    protected int cachedSignalStrength;
    private ComparatorUpdatePattern cachedComparatorUpdatePattern;
    private boolean signalStrengthOverride;
    private long modCount;
    private int occupiedSlots;
    private int fullSlots;
    LithiumDoubleStackList parent;

    public LithiumStackList(class_2371<class_1799> original, int maxCountPerStack) {
        super(((DefaultedListAccessor)original).getDelegate(), (Object)class_1799.field_8037);
        this.maxCountPerStack = maxCountPerStack;
        this.cachedSignalStrength = -1;
        this.cachedComparatorUpdatePattern = null;
        this.modCount = 0L;
        this.signalStrengthOverride = false;
        this.occupiedSlots = 0;
        this.fullSlots = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = (class_1799)this.get(i);
            if (stack.method_7960()) continue;
            ++this.occupiedSlots;
            if (stack.method_7914() <= stack.method_7947()) {
                ++this.fullSlots;
            }
            ((StorableItemStack)stack).registerToInventory(this, i);
        }
    }

    public LithiumStackList(int maxCountPerStack) {
        super(null, (Object)class_1799.field_8037);
        this.maxCountPerStack = maxCountPerStack;
        this.cachedSignalStrength = -1;
    }

    public long getModCount() {
        return this.modCount;
    }

    public void changedALot() {
        class_1799 stack;
        int i;
        this.changed();
        this.occupiedSlots = 0;
        this.fullSlots = 0;
        int size = this.size();
        for (i = 0; i < size; ++i) {
            stack = (class_1799)this.get(i);
            if (stack.method_7960()) continue;
            ++this.occupiedSlots;
            if (stack.method_7914() <= stack.method_7947()) {
                ++this.fullSlots;
            }
            ((StorableItemStack)stack).unregisterFromInventory(this);
        }
        for (i = 0; i < size; ++i) {
            stack = (class_1799)this.get(i);
            if (stack.method_7960()) continue;
            ((StorableItemStack)stack).registerToInventory(this, i);
        }
    }

    public void beforeSlotCountChange(int slot, int newCount) {
        class_1799 stack = (class_1799)this.get(slot);
        int count = stack.method_7947();
        if (newCount <= 0) {
            ((StorableItemStack)stack).unregisterFromInventory(this, slot);
        }
        int maxCount = stack.method_7914();
        this.occupiedSlots -= newCount <= 0 ? 1 : 0;
        this.fullSlots += (newCount >= maxCount ? 1 : 0) - (count >= maxCount ? 1 : 0);
        this.changed();
    }

    public void changed() {
        this.cachedSignalStrength = -1;
        this.cachedComparatorUpdatePattern = null;
        ++this.modCount;
    }

    public class_1799 set(int index, class_1799 element) {
        class_1799 previous = (class_1799)super.set(index, (Object)element);
        if (previous != element) {
            ((StorableItemStack)previous).unregisterFromInventory(this, index);
            if (!element.method_7960()) {
                ((StorableItemStack)element).registerToInventory(this, index);
            }
            this.occupiedSlots += (previous.method_7960() ? 1 : 0) - (element.method_7960() ? 1 : 0);
            this.fullSlots += (element.method_7947() >= element.method_7914() ? 1 : 0) - (previous.method_7947() >= previous.method_7914() ? 1 : 0);
            this.changed();
        }
        return previous;
    }

    public void add(int slot, class_1799 element) {
        super.add(slot, (Object)element);
        if (!element.method_7960()) {
            ((StorableItemStack)element).registerToInventory(this, this.indexOf(element));
        }
        this.changedALot();
    }

    public class_1799 remove(int index) {
        class_1799 previous = (class_1799)super.remove(index);
        ((StorableItemStack)previous).unregisterFromInventory(this, index);
        this.changedALot();
        return previous;
    }

    public void clear() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = (class_1799)this.get(i);
            if (stack.method_7960()) continue;
            ((StorableItemStack)stack).unregisterFromInventory(this, i);
        }
        super.clear();
        this.changedALot();
    }

    public boolean hasSignalStrengthOverride() {
        return this.signalStrengthOverride;
    }

    public int getSignalStrength(class_1263 inventory) {
        if (this.signalStrengthOverride) {
            return 0;
        }
        int signalStrength = this.cachedSignalStrength;
        if (signalStrength == -1) {
            this.cachedSignalStrength = this.calculateSignalStrength(inventory.method_5439());
            return this.cachedSignalStrength;
        }
        return signalStrength;
    }

    int calculateSignalStrength(int inventorySize) {
        int i = 0;
        float f = 0.0f;
        inventorySize = Math.min(inventorySize, this.size());
        for (int j = 0; j < inventorySize; ++j) {
            class_1799 itemStack = (class_1799)this.get(j);
            if (itemStack.method_7960()) continue;
            f += (float)itemStack.method_7947() / (float)Math.min(this.maxCountPerStack, itemStack.method_7914());
            ++i;
        }
        return class_3532.method_15375((float)((f /= (float)inventorySize) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public void setReducedSignalStrengthOverride() {
        this.signalStrengthOverride = true;
    }

    public void clearSignalStrengthOverride() {
        this.signalStrengthOverride = false;
    }

    public void runComparatorUpdatePatternOnFailedExtract(LithiumStackList masterStackList, class_1263 inventory) {
        if (inventory instanceof class_2586) {
            if (this.cachedComparatorUpdatePattern == null) {
                this.cachedComparatorUpdatePattern = HopperHelper.determineComparatorUpdatePattern(inventory, masterStackList);
            }
            this.cachedComparatorUpdatePattern.apply((class_2586)inventory, masterStackList);
        }
    }

    public int getOccupiedSlots() {
        return this.occupiedSlots;
    }

    public int getFullSlots() {
        return this.fullSlots;
    }

    @Override
    public void changedInteractionConditions() {
        ++this.modCount;
    }
}

