/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.server;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.impl.networking.AbstractNetworkAddon;
import net.fabricmc.fabric.impl.networking.GenericFutureListenerHolder;
import net.fabricmc.fabric.impl.networking.server.QueryIdFactory;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.accessor.LoginQueryResponseC2SPacketAccessor;
import net.fabricmc.fabric.mixin.networking.accessor.ServerLoginNetworkHandlerAccessor;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2899;
import net.minecraft.class_2907;
import net.minecraft.class_2913;
import net.minecraft.class_2960;
import net.minecraft.class_3248;
import net.minecraft.class_7648;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class ServerLoginNetworkAddon
extends AbstractNetworkAddon<ServerLoginNetworking.LoginQueryResponseHandler>
implements PacketSender {
    private final class_2535 connection;
    private final class_3248 handler;
    private final MinecraftServer server;
    private final QueryIdFactory queryIdFactory;
    private final Collection<java.util.concurrent.Future<?>> waits = new ConcurrentLinkedQueue();
    private final Map<Integer, class_2960> channels = new ConcurrentHashMap<Integer, class_2960>();
    private boolean firstQueryTick = true;

    public ServerLoginNetworkAddon(class_3248 handler) {
        super(ServerNetworkingImpl.LOGIN, "ServerLoginNetworkAddon for " + handler.method_14383());
        this.connection = handler.field_14158;
        this.handler = handler;
        this.server = ((ServerLoginNetworkHandlerAccessor)handler).getServer();
        this.queryIdFactory = QueryIdFactory.create();
        ((ServerLoginConnectionEvents.Init)ServerLoginConnectionEvents.INIT.invoker()).onLoginInit(handler, this.server);
        this.receiver.startSession(this);
    }

    public boolean queryTick() {
        if (this.firstQueryTick) {
            this.sendCompressionPacket();
            for (Map.Entry<class_2960, ServerLoginNetworking.LoginQueryResponseHandler> entry : ServerNetworkingImpl.LOGIN.getHandlers().entrySet()) {
                ServerLoginNetworking.registerReceiver(this.handler, entry.getKey(), entry.getValue());
            }
            ((ServerLoginConnectionEvents.QueryStart)ServerLoginConnectionEvents.QUERY_START.invoker()).onLoginStart(this.handler, this.server, this, this.waits::add);
            this.firstQueryTick = false;
        }
        AtomicReference error = new AtomicReference();
        this.waits.removeIf(future -> {
            if (!future.isDone()) {
                return false;
            }
            try {
                future.get();
            }
            catch (ExecutionException ex) {
                Throwable caught = ex.getCause();
                error.getAndUpdate(oldEx -> {
                    if (oldEx == null) {
                        return caught;
                    }
                    oldEx.addSuppressed(caught);
                    return oldEx;
                });
            }
            catch (InterruptedException | CancellationException exception) {
                // empty catch block
            }
            return true;
        });
        return this.channels.isEmpty() && this.waits.isEmpty();
    }

    private void sendCompressionPacket() {
        if (this.server.method_3773() >= 0 && !this.connection.method_10756()) {
            this.connection.method_10752((class_2596)new class_2907(this.server.method_3773()), class_7648.method_45084(() -> this.connection.method_10760(this.server.method_3773(), true)));
        }
    }

    public boolean handle(class_2913 packet) {
        LoginQueryResponseC2SPacketAccessor access = (LoginQueryResponseC2SPacketAccessor)packet;
        return this.handle(access.getQueryId(), access.getResponse());
    }

    private boolean handle(int queryId, @Nullable class_2540 originalBuf) {
        this.logger.debug("Handling inbound login query with id {}", (Object)queryId);
        class_2960 channel = this.channels.remove(queryId);
        if (channel == null) {
            this.logger.warn("Query ID {} was received but no query has been associated in {}!", (Object)queryId, (Object)this.connection);
            return false;
        }
        boolean understood = originalBuf != null;
        @Nullable ServerLoginNetworking.LoginQueryResponseHandler handler = ServerNetworkingImpl.LOGIN.getHandler(channel);
        if (handler == null) {
            return false;
        }
        class_2540 buf = understood ? PacketByteBufs.slice((ByteBuf)originalBuf) : PacketByteBufs.empty();
        try {
            handler.receive(this.server, this.handler, understood, buf, this.waits::add, this);
        }
        catch (Throwable ex) {
            this.logger.error("Encountered exception while handling in channel \"{}\"", (Object)channel, (Object)ex);
            throw ex;
        }
        return true;
    }

    @Override
    public class_2596<?> createPacket(class_2960 channelName, class_2540 buf) {
        int queryId = this.queryIdFactory.nextId();
        class_2899 ret = new class_2899(queryId, channelName, buf);
        return ret;
    }

    @Override
    public void sendPacket(class_2596<?> packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.method_10743(packet);
    }

    @Override
    public void sendPacket(class_2596<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
        this.sendPacket(packet, GenericFutureListenerHolder.create(callback));
    }

    @Override
    public void sendPacket(class_2596<?> packet, class_7648 callback) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.method_10752(packet, callback);
    }

    public void registerOutgoingPacket(class_2899 packet) {
        this.channels.put(packet.method_12592(), packet.method_36176());
    }

    @Override
    protected void handleRegistration(class_2960 channelName) {
    }

    @Override
    protected void handleUnregistration(class_2960 channelName) {
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ServerLoginConnectionEvents.Disconnect)ServerLoginConnectionEvents.DISCONNECT.invoker()).onLoginDisconnect(this.handler, this.server);
        this.receiver.endSession(this);
    }

    public void handlePlayTransition() {
        this.receiver.endSession(this);
    }

    @Override
    protected boolean isReservedChannel(class_2960 channelName) {
        return false;
    }
}

