/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.CollapsingEntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListStackEntry;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsedStack;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ScrolledEntryListWidget
extends CollapsingEntryListWidget {
    private List<Object> stacks = new ArrayList<Object>();
    protected List<EntryListStackEntry> entries = Collections.emptyList();
    protected int blockedCount;
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            return ScrolledEntryListWidget.this.getBounds();
        }

        public int getMaxScrollHeight() {
            return class_3532.method_15386((float)((float)(ScrolledEntryListWidget.this.stacks.size() + ScrolledEntryListWidget.this.blockedCount) / ((float)ScrolledEntryListWidget.this.innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
        }
    };

    @Override
    protected void renderEntries(boolean fastEntryRendering, class_4587 matrices, int mouseX, int mouseY, float delta) {
        ScissorsHandler.INSTANCE.scissor(this.bounds);
        int skip = Math.max(0, class_3532.method_15357((double)(this.scrolling.scrollAmount() / (double)ScrolledEntryListWidget.entrySize())));
        int nextIndex = skip * this.innerBounds.width / ScrolledEntryListWidget.entrySize();
        this.blockedCount = 0;
        BatchedEntryRendererManager helper = new BatchedEntryRendererManager();
        Int2ObjectMap<CollapsedStack> indexedCollapsedStack = this.getCollapsedStackIndexed();
        int i = nextIndex;
        for (int cont = nextIndex; cont < this.entries.size(); ++cont) {
            EntryListStackEntry entry = this.entries.get(cont);
            Rectangle entryBounds = entry.getBounds();
            entryBounds.y = entry.backupY - this.scrolling.scrollAmountInt();
            if (entryBounds.y > this.bounds.getMaxY() || this.stacks.size() <= i) break;
            if (ScrolledEntryListWidget.notSteppingOnExclusionZones(entryBounds.x, entryBounds.y, entryBounds.width, entryBounds.height)) {
                Object stack = this.stacks.get(i++);
                entry.clearStacks();
                if (stack instanceof EntryStack) {
                    EntryStack entryStack = (EntryStack)stack;
                    if (!entryStack.isEmpty()) {
                        entry.entry(entryStack);
                        helper.add(entry);
                    }
                } else {
                    List ingredient = (List)stack;
                    if (!ingredient.isEmpty()) {
                        entry.entries((Collection)ingredient);
                        helper.addSlow(entry);
                    }
                }
                entry.collapsed((CollapsedStack)indexedCollapsedStack.get(i - 1));
                continue;
            }
            ++this.blockedCount;
        }
        helper.render(this.debugger.debugTime, this.debugger.size, this.debugger.time, matrices, mouseX, mouseY, delta);
        this.scrolling.updatePosition(delta);
        ScissorsHandler.INSTANCE.removeLastScissor();
        if (this.scrolling.getMaxScroll() > 0) {
            this.scrolling.renderScrollBar(0, 1.0f, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        }
    }

    @Override
    protected void updateEntries(int entrySize, boolean zoomed) {
        int width = this.innerBounds.width / entrySize;
        int pageHeight = this.innerBounds.height / entrySize;
        int slotsToPrepare = Math.max(this.stacks.size() * 3, width * pageHeight * 3);
        int currentX = 0;
        int currentY = 0;
        ArrayList entries = Lists.newArrayList();
        for (int i = 0; i < slotsToPrepare; ++i) {
            int xPos = currentX * entrySize + this.innerBounds.x;
            int yPos = currentY * entrySize + this.innerBounds.y;
            entries.add((EntryListStackEntry)new EntryListStackEntry(this, xPos, yPos, entrySize, zoomed).noBackground());
            if (++currentX < width) continue;
            currentX = 0;
            ++currentY;
        }
        this.entries = entries;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.containsChecked(mouseX, mouseY, false) && !class_437.method_25441()) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.hasSpace() && this.scrolling.mouseDragged(mouseX, mouseY, button, dx, dy)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.hasSpace()) {
            return false;
        }
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public List<Object> getStacks() {
        return this.stacks;
    }

    @Override
    public void setStacks(List<Object> stacks) {
        this.stacks = stacks;
    }

    @Override
    public Stream<EntryStack<?>> getEntries() {
        int skip = Math.max(0, class_3532.method_15357((double)(this.scrolling.scrollAmount() / (double)ScrolledEntryListWidget.entrySize())));
        int nextIndex = skip * this.innerBounds.width / ScrolledEntryListWidget.entrySize();
        return this.entries.stream().skip(nextIndex).filter(entry -> entry.getBounds().y <= this.bounds.getMaxY()).map(EntryWidget::getCurrentEntry).filter((Predicate<EntryStack>)Predicates.not(EntryStack::isEmpty));
    }

    @Override
    protected List<EntryListStackEntry> getEntryWidgets() {
        return this.entries;
    }
}

