/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.legendarytooltips.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.Loader;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3518;

public class LegacyConfigConverter {
    private static final String FILENAME = "legendarytooltips.json5";

    public static void convert() {
        File legacyConfig = FabricLoader.getInstance().getConfigDir().resolve(FILENAME).toFile();
        if (legacyConfig.exists() && !legacyConfig.isDirectory()) {
            Loader.LOGGER.info("Legacy configuration file \"{}\" found, converting to new format!", (Object)FILENAME);
            try (InputStreamReader reader = new InputStreamReader(new FileInputStream(legacyConfig));){
                int i;
                JsonObject rootObject = class_3518.method_15274((Reader)reader, (boolean)true);
                if (rootObject.has("nameSeparator")) {
                    LegendaryTooltipsConfig.INSTANCE.nameSeparator.set((Object)class_3518.method_15270((JsonObject)rootObject, (String)"nameSeparator"));
                }
                if (rootObject.has("bordersMatchRarity")) {
                    LegendaryTooltipsConfig.INSTANCE.bordersMatchRarity.set((Object)class_3518.method_15270((JsonObject)rootObject, (String)"bordersMatchRarity"));
                }
                if (rootObject.has("tooltipShadow")) {
                    LegendaryTooltipsConfig.INSTANCE.tooltipShadow.set((Object)class_3518.method_15270((JsonObject)rootObject, (String)"tooltipShadow"));
                }
                if (rootObject.has("shineEffect")) {
                    LegendaryTooltipsConfig.INSTANCE.shineEffect.set((Object)class_3518.method_15270((JsonObject)rootObject, (String)"shineEffect"));
                }
                if (rootObject.has("startColors")) {
                    JsonArray startColorsArray = class_3518.method_15261((JsonObject)rootObject, (String)"startColors");
                    for (i = 0; i < startColorsArray.size() && i < LegendaryTooltipsConfig.startColorConfigs.size(); ++i) {
                        LegendaryTooltipsConfig.startColorConfigs.get(i).set((Object)(Long.valueOf(startColorsArray.get(i).getAsLong()) & 0xFFFFFFFFL));
                    }
                }
                if (rootObject.has("endColors")) {
                    JsonArray endColorsArray = class_3518.method_15261((JsonObject)rootObject, (String)"endColors");
                    for (i = 0; i < endColorsArray.size() && i < LegendaryTooltipsConfig.endColorConfigs.size(); ++i) {
                        LegendaryTooltipsConfig.endColorConfigs.get(i).set((Object)(Long.valueOf(endColorsArray.get(i).getAsLong()) & 0xFFFFFFFFL));
                    }
                }
                if (rootObject.has("framePriorities")) {
                    ArrayList<Integer> newPriorities = new ArrayList<Integer>();
                    JsonArray framePrioritiesArray = class_3518.method_15261((JsonObject)rootObject, (String)"framePriorities");
                    for (int i2 = 0; i2 < framePrioritiesArray.size(); ++i2) {
                        newPriorities.add(framePrioritiesArray.get(i2).getAsInt());
                    }
                    LegendaryTooltipsConfig.INSTANCE.framePriorities.set(newPriorities);
                }
                if (rootObject.has("itemSelectors")) {
                    JsonArray itemSelectorsArray = class_3518.method_15261((JsonObject)rootObject, (String)"itemSelectors");
                    for (int i3 = 0; i3 < itemSelectorsArray.size(); ++i3) {
                        ArrayList<String> newSelectors = new ArrayList<String>();
                        for (JsonElement selector : itemSelectorsArray.get(i3).getAsJsonArray()) {
                            newSelectors.add(selector.getAsString());
                        }
                        LegendaryTooltipsConfig.itemSelectors.get(i3).set(newSelectors);
                    }
                }
                Loader.LOGGER.info("Backing up legacy file to \"{}.bak\".  Configuration file \"{}\" updated from legacy configuration.", (Object)FILENAME, (Object)"legendarytooltips-common.toml");
                LegendaryTooltipsConfig.SPEC.save();
                LegendaryTooltipsConfig.reset();
                reader.close();
                legacyConfig.renameTo(FabricLoader.getInstance().getConfigDir().resolve("legendarytooltips.json5.bak").toFile());
            }
            catch (Exception e) {
                Loader.LOGGER.warn("An error occurred while converting a legacy configuration: {}", (Throwable)e);
            }
        }
    }
}

