/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.renderer;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.provider.EmptyPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.renderer.PreviewRenderer;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.util.MergedItemStack;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class BasePreviewRenderer
implements PreviewRenderer {
    protected PreviewType previewType;
    protected int compactMaxRowSize;
    protected int maxRowSize = 9;
    protected ResourceLocation textureOverride;
    protected PreviewProvider provider;
    protected List<MergedItemStack> items = new ArrayList<MergedItemStack>();
    protected PreviewContext previewContext;
    private final int slotWidth;
    private final int slotHeight;
    private final int slotXOffset;
    private final int slotYOffset;

    protected BasePreviewRenderer(int slotWidth, int slotHeight, int slotXOffset, int slotYOffset) {
        this.previewType = PreviewType.FULL;
        this.slotWidth = slotWidth;
        this.slotHeight = slotHeight;
        this.slotXOffset = slotXOffset;
        this.slotYOffset = slotYOffset;
        this.setPreview(PreviewContext.of(ItemStack.f_41583_), EmptyPreviewProvider.INSTANCE);
    }

    protected int getMaxRowSize() {
        return this.previewType == PreviewType.COMPACT ? this.compactMaxRowSize : this.maxRowSize;
    }

    protected int getInvSize() {
        return this.previewType == PreviewType.COMPACT ? Math.max(1, this.items.size()) : this.provider.getInventoryMaxSize(this.previewContext);
    }

    @Override
    public void setPreviewType(PreviewType type) {
        this.previewType = type;
    }

    @Override
    public void setPreview(PreviewContext context, PreviewProvider provider) {
        List<ItemStack> inventory = provider.getInventory(context);
        int rowSize = provider.getMaxRowSize(context);
        this.compactMaxRowSize = ShulkerBoxTooltip.config.preview.defaultMaxRowSize;
        if (this.compactMaxRowSize <= 0) {
            this.compactMaxRowSize = 9;
        }
        if (rowSize <= 0) {
            rowSize = this.compactMaxRowSize;
        }
        this.maxRowSize = rowSize;
        this.textureOverride = provider.getTextureOverride(context);
        this.provider = provider;
        this.items = MergedItemStack.mergeInventory(inventory, provider.getInventoryMaxSize(context), ShulkerBoxTooltip.config.preview.compactPreviewNbtBehavior != Configuration.CompactPreviewNbtBehavior.SEPARATE);
        this.previewContext = context;
    }

    private void drawItem(ItemStack stack, int x, int y, Font textRenderer, ItemRenderer itemRenderer, int slot, boolean shortItemCount) {
        String countLabel = "";
        int maxRowSize = this.getMaxRowSize();
        if (stack.m_41613_() != 1) {
            countLabel = shortItemCount ? ShulkerBoxTooltipUtil.abrieviateInteger(stack.m_41613_()) : String.valueOf(stack.m_41613_());
        }
        x = this.slotXOffset + x + this.slotWidth * (slot % maxRowSize);
        y = this.slotYOffset + y + this.slotHeight * (slot / maxRowSize);
        itemRenderer.m_115203_(stack, x, y);
        itemRenderer.m_115174_(textRenderer, stack, x, y, countLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawItems(int x, int y, int z, Font textRenderer, ItemRenderer itemRenderer) {
        float prevOffset = itemRenderer.f_115093_;
        itemRenderer.f_115093_ = z;
        try {
            if (this.previewType == PreviewType.COMPACT) {
                boolean shortItemCounts = ShulkerBoxTooltip.config.preview.shortItemCounts;
                int size = this.items.size();
                for (int slot = 0; slot < size; ++slot) {
                    this.drawItem(this.items.get(slot).get(), x, y, textRenderer, itemRenderer, slot, shortItemCounts);
                }
            } else {
                for (MergedItemStack compactor : this.items) {
                    int size = compactor.size();
                    for (int slot = 0; slot < size; ++slot) {
                        this.drawItem(compactor.getSubStack(slot), x, y, textRenderer, itemRenderer, slot, false);
                    }
                }
            }
        }
        finally {
            itemRenderer.f_115093_ = prevOffset;
        }
    }
}

