/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip;

import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.provider.BlockEntityPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProviderRegistry;
import com.misterpemodder.shulkerboxtooltip.forge.ShulkerBoxTooltipImpl;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.config.ConfigurationHandler;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.provider.EnderChestPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.provider.PreviewProviderRegistryImpl;
import com.misterpemodder.shulkerboxtooltip.impl.provider.ShulkerBoxPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShulkerBoxTooltip
implements ShulkerBoxTooltipApi {
    public static final String MOD_ID = "shulkerboxtooltip";
    public static final String MOD_NAME = "ShulkerBoxTooltip";
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"ShulkerBoxTooltip");
    public static Configuration config;
    public static Configuration savedConfig;
    private static boolean registeredProviders;
    public static final Item[] SHULKER_BOX_ITEMS;

    public static void init() {
        savedConfig = ConfigurationHandler.register();
        config = ConfigurationHandler.copyOf(savedConfig);
        ServerNetworking.init();
    }

    private static void register(PreviewProviderRegistry registry, String id, PreviewProvider provider, Item ... items) {
        registry.register(ShulkerBoxTooltipUtil.id(id), provider, items);
    }

    @Override
    public void registerProviders(PreviewProviderRegistry registry) {
        ShulkerBoxTooltip.register(registry, "shulker_box", new ShulkerBoxPreviewProvider(), SHULKER_BOX_ITEMS);
        ShulkerBoxTooltip.register(registry, "chest_like", new BlockEntityPreviewProvider(27, true), Items.f_42009_, Items.f_42149_, Items.f_42768_);
        ShulkerBoxTooltip.register(registry, "furnace_like", new BlockEntityPreviewProvider(3, false, 1), Items.f_41962_, Items.f_42770_, Items.f_42769_);
        ShulkerBoxTooltip.register(registry, "dropper_like", new BlockEntityPreviewProvider(9, true, 3), Items.f_42162_, Items.f_41855_);
        ShulkerBoxTooltip.register(registry, "hopper", new BlockEntityPreviewProvider(5, true, 5), Items.f_42155_);
        ShulkerBoxTooltip.register(registry, "brewing_stand", new BlockEntityPreviewProvider(5, false, 3), Items.f_42543_);
        ShulkerBoxTooltip.register(registry, "ender_chest", new EnderChestPreviewProvider(), Items.f_42108_);
    }

    public static void initPreviewItemsMap() {
        if (registeredProviders) {
            return;
        }
        registeredProviders = true;
        List<PluginContainer> plugins = ShulkerBoxTooltip.getPluginContainers();
        String pluginText = switch (plugins.size()) {
            case 0 -> "Loading %d plugins";
            case 1 -> "Loading %d plugin: %s";
            default -> "Loading %d plugins: %s";
        };
        LOGGER.info("[ShulkerBoxTooltip] " + pluginText, (Object)plugins.size(), (Object)plugins.stream().map(PluginContainer::modId).collect(Collectors.joining(", ")));
        for (PluginContainer plugin : plugins) {
            PreviewProviderRegistryImpl registry = PreviewProviderRegistryImpl.INSTANCE;
            int prevSize = registry.getIds().size();
            registry.setLocked(false);
            plugin.apiImplSupplier.get().registerProviders(registry);
            registry.setLocked(true);
            int registered = registry.getIds().size() - prevSize;
            String providerText = registered == 1 ? "Registered %d provider for mod %s" : "Registered %d providers for mod %s";
            LOGGER.info("[ShulkerBoxTooltip] " + providerText, (Object)registered, (Object)plugin.modId());
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isClient() {
        return ShulkerBoxTooltipImpl.isClient();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigDir() {
        return ShulkerBoxTooltipImpl.getConfigDir();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<PluginContainer> getPluginContainers() {
        return ShulkerBoxTooltipImpl.getPluginContainers();
    }

    static {
        registeredProviders = false;
        SHULKER_BOX_ITEMS = new Item[]{Items.f_42265_, Items.f_42266_, Items.f_42267_, Items.f_42268_, Items.f_42269_, Items.f_42270_, Items.f_42271_, Items.f_42272_, Items.f_42273_, Items.f_42274_, Items.f_42275_, Items.f_42224_, Items.f_42225_, Items.f_42226_, Items.f_42227_, Items.f_42228_, Items.f_42229_};
    }

    public record PluginContainer(String modId, Supplier<ShulkerBoxTooltipApi> apiImplSupplier) {
    }
}

