/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.render.points;

import org.enginehub.worldeditcui.event.listeners.CUIRenderContext;
import org.enginehub.worldeditcui.render.ConfiguredColour;
import org.enginehub.worldeditcui.render.RenderStyle;
import org.enginehub.worldeditcui.render.shapes.Render3DBox;
import org.enginehub.worldeditcui.util.Vector2;

public class PointRectangle {
    private static final double OFF = 0.03;
    private static final Vector2 MIN_VEC = new Vector2(0.03, 0.03);
    private static final Vector2 MAX_VEC = new Vector2(1.03, 1.03);
    protected Vector2 point;
    protected RenderStyle style = ConfiguredColour.POLYPOINT.style();
    private int min;
    private int max;
    private Render3DBox box;

    public PointRectangle(int x, int z) {
        this(new Vector2(x, z));
    }

    public PointRectangle(Vector2 point) {
        this.setPoint(point);
    }

    public void render(CUIRenderContext ctx) {
        this.box.render(ctx);
    }

    public Vector2 getPoint() {
        return this.point;
    }

    public void setPoint(Vector2 point) {
        this.point = point;
    }

    public RenderStyle getStyle() {
        return this.style;
    }

    public void setStyle(RenderStyle style) {
        this.style = style;
    }

    public void setMinMax(int min, int max) {
        this.min = min;
        this.max = max;
        this.update();
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    private void update() {
        this.box = new Render3DBox(this.style, this.point.subtract(MIN_VEC).toVector3((float)this.min - 0.03f), this.point.add(MAX_VEC).toVector3((float)(this.max + 1) + 0.03f));
    }
}

