/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractMeshConsumer;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.ChunkRenderInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.TerrainBlockRenderInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.TerrainFallbackConsumer;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_5539;
import net.minecraft.class_750;
import net.minecraft.class_846;
import net.minecraft.class_853;

@Environment(value=EnvType.CLIENT)
public class TerrainRenderContext
extends AbstractRenderContext {
    public static final ThreadLocal<TerrainRenderContext> POOL = ThreadLocal.withInitial(TerrainRenderContext::new);
    private final TerrainBlockRenderInfo blockInfo = new TerrainBlockRenderInfo();
    private final ChunkRenderInfo chunkInfo = new ChunkRenderInfo();
    private final AoCalculator aoCalc = new AoCalculator(this.blockInfo, this.chunkInfo::cachedBrightness, this.chunkInfo::cachedAoLevel);
    private final AbstractMeshConsumer meshConsumer = new AbstractMeshConsumer(this.blockInfo, this.chunkInfo::getInitializedBuffer, this.aoCalc, this::transform){

        @Override
        protected int overlay() {
            return TerrainRenderContext.this.overlay;
        }

        @Override
        protected class_1159 matrix() {
            return TerrainRenderContext.this.matrix;
        }

        @Override
        protected class_4581 normalMatrix() {
            return TerrainRenderContext.this.normalMatrix;
        }
    };
    private final TerrainFallbackConsumer fallbackConsumer = new TerrainFallbackConsumer(this.blockInfo, this.chunkInfo::getInitializedBuffer, this.aoCalc, this::transform){

        @Override
        protected int overlay() {
            return TerrainRenderContext.this.overlay;
        }

        @Override
        protected class_1159 matrix() {
            return TerrainRenderContext.this.matrix;
        }

        @Override
        protected class_4581 normalMatrix() {
            return TerrainRenderContext.this.normalMatrix;
        }
    };

    public void prepare(class_853 blockView, class_846.class_851 chunkRenderer, class_846.class_851.class_4578.class_7435 renderData, class_750 builders, Set<class_1921> initializedLayers) {
        this.blockInfo.setBlockView((class_1920)blockView);
        this.chunkInfo.prepare(blockView, chunkRenderer, renderData, builders, initializedLayers);
    }

    public void release() {
        this.chunkInfo.release();
        this.blockInfo.release();
    }

    public boolean tessellateBlock(class_2680 blockState, class_2338 blockPos, class_1087 model, class_4587 matrixStack) {
        this.matrix = matrixStack.method_23760().method_23761();
        this.normalMatrix = matrixStack.method_23760().method_23762();
        try {
            this.aoCalc.clear();
            this.blockInfo.prepareForBlock(blockState, blockPos, model.method_4708());
            ((FabricBakedModel)model).emitBlockQuads(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, this.blockInfo.randomSupplier, (RenderContext)this);
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Tessellating block in world - Indigo Renderer");
            class_129 crashReportSection = crashReport.method_562("Block being tessellated");
            class_129.method_586((class_129)crashReportSection, (class_5539)this.chunkInfo.blockView, (class_2338)blockPos, (class_2680)blockState);
            throw new class_148(crashReport);
        }
        return false;
    }

    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    public Consumer<class_1087> fallbackConsumer() {
        return this.fallbackConsumer;
    }

    public QuadEmitter getEmitter() {
        return this.meshConsumer.getEmitter();
    }
}

