/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.RenderMaterialImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractQuadRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_777;

@Environment(value=EnvType.CLIENT)
public abstract class TerrainFallbackConsumer
extends AbstractQuadRenderer
implements Consumer<class_1087> {
    private static final RenderMaterialImpl.Value MATERIAL_FLAT = (RenderMaterialImpl.Value)IndigoRenderer.INSTANCE.materialFinder().disableAo(0, true).find();
    private static final RenderMaterialImpl.Value MATERIAL_SHADED = (RenderMaterialImpl.Value)IndigoRenderer.INSTANCE.materialFinder().find();
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.material(MATERIAL_SHADED);
        }

        public QuadEmitter emit() {
            throw new UnsupportedOperationException("Fallback consumer does not support .emit()");
        }
    };

    TerrainFallbackConsumer(BlockRenderInfo blockInfo, Function<class_1921, class_4588> bufferFunc, AoCalculator aoCalc, RenderContext.QuadTransform transform) {
        super(blockInfo, bufferFunc, aoCalc, transform);
    }

    @Override
    public void accept(class_1087 model) {
        Supplier<class_5819> random = this.blockInfo.randomSupplier;
        RenderMaterialImpl.Value defaultMaterial = this.blockInfo.defaultAo && model.method_4708() ? MATERIAL_SHADED : MATERIAL_FLAT;
        class_2680 blockState = this.blockInfo.blockState;
        for (int i = 0; i <= 6; ++i) {
            class_2350 cullFace = ModelHelper.faceFromIndex((int)i);
            List quads = model.method_4707(blockState, cullFace, random.get());
            int count = quads.size();
            if (count == 0) continue;
            for (int j = 0; j < count; ++j) {
                class_777 q = (class_777)quads.get(j);
                this.renderQuad(q, cullFace, defaultMaterial);
            }
        }
    }

    private void renderQuad(class_777 quad, class_2350 cullFace, RenderMaterialImpl.Value defaultMaterial) {
        MutableQuadViewImpl editorQuad = this.editorQuad;
        editorQuad.fromVanilla(quad, defaultMaterial, cullFace);
        if (!this.transform.transform((MutableQuadView)editorQuad)) {
            return;
        }
        cullFace = editorQuad.cullFace();
        if (cullFace != null && !this.blockInfo.shouldDrawFace(cullFace)) {
            return;
        }
        if (!editorQuad.material().disableAo(0)) {
            this.aoCalc.compute(editorQuad, true);
            this.tessellateSmooth(editorQuad, this.blockInfo.defaultLayer, editorQuad.colorIndex());
        } else {
            if (cullFace == null) {
                editorQuad.geometryFlags();
            }
            this.tessellateFlat(editorQuad, this.blockInfo.defaultLayer, editorQuad.colorIndex());
        }
    }
}

