/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.defaults.cit.types;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_4720;
import org.lwjgl.opengl.GL11;
import shcm.shsupercm.fabric.citresewn.api.CITGlobalProperties;
import shcm.shsupercm.fabric.citresewn.api.CITTypeContainer;
import shcm.shsupercm.fabric.citresewn.cit.CIT;
import shcm.shsupercm.fabric.citresewn.cit.CITCache;
import shcm.shsupercm.fabric.citresewn.cit.CITCondition;
import shcm.shsupercm.fabric.citresewn.cit.CITContext;
import shcm.shsupercm.fabric.citresewn.cit.CITType;
import shcm.shsupercm.fabric.citresewn.defaults.cit.conditions.ConditionEnchantments;
import shcm.shsupercm.fabric.citresewn.defaults.config.CITResewnDefaultsConfig;
import shcm.shsupercm.fabric.citresewn.defaults.mixin.types.enchantment.BufferBuilderStorageAccessor;
import shcm.shsupercm.fabric.citresewn.defaults.mixin.types.enchantment.RenderPhaseAccessor;
import shcm.shsupercm.fabric.citresewn.ex.CITParsingException;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyGroup;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyKey;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;
import shcm.shsupercm.util.logic.Loops;

public class TypeEnchantment
extends CITType {
    public static final Container CONTAINER = new Container();
    public class_2960 texture;
    public int layer;
    public float speed;
    public float rotation;
    public float duration;
    public float r;
    public float g;
    public float b;
    public float a;
    public boolean useGlint;
    public boolean blur;
    public Blend blend;
    public final Map<GlintRenderLayer, class_1921> renderLayers = new EnumMap<GlintRenderLayer, class_1921>(GlintRenderLayer.class);
    private final MergeMethodIntensity methodIntensity = new MergeMethodIntensity();
    private Set<class_2960> enchantmentChecks = null;

    public Set<PropertyKey> typeProperties() {
        return Set.of(PropertyKey.of((String)"texture"), PropertyKey.of((String)"layer"), PropertyKey.of((String)"speed"), PropertyKey.of((String)"rotation"), PropertyKey.of((String)"duration"), PropertyKey.of((String)"r"), PropertyKey.of((String)"g"), PropertyKey.of((String)"b"), PropertyKey.of((String)"a"), PropertyKey.of((String)"useGlint"), PropertyKey.of((String)"blur"), PropertyKey.of((String)"blend"));
    }

    public void load(List<CITCondition> conditions, PropertyGroup properties, class_3300 resourceManager) throws CITParsingException {
        PropertyValue textureProp = properties.getLastWithoutMetadata("citresewn", new String[]{"texture"});
        this.texture = TypeEnchantment.resolveAsset((class_2960)properties.identifier, (PropertyValue)textureProp, (String)"textures", (String)".png", (class_3300)resourceManager);
        if (this.texture == null) {
            throw textureProp == null ? new CITParsingException("No texture specified", properties, -1) : new CITParsingException("Could not resolve texture", properties, textureProp.position());
        }
        PropertyValue layerProp = properties.getLastWithoutMetadataOrDefault("0", "citresewn", new String[]{"layer"});
        try {
            this.layer = Integer.parseInt(layerProp.value());
        }
        catch (Exception e) {
            throw new CITParsingException("Could not parse integer", properties, layerProp.position(), (Throwable)e);
        }
        this.speed = this.parseFloatOrDefault(1.0f, "speed", properties);
        this.rotation = this.parseFloatOrDefault(10.0f, "rotation", properties);
        this.duration = Math.max(0.0f, this.parseFloatOrDefault(0.0f, "duration", properties));
        this.r = Math.max(0.0f, this.parseFloatOrDefault(1.0f, "r", properties));
        this.g = Math.max(0.0f, this.parseFloatOrDefault(1.0f, "g", properties));
        this.b = Math.max(0.0f, this.parseFloatOrDefault(1.0f, "b", properties));
        this.a = Math.max(0.0f, this.parseFloatOrDefault(1.0f, "a", properties));
        this.useGlint = Boolean.parseBoolean(properties.getLastWithoutMetadataOrDefault("false", "citresewn", new String[]{"useGlint"}).value());
        this.blur = Boolean.parseBoolean(properties.getLastWithoutMetadataOrDefault("true", "citresewn", new String[]{"blur"}).value());
        PropertyValue blendProp = properties.getLastWithoutMetadataOrDefault("add", "citresewn", new String[]{"blend"});
        try {
            this.blend = Blend.getBlend(blendProp.value());
        }
        catch (Exception e) {
            throw new CITParsingException("Could not parse blending method", properties, blendProp.position(), (Throwable)e);
        }
        for (CITCondition condition : conditions) {
            if (!(condition instanceof ConditionEnchantments)) continue;
            ConditionEnchantments enchantments = (ConditionEnchantments)condition;
            if (this.enchantmentChecks == null && enchantments.getEnchantments().length > 0) {
                this.enchantmentChecks = new HashSet<class_2960>();
            }
            this.enchantmentChecks.addAll(Arrays.asList(enchantments.getEnchantments()));
        }
    }

    private float parseFloatOrDefault(float defaultValue, String propertyName, PropertyGroup properties) throws CITParsingException {
        PropertyValue property = properties.getLastWithoutMetadata("citresewn", new String[]{propertyName});
        if (property == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(property.value());
        }
        catch (Exception e) {
            throw new CITParsingException("Could not parse float", properties, property.position(), (Throwable)e);
        }
    }

    public static enum GlintRenderLayer {
        ARMOR_GLINT("armor_glint", 8.0f, layer -> layer.method_34578(RenderPhaseAccessor.ARMOR_GLINT_SHADER()).method_23616(RenderPhaseAccessor.COLOR_MASK()).method_23603(RenderPhaseAccessor.DISABLE_CULLING()).method_23604(RenderPhaseAccessor.EQUAL_DEPTH_TEST()).method_23607(RenderPhaseAccessor.VIEW_OFFSET_Z_LAYERING())),
        ARMOR_ENTITY_GLINT("armor_entity_glint", 0.16f, layer -> layer.method_34578(RenderPhaseAccessor.ARMOR_ENTITY_GLINT_SHADER()).method_23616(RenderPhaseAccessor.COLOR_MASK()).method_23603(RenderPhaseAccessor.DISABLE_CULLING()).method_23604(RenderPhaseAccessor.EQUAL_DEPTH_TEST()).method_23607(RenderPhaseAccessor.VIEW_OFFSET_Z_LAYERING())),
        GLINT_TRANSLUCENT("glint_translucent", 8.0f, layer -> layer.method_34578(RenderPhaseAccessor.TRANSLUCENT_GLINT_SHADER()).method_23616(RenderPhaseAccessor.COLOR_MASK()).method_23603(RenderPhaseAccessor.DISABLE_CULLING()).method_23604(RenderPhaseAccessor.EQUAL_DEPTH_TEST()).method_23610(RenderPhaseAccessor.ITEM_TARGET())),
        GLINT("glint", 8.0f, layer -> layer.method_34578(RenderPhaseAccessor.GLINT_SHADER()).method_23616(RenderPhaseAccessor.COLOR_MASK()).method_23603(RenderPhaseAccessor.DISABLE_CULLING()).method_23604(RenderPhaseAccessor.EQUAL_DEPTH_TEST())),
        DIRECT_GLINT("glint_direct", 8.0f, layer -> layer.method_34578(RenderPhaseAccessor.DIRECT_GLINT_SHADER()).method_23616(RenderPhaseAccessor.COLOR_MASK()).method_23603(RenderPhaseAccessor.DISABLE_CULLING()).method_23604(RenderPhaseAccessor.EQUAL_DEPTH_TEST())),
        ENTITY_GLINT("entity_glint", 0.16f, layer -> layer.method_34578(RenderPhaseAccessor.ENTITY_GLINT_SHADER()).method_23616(RenderPhaseAccessor.COLOR_MASK()).method_23603(RenderPhaseAccessor.DISABLE_CULLING()).method_23604(RenderPhaseAccessor.EQUAL_DEPTH_TEST()).method_23610(RenderPhaseAccessor.ITEM_TARGET())),
        DIRECT_ENTITY_GLINT("entity_glint_direct", 0.16f, layer -> layer.method_34578(RenderPhaseAccessor.DIRECT_ENTITY_GLINT_SHADER()).method_23616(RenderPhaseAccessor.COLOR_MASK()).method_23603(RenderPhaseAccessor.DISABLE_CULLING()).method_23604(RenderPhaseAccessor.EQUAL_DEPTH_TEST()));

        public final String name;
        private final Consumer<class_1921.class_4688.class_4689> setup;
        private final float scale;

        private GlintRenderLayer(String name, float scale, Consumer<class_1921.class_4688.class_4689> setup) {
            this.name = name;
            this.scale = scale;
            this.setup = setup;
        }

        public class_1921 build(TypeEnchantment enchantment, class_2960 propertiesIdentifier) {
            class Texturing
            implements Runnable {
                private final float speed;
                private final float rotation;
                private final float r;
                private final float g;
                private final float b;
                private final float a;
                private final MergeMethodIntensity methodIntensity;

                Texturing(float speed, float rotation, float r, float g, float b, float a, MergeMethodIntensity methodIntensity) {
                    this.speed = speed;
                    this.rotation = rotation;
                    this.r = r;
                    this.g = g;
                    this.b = b;
                    this.a = a;
                    this.methodIntensity = methodIntensity;
                }

                @Override
                public void run() {
                    float l = (float)class_156.method_658() * CITResewnDefaultsConfig.INSTANCE.type_enchantment_scroll_multiplier * this.speed;
                    float x = l % 110000.0f / 110000.0f;
                    float y = l % 30000.0f / 30000.0f;
                    class_1159 matrix4f = class_1159.method_24021((float)(-x), (float)y, (float)0.0f);
                    matrix4f.method_22670(class_1160.field_20707.method_23214(this.rotation));
                    matrix4f.method_22672(class_1159.method_24019((float)GlintRenderLayer.this.scale, (float)GlintRenderLayer.this.scale, (float)GlintRenderLayer.this.scale));
                    RenderSystem.setTextureMatrix((class_1159)matrix4f);
                    RenderSystem.setShaderColor((float)this.r, (float)this.g, (float)this.b, (float)(this.a * this.methodIntensity.intensity));
                }
            }
            class_1921.class_4688.class_4689 layer = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(enchantment.texture, enchantment.blur, false)).method_23614(new class_4668.class_4684("citresewn_glint_texturing", (Runnable)new Texturing(enchantment.speed, enchantment.rotation, enchantment.r, enchantment.g, enchantment.b, enchantment.a, enchantment.methodIntensity), () -> {
                RenderSystem.resetTextureMatrix();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            })).method_23615((class_4668.class_4685)enchantment.blend);
            this.setup.accept(layer);
            return class_1921.method_24048((String)("citresewn:enchantment_" + this.name + ":" + propertiesIdentifier.toString()), (class_293)class_290.field_1585, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (class_1921.class_4688)layer.method_23617(false));
        }

        public class_4588 tryApply(class_4588 base, class_1921 baseLayer, class_4597 provider) {
            if (!TypeEnchantment.CONTAINER.apply || TypeEnchantment.CONTAINER.appliedContext == null || TypeEnchantment.CONTAINER.appliedContext.size() == 0) {
                return null;
            }
            class_4588[] layers = new class_4588[Math.min(TypeEnchantment.CONTAINER.appliedContext.size(), TypeEnchantment.CONTAINER.globalCap)];
            for (int i = 0; i < layers.length; ++i) {
                layers[i] = provider.getBuffer(((TypeEnchantment)TypeEnchantment.CONTAINER.appliedContext.get((int)i).type).renderLayers.get((Object)this));
            }
            provider.getBuffer(baseLayer);
            return base == null ? class_4720.method_35670((class_4588[])layers) : class_4720.method_24037((class_4588)class_4720.method_35670((class_4588[])layers), (class_4588)base);
        }
    }

    public static class MergeMethodIntensity {
        public float intensity = 1.0f;

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum MergeMethod {
            NONE,
            AVERAGE{

                @Override
                public void applyIntensity(Map<class_2960, Integer> stackEnchantments, CIT<TypeEnchantment> cit) {
                    class_2960 enchantment = null;
                    for (class_2960 enchantmentMatch : ((TypeEnchantment)cit.type).enchantmentChecks) {
                        if (!stackEnchantments.containsKey(enchantmentMatch)) continue;
                        enchantment = enchantmentMatch;
                        break;
                    }
                    if (enchantment == null) {
                        ((TypeEnchantment)cit.type).methodIntensity.intensity = 0.0f;
                    } else {
                        float sum = 0.0f;
                        for (Integer value : stackEnchantments.values()) {
                            sum += (float)value.intValue();
                        }
                        ((TypeEnchantment)cit.type).methodIntensity.intensity = (float)stackEnchantments.get(enchantment).intValue() / sum;
                    }
                }
            }
            ,
            LAYERED{

                @Override
                public void applyIntensity(Map<class_2960, Integer> stackEnchantments, CIT<TypeEnchantment> cit) {
                    class_2960 enchantment = null;
                    for (class_2960 enchantmentMatch : ((TypeEnchantment)cit.type).enchantmentChecks) {
                        if (!stackEnchantments.containsKey(enchantmentMatch)) continue;
                        enchantment = enchantmentMatch;
                        break;
                    }
                    if (enchantment == null) {
                        ((TypeEnchantment)cit.type).methodIntensity.intensity = 0.0f;
                        return;
                    }
                    float max = 0.0f;
                    for (Integer value : stackEnchantments.values()) {
                        if (!((float)value.intValue() > max)) continue;
                        max = value.intValue();
                    }
                    ((TypeEnchantment)cit.type).methodIntensity.intensity = (float)stackEnchantments.get(enchantment).intValue() / max;
                }
            }
            ,
            CYCLE{

                @Override
                public void applyMethod(List<CIT<TypeEnchantment>> citEnchantments, CITContext context) {
                    ArrayList durations = new ArrayList();
                    for (CIT<TypeEnchantment> cIT : citEnchantments) {
                        durations.add(new AbstractMap.SimpleEntry<CIT<TypeEnchantment>, Float>(cIT, Float.valueOf(((TypeEnchantment)cIT.type).duration)));
                    }
                    for (Map.Entry entry : Loops.statelessFadingLoop(durations, TypeEnchantment.CONTAINER.globalFade, ticks, 20).entrySet()) {
                        ((TypeEnchantment)((CIT)entry.getKey()).type).methodIntensity.intensity = ((Float)entry.getValue()).floatValue();
                    }
                }
            };

            public static int ticks;

            public void applyIntensity(Map<class_2960, Integer> stackEnchantments, CIT<TypeEnchantment> cit) {
                ((TypeEnchantment)cit.type).methodIntensity.intensity = 1.0f;
            }

            public void applyMethod(List<CIT<TypeEnchantment>> citEnchantments, CITContext context) {
                Map stackEnchantments = context.enchantments();
                for (CIT<TypeEnchantment> cit : citEnchantments) {
                    if (((TypeEnchantment)cit.type).enchantmentChecks == null) continue;
                    this.applyIntensity(stackEnchantments, cit);
                }
            }

            public static MergeMethod parse(String value) {
                return switch (value.toLowerCase(Locale.ROOT)) {
                    case "none" -> NONE;
                    case "average" -> AVERAGE;
                    case "layered" -> LAYERED;
                    case "cycle" -> CYCLE;
                    default -> throw new IllegalArgumentException("Unknown merge method");
                };
            }

            static {
                ticks = 0;
            }
        }
    }

    public static class Blend
    extends class_4668.class_4685 {
        private final int src;
        private final int dst;
        private final int srcAlpha;
        private final int dstAlpha;

        private Blend(String name, int src, int dst, int srcAlpha, int dstAlpha) {
            super(name + "_glint_transparency", null, null);
            this.src = src;
            this.dst = dst;
            this.srcAlpha = srcAlpha;
            this.dstAlpha = dstAlpha;
        }

        private Blend(String name, int src, int dst) {
            this(name, src, dst, 0, 1);
        }

        public void method_23516() {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)this.src, (int)this.dst, (int)this.srcAlpha, (int)this.dstAlpha);
        }

        public void method_23518() {
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
        }

        public static Blend getBlend(String blendString) throws Exception {
            try {
                return Named.valueOf((String)blendString.toUpperCase((Locale)Locale.ENGLISH)).blend;
            }
            catch (IllegalArgumentException ignored) {
                int dstAlpha;
                int srcAlpha;
                int dst;
                int src;
                String[] split = blendString.split("\\p{Zs}+");
                if (split.length == 2) {
                    src = Blend.parseGLConstant(split[0]);
                    dst = Blend.parseGLConstant(split[1]);
                    srcAlpha = 0;
                    dstAlpha = 1;
                } else if (split.length == 4) {
                    src = Blend.parseGLConstant(split[0]);
                    dst = Blend.parseGLConstant(split[1]);
                    srcAlpha = Blend.parseGLConstant(split[2]);
                    dstAlpha = Blend.parseGLConstant(split[3]);
                } else {
                    throw new Exception();
                }
                return new Blend("custom_" + src + "_" + dst + "_" + srcAlpha + "_" + dstAlpha, src, dst, srcAlpha, dstAlpha);
            }
        }

        private static int parseGLConstant(String s) throws Exception {
            try {
                return GL11.class.getDeclaredField(s).getInt(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return s.startsWith("0x") ? Integer.parseInt(s.substring(2), 16) : Integer.parseInt(s);
            }
        }

        private static enum Named {
            REPLACE(new Blend("replace", 0, 0){

                @Override
                public void method_23516() {
                    RenderSystem.disableBlend();
                }
            }),
            GLINT(new Blend("glint", 768, 1)),
            ALPHA(new Blend("alpha", 770, 771)),
            ADD(new Blend("add", 770, 1)),
            SUBTRACT(new Blend("subtract", 775, 0)),
            MULTIPLY(new Blend("multiply", 774, 771)),
            DODGE(new Blend("dodge", 1, 1)),
            BURN(new Blend("burn", 0, 769)),
            SCREEN(new Blend("screen", 1, 769)),
            OVERLAY(new Blend("overlay", 774, 768));

            public final Blend blend;

            private Named(Blend blend) {
                this.blend = blend;
            }
        }
    }

    public static class Container
    extends CITTypeContainer<TypeEnchantment>
    implements CITGlobalProperties {
        public boolean globalUseGlint = true;
        public int globalCap = Integer.MAX_VALUE;
        public MergeMethodIntensity.MergeMethod globalMergeMethod = MergeMethodIntensity.MergeMethod.AVERAGE;
        public float globalFade = 0.5f;
        public List<CIT<TypeEnchantment>> loaded = new ArrayList<CIT<TypeEnchantment>>();
        public List<List<CIT<TypeEnchantment>>> loadedLayered = new ArrayList<List<CIT<TypeEnchantment>>>();
        private List<CIT<TypeEnchantment>> appliedContext = null;
        private boolean apply = false;
        private boolean defaultGlint = false;

        public Container() {
            super(TypeEnchantment.class, TypeEnchantment::new, "enchantment");
        }

        public void load(List<CIT<TypeEnchantment>> parsedCITs) {
            this.loaded.addAll(parsedCITs);
            HashMap<Integer, List> layers = new HashMap<Integer, List>();
            for (CIT<TypeEnchantment> cit : this.loaded) {
                layers.computeIfAbsent(((TypeEnchantment)cit.type).layer, i -> new ArrayList()).add(cit);
            }
            this.loadedLayered.clear();
            layers.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(layer -> this.loadedLayered.add((List)layer.getValue()));
            for (CIT<TypeEnchantment> cit : this.loaded) {
                for (GlintRenderLayer glintLayer : GlintRenderLayer.values()) {
                    class_1921 renderLayer = glintLayer.build((TypeEnchantment)cit.type, cit.propertiesIdentifier);
                    ((TypeEnchantment)cit.type).renderLayers.put(glintLayer, renderLayer);
                    ((BufferBuilderStorageAccessor)class_310.method_1551().method_22940()).getEntityBuilders().put(renderLayer, new class_287(renderLayer.method_22722()));
                }
            }
        }

        public void globalProperty(String key, @Nullable PropertyValue value) throws Exception {
            switch (key) {
                case "useGlint": {
                    boolean bl = this.globalUseGlint = value == null ? true : Boolean.parseBoolean(value.value());
                    if (this.globalUseGlint || "false".equalsIgnoreCase(value.value())) break;
                    throw new Exception("Could not parse boolean");
                }
                case "cap": {
                    this.globalCap = value == null ? Integer.MAX_VALUE : Integer.parseInt(value.value());
                    break;
                }
                case "method": {
                    this.globalMergeMethod = value == null ? MergeMethodIntensity.MergeMethod.AVERAGE : MergeMethodIntensity.MergeMethod.parse(value.value());
                    break;
                }
                case "fade": {
                    this.globalFade = value == null ? 0.5f : Float.parseFloat(value.value());
                }
            }
        }

        public void dispose() {
            this.appliedContext = null;
            this.apply = false;
            for (CIT<TypeEnchantment> cit : this.loaded) {
                for (class_1921 renderLayer : ((TypeEnchantment)cit.type).renderLayers.values()) {
                    ((BufferBuilderStorageAccessor)class_310.method_1551().method_22940()).getEntityBuilders().remove(renderLayer);
                }
            }
            this.loaded.clear();
            this.loadedLayered.clear();
        }

        public void apply() {
            if (this.appliedContext != null) {
                this.apply = true;
            }
        }

        public boolean shouldApply() {
            return this.apply && this.active();
        }

        public boolean shouldNotApplyDefaultGlint() {
            return !this.globalUseGlint || this.apply && !this.defaultGlint;
        }

        public Container setContext(CITContext context) {
            this.apply = false;
            this.defaultGlint = false;
            this.appliedContext = null;
            if (context == null) {
                return this;
            }
            List cits = ((CITCacheEnchantment)context.stack).citresewn$getCacheTypeEnchantment().get(context);
            this.appliedContext = new ArrayList<CIT<TypeEnchantment>>();
            if (cits != null) {
                for (WeakReference citRef : cits) {
                    CIT cit;
                    if (citRef == null || (cit = (CIT)citRef.get()) == null) continue;
                    this.appliedContext.add((CIT<TypeEnchantment>)cit);
                    if (!((TypeEnchantment)cit.type).useGlint) continue;
                    this.defaultGlint = true;
                }
            }
            if (this.appliedContext.isEmpty()) {
                this.appliedContext = null;
            } else {
                this.globalMergeMethod.applyMethod(this.appliedContext, context);
            }
            return this;
        }

        public List<CIT<TypeEnchantment>> getRealTimeCIT(CITContext context) {
            ArrayList<CIT<TypeEnchantment>> cits = new ArrayList<CIT<TypeEnchantment>>();
            block0: for (List<CIT<TypeEnchantment>> layer : this.loadedLayered) {
                for (CIT<TypeEnchantment> cit : layer) {
                    if (!cit.test(context)) continue;
                    cits.add(cit);
                    continue block0;
                }
            }
            return cits;
        }
    }

    public static interface CITCacheEnchantment {
        public CITCache.MultiList<TypeEnchantment> citresewn$getCacheTypeEnchantment();
    }
}

