/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.registry;

import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.registry.IRegistryEntries;
import net.darkhax.bookshelf.api.registry.RegistryDataProvider;
import net.darkhax.bookshelf.impl.registry.GameRegistriesVanilla;
import net.darkhax.bookshelf.impl.resources.WrappedReloadListener;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2168;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3852;
import net.minecraft.class_3853;

public class GameRegistriesFabric
extends GameRegistriesVanilla {
    @Override
    public void loadContent(RegistryDataProvider content) {
        this.consumeVanillaRegistry((IRegistryEntries)content.blocks, (class_2378)class_2378.field_11146);
        this.consumeVanillaRegistry((IRegistryEntries)content.fluids, (class_2378)class_2378.field_11154);
        this.consumeVanillaRegistry((IRegistryEntries)content.items, (class_2378)class_2378.field_11142);
        this.consumeVanillaRegistry(content.bannerPatterns, class_2378.field_39208);
        this.consumeVanillaRegistry(content.mobEffects, class_2378.field_11159);
        this.consumeVanillaRegistry(content.sounds, class_2378.field_11156);
        this.consumeVanillaRegistry((IRegistryEntries)content.potions, (class_2378)class_2378.field_11143);
        this.consumeVanillaRegistry(content.enchantments, class_2378.field_11160);
        this.consumeVanillaRegistry((IRegistryEntries)content.entities, (class_2378)class_2378.field_11145);
        this.consumeVanillaRegistry(content.blockEntities, class_2378.field_11137);
        this.consumeVanillaRegistry(content.particleTypes, class_2378.field_11141);
        this.consumeVanillaRegistry(content.menus, class_2378.field_17429);
        this.consumeVanillaRegistry(content.recipeSerializers, class_2378.field_17598);
        this.consumeVanillaRegistry((IRegistryEntries)content.paintings, (class_2378)class_2378.field_11150);
        this.consumeVanillaRegistry(content.attributes, class_2378.field_23781);
        this.consumeVanillaRegistry(content.stats, class_2378.field_11152);
        this.consumeVanillaRegistry((IRegistryEntries)content.villagerProfessions, (class_2378)class_2378.field_17167);
        this.consumeVanillaRegistry(content.menuTypes, class_2378.field_17429);
        this.consumeRegistry(content.commandArguments, (id, value) -> ArgumentTypeRegistry.registerArgumentType((class_2960)id, value.getType(), (class_2314)((class_2314)value.getSerializer().get())));
        this.consumeVanillaRegistry(content.recipeTypes, class_2378.field_17597);
        CommandRegistrationCallback.EVENT.register((dispatcher, access, environment) -> content.commands.build((id, value) -> value.build((CommandDispatcher<class_2168>)dispatcher, access, environment)));
        this.registerTradeData(content.trades.getVillagerTrades());
        this.registerWanderingTrades(content.trades.getCommonWanderingTrades(), content.trades.getRareWanderingTrades());
        this.consumeRegistry(content.dataListeners, (id, value) -> ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new WrappedReloadListener((class_2960)id, (class_3302)value)));
        if (Services.PLATFORM.isPhysicalClient()) {
            this.loadClient(content);
        }
    }

    private void loadClient(RegistryDataProvider content) {
        this.consumeRegistry(content.resourceListeners, (id, value) -> ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new WrappedReloadListener((class_2960)id, (class_3302)value)));
    }

    private <T, O> void consumeVanillaRegistry(IRegistryEntries<O> toRegister, class_2378<T> registry, Function<O, T> wrapper) {
        toRegister.build((id, value) -> class_2378.method_10230((class_2378)registry, (class_2960)id, wrapper.apply(value)));
    }

    private <T> void consumeVanillaRegistry(IRegistryEntries<T> toRegister, class_2378<T> registry) {
        toRegister.build((id, value) -> class_2378.method_10230((class_2378)registry, (class_2960)id, (Object)value));
    }

    private <T> void consumeRegistry(IRegistryEntries<T> toRegister, BiConsumer<class_2960, T> func) {
        toRegister.build(func);
    }

    private void registerTradeData(Map<class_3852, Multimap<Integer, class_3853.class_1652>> villagerTrades) {
        for (Map.Entry<class_3852, Multimap<Integer, class_3853.class_1652>> professionData : villagerTrades.entrySet()) {
            Int2ObjectMap professionTrades = class_3853.field_17067.computeIfAbsent(professionData.getKey(), profession -> new Int2ObjectOpenHashMap());
            Iterator iterator = professionData.getValue().keySet().iterator();
            while (iterator.hasNext()) {
                int merchantTier = (Integer)iterator.next();
                ArrayList<class_3853.class_1652> tradesForTier = new ArrayList<class_3853.class_1652>(Arrays.asList((class_3853.class_1652[])professionTrades.getOrDefault(merchantTier, (Object)new class_3853.class_1652[0])));
                tradesForTier.addAll(professionData.getValue().get((Object)merchantTier));
                professionTrades.put(merchantTier, (Object)tradesForTier.toArray(new class_3853.class_1652[0]));
            }
        }
    }

    private void registerWanderingTrades(List<class_3853.class_1652> commonTrades, List<class_3853.class_1652> rareTrades) {
        ArrayList<class_3853.class_1652> tradeData;
        if (!commonTrades.isEmpty()) {
            tradeData = new ArrayList<class_3853.class_1652>(Arrays.asList((class_3853.class_1652[])class_3853.field_17724.get(1)));
            tradeData.addAll(commonTrades);
            class_3853.field_17724.put(1, (Object)tradeData.toArray(new class_3853.class_1652[0]));
        }
        if (!rareTrades.isEmpty()) {
            tradeData = new ArrayList<class_3853.class_1652>(Arrays.asList((class_3853.class_1652[])class_3853.field_17724.get(2)));
            tradeData.addAll(rareTrades);
            class_3853.field_17724.put(2, (Object)tradeData.toArray(new class_3853.class_1652[0]));
        }
    }
}

