/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest;

import com.google.common.base.CaseFormat;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.data.sound.Sound;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.bookshelf.api.util.ItemStackHelper;
import net.darkhax.bookshelf.impl.gametest.ITestable;
import net.darkhax.bookshelf.impl.gametest.TestSerialization;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1535;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2440;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3483;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3917;
import net.minecraft.class_4525;
import net.minecraft.class_4529;
import net.minecraft.class_5134;
import net.minecraft.class_5698;
import net.minecraft.class_5712;
import net.minecraft.class_6302;
import net.minecraft.class_6303;
import net.minecraft.class_6862;
import net.minecraft.class_7406;
import net.minecraft.class_7408;
import net.minecraft.class_7440;

public class BookshelfGameTests {
    @class_6303
    public static Collection<class_4529> generate() {
        ArrayList<class_4529> testFunctions = new ArrayList<class_4529>();
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Boolean>("boolean", Serializers.BOOLEAN, false, true, true, false));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Byte>("byte", Serializers.BYTE, (byte)1, (byte)32, (byte)44, (byte)0));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Short>("short", Serializers.SHORT, (short)800, (short)1337));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Integer>("int", Serializers.INT, 54, 23, Integer.MAX_VALUE, 234234, Integer.MIN_VALUE));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Long>("long", Serializers.LONG, 99L, 23441322L, Long.MIN_VALUE, 93015L, Long.MAX_VALUE));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Float>("float", Serializers.FLOAT, Float.valueOf(8.0f), Float.valueOf(-23.456f), Float.valueOf(789.01f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(-11.0f), Float.valueOf(Float.MIN_VALUE)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Double>("double", Serializers.DOUBLE, 24.92, Double.MAX_VALUE, -922321.12345, Double.MIN_VALUE));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<String>("string", Serializers.STRING, "one", "two", "3", "IV", ".....", "/I", "!@#$%^&*()_-"));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<UUID>("uuid", Serializers.UUID, UUID.randomUUID(), UUID.fromString("da0317d2-e550-11ec-8fea-0242ac120002"), UUID.randomUUID()));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_2960>("resource_location", Serializers.RESOURCE_LOCATION, new class_2960("hello_world"), new class_2960("test", "two"), new class_2960("test_from", "stuff/things/okay_stuff")));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1799>("item_stack", Serializers.ITEM_STACK, ItemStackHelper::areStacksEquivalent, (T[])ItemStackHelper.getTabItems(class_1761.field_7916)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_2487>("nbt_compound_tag", Serializers.COMPOUND_TAG, (class_2487[])Arrays.stream(ItemStackHelper.getTabItems(class_1761.field_7916)).filter(class_1799::method_7985).map(class_1799::method_7969).toArray(class_2487[]::new)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_2561>("text_component", Serializers.TEXT, class_2561.method_43471((String)"moon.phase.full").method_27692(class_124.field_1062), class_2561.method_43470((String)"Hello World"), class_2561.method_43470((String)"okay").method_27694(s -> s.method_27704(new class_2960("minecraft:alt")))));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_2338>("block_pos", Serializers.BLOCK_POS, new class_2338(1, 2, 3), new class_2338(0, 0, 0), class_2338.method_10092((long)123456L)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1856>("ingredient", Serializers.INGREDIENT, BookshelfGameTests::assertEqual, (T[])new class_1856[]{class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8062}), class_1856.field_9017, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8713}), class_1856.method_8101((class_1799[])new class_1799[]{new class_1799((class_1935)class_1802.field_8094)}), class_1856.method_8106((class_6862)class_3489.field_16444)}));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_2680>("block_state", Serializers.BLOCK_STATE, class_2246.field_10340.method_9564(), class_2246.field_10034.method_9564(), (class_2680)class_2246.field_10397.method_9564().method_11657((class_2769)class_2440.field_11358, (Comparable)Boolean.valueOf(true))));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1322>("attribute_modifier", Serializers.ATTRIBUTE_MODIFIER, new class_1322("test", 15.0, class_1322.class_1323.field_6330), new class_1322(UUID.randomUUID(), "test_2", 9.55, class_1322.class_1323.field_6328), new class_1322("test3", 35.0, class_1322.class_1323.field_6331)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1293>("effect_instance", Serializers.EFFECT_INSTANCE, new class_1293(class_1294.field_5898, 100, 10), new class_1293(class_1294.field_16595, 10)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1889>("enchantment_instance", Serializers.ENCHANTMENT_INSTANCE, BookshelfGameTests::assertEncantmentInstanceEqual, (T[])new class_1889[]{new class_1889(class_1893.field_9111, 5), new class_1889(class_1893.field_9113, 15), new class_1889(class_1893.field_9106, 2)}));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1160>("Vector3f", Serializers.VECTOR_3F, new class_1160(1.0f, 2.0f, 3.0f), new class_1160(-5.0f, -2.0f, 44.0f), new class_1160(Float.MAX_VALUE, Float.MIN_VALUE, Float.MIN_VALUE)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1162>("Vector4f", Serializers.VECTOR_4F, new class_1162(1.0f, 2.0f, 3.0f, 4.0f), new class_1162(0.0f, -22.0f, -2222.0f, 0.0f), new class_1162(Float.MAX_VALUE, Float.MIN_VALUE, Float.MIN_VALUE, Float.MAX_VALUE)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Sound>("sound", Serializers.SOUND, new Sound(class_3417.field_14707, class_3419.field_15256, 1.0f, 1.0f), new Sound(class_3417.field_14564, class_3419.field_15254, 0.5f, 0.222f), new Sound(class_3417.field_15034, class_3419.field_15248, 0.1f, 0.2f)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1814>("item_rarity", Serializers.ITEM_RARITY, class_1814.field_8906, class_1814.field_8904, class_1814.field_8903, class_1814.field_8903));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1887.class_1888>("enchantment_rarity", Serializers.ENCHANTMENT_RARITY, class_1887.class_1888.field_9087, class_1887.class_1888.field_9087, class_1887.class_1888.field_9088, class_1887.class_1888.field_9090));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1322.class_1323>("attribute_modifier", Serializers.ATTRIBUTE_OPERATION, class_1322.class_1323.field_6328, class_1322.class_1323.field_6328, class_1322.class_1323.field_6330, class_1322.class_1323.field_6331, class_1322.class_1323.field_6331));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_2350>("direction", Serializers.DIRECTION, class_2350.field_11036, class_2350.field_11036, class_2350.field_11033, class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11035));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_2350.class_2351>("axis", Serializers.AXIS, class_2350.class_2351.field_11048, class_2350.class_2351.field_11048, class_2350.class_2351.field_11052, class_2350.class_2351.field_11051, class_2350.class_2351.field_11052));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_2350.class_2353>("plane", Serializers.PLANE, class_2350.class_2353.field_11062, class_2350.class_2353.field_11064, class_2350.class_2353.field_11064, class_2350.class_2353.field_11064, class_2350.class_2353.field_11062));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1311>("mob_category", Serializers.MOB_CATEGORY, class_1311.field_6303, class_1311.field_34447, class_1311.field_6294, class_1311.field_34447, class_1311.field_6302, class_1311.field_17715));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1886>("enchantment_category", Serializers.ENCHANTMENT_CATEGORY, class_1886.field_9068, class_1886.field_9082, class_1886.field_9082));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1767>("dye_color", Serializers.DYE_COLOR, class_1767.field_7963, class_1767.field_7964, class_1767.field_7966));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_3419>("sound_category", Serializers.SOUND_CATEGORY, class_3419.field_15256, class_3419.field_15251, class_3419.field_15248));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_2248>("registry_block", Serializers.BLOCK, class_2246.field_10102, class_2246.field_10340, class_2246.field_9993, class_2246.field_10102));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1792>("registry_item", Serializers.ITEM, class_1802.field_8279, class_1802.field_8600, class_1802.field_8600, class_1802.field_8261));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1887>("registry_enchantment", Serializers.ENCHANTMENT, class_1893.field_9111, class_1893.field_9107, class_1893.field_9107, class_1893.field_9099));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1535>("registry_painting", Serializers.PAINTING, Services.REGISTRIES.paintings().get(class_7408.field_38955.method_29177()), Services.REGISTRIES.paintings().get(class_7408.field_38948.method_29177())));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1842>("registry_potion", Serializers.POTION, class_1847.field_8984, class_1847.field_8999, class_1847.field_8999, class_1847.field_8987, class_1847.field_8963));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1320>("registry_attribute", Serializers.ATTRIBUTE, class_5134.field_23724, class_5134.field_23723, class_5134.field_23716, class_5134.field_23727));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_3852>("registry_villager_profession", Serializers.VILLAGER_PROFESSION, class_3852.field_17052, class_3852.field_17052, class_3852.field_17053, class_3852.field_17059, class_3852.field_17065));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_3854>("registry_villager_type", Serializers.VILLAGER_TYPE, class_3854.field_17076, class_3854.field_17072, class_3854.field_17072, class_3854.field_17073));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_3414>("registry_sound_event", Serializers.SOUND_EVENT, class_3417.field_14695, class_3417.field_14635, class_3417.field_14675, class_3417.field_14707));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_3917>("registry_menu", Serializers.MENU, class_3917.field_17329, class_3917.field_18665, class_3917.field_17334, class_3917.field_17343));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_2396>("registry_particle_type", Serializers.PARTICLE, class_2398.field_11241, class_2398.field_11238, class_2398.field_11204, class_2398.field_17431, class_2398.field_22446));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_1299>("registry_entity_type", Serializers.ENTITY, class_1299.field_6108, class_1299.field_6122, class_1299.field_28315, class_1299.field_6129));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_2591>("registry_block_entity_type", Serializers.BLOCK_ENTITY, class_2591.field_16411, class_2591.field_11890, class_2591.field_20431, class_2591.field_11907));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<class_5712>("registry_game_event", Serializers.GAME_EVENT, class_5712.field_28157, class_5712.field_28167, class_5712.field_28727, class_5712.field_28152));
        class_2960 tagOne = new class_2960("test", "one");
        class_2960 tagTwo = new class_2960("test", "two");
        BookshelfGameTests.testFromTags(testFunctions, "block_tag", Serializers.BLOCK_TAG, class_3481.field_15486, class_3481.field_16443, class_3481.field_25807);
        BookshelfGameTests.testFromTags(testFunctions, "item_tag", Serializers.ITEM_TAG, class_3489.field_15547, class_3489.field_28299, class_3489.field_15554);
        BookshelfGameTests.testFromTags(testFunctions, "banner_pattern_tag", Serializers.BANNER_PATTERN_TAG, class_7440.field_39097, class_7440.field_39102, class_7440.field_39099);
        BookshelfGameTests.testFromTags(testFunctions, "enchantment_tag", Serializers.ENCHANTMENT_TAG, Services.TAGS.enchantmentTag(tagOne), Services.TAGS.enchantmentTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "painting_tag", Serializers.MOTIVE_TAG, class_7406.field_38929, class_7406.field_38929);
        BookshelfGameTests.testFromTags(testFunctions, "mob_effect_tag", Serializers.MOB_EFFECT_TAG, Services.TAGS.effectTag(tagOne), Services.TAGS.effectTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "potion_tag", Serializers.POTION_TAG, Services.TAGS.potionTag(tagOne), Services.TAGS.potionTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "attribute_tag", Serializers.ATTRIBUTE_TAG, Services.TAGS.attributeTag(tagOne), Services.TAGS.attributeTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "villager_profession_tag", Serializers.VILLAGER_PROFESSION_TAG, Services.TAGS.villagerProfessionTag(tagOne), Services.TAGS.villagerProfessionTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "villager_type_tag", Serializers.VILLAGER_TYPE_TAG, Services.TAGS.villagerTypeTag(tagOne), Services.TAGS.villagerTypeTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "sound_event_tag", Serializers.SOUND_EVENT_TAG, Services.TAGS.soundTag(tagOne), Services.TAGS.soundTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "menu_tag", Serializers.MENU_TAG, Services.TAGS.menuTag(tagOne), Services.TAGS.menuTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "particle_type_tag", Serializers.PARTICLE_TAG, Services.TAGS.particleTag(tagOne), Services.TAGS.particleTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "entity_type_tag", Serializers.ENTITY_TAG, class_3483.field_21508, class_3483.field_28296, class_3483.field_27855);
        BookshelfGameTests.testFromTags(testFunctions, "block_entity_type_tag", Serializers.BLOCK_ENTITY_TAG, Services.TAGS.blockEntityTag(tagOne), Services.TAGS.blockEntityTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "game_event_tag", Serializers.GAME_EVENT_TAG, class_5698.field_28091, class_5698.field_28090, class_5698.field_28090);
        BookshelfGameTests.testFromTags(testFunctions, "fluid_tag", Serializers.FLUID_TAG, class_3486.field_15518, class_3486.field_15517);
        BookshelfGameTests.testFromTags(testFunctions, "stat_tag", Serializers.STAT_TAG, Services.TAGS.statTag(tagOne), Services.TAGS.statTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "recipe_type_tag", Serializers.RECIPE_TYPE_TAG, Services.TAGS.recipeTypeTag(tagOne), Services.TAGS.recipeTypeTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "recipe_serializer_tag", Serializers.RECIPE_SERIALIZER_TAG, Services.TAGS.recipeSerializerTag(tagOne), Services.TAGS.recipeSerializerTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "dimension_type_tag", Serializers.DIMENSION_TYPE_TAG, Services.TAGS.dimensionTypeTag(tagOne), Services.TAGS.dimensionTypeTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "dimension_tag", Serializers.DIMENSION_TAG, Services.TAGS.dimensionTag(tagOne), Services.TAGS.dimensionTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "biome_tag", Serializers.BIOME_TAG, Services.TAGS.biomeTag(tagOne), Services.TAGS.biomeTag(tagTwo));
        return testFunctions;
    }

    public static <T> void testFrom(Collection<class_4529> functions, T testImpl) {
        String string;
        if (testImpl instanceof ITestable) {
            ITestable testObj = (ITestable)testImpl;
            string = testObj.getDefaultBatch();
        } else {
            string = null;
        }
        String parentBatch = string;
        for (Method method : testImpl.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(class_6302.class)) continue;
            class_6302 annotation = method.getAnnotation(class_6302.class);
            String template = annotation.method_35936().isEmpty() ? "bookshelf:empty" : annotation.method_35936();
            String batch = parentBatch != null && annotation.method_35933().equalsIgnoreCase("defaultBatch") ? parentBatch : annotation.method_35933();
            String testName = batch + "." + CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, method.getName());
            class_2470 rotation = class_4525.method_29408((int)annotation.method_35934());
            functions.add(new class_4529(batch, testName, template, rotation, annotation.method_35932(), annotation.method_35937(), annotation.method_35935(), annotation.method_35939(), annotation.method_35938(), gameTestHelper -> {
                try {
                    method.invoke(testImpl, gameTestHelper);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to invoke test method (%s) in (%s) because %s".formatted(method.getName(), method.getDeclaringClass().getCanonicalName(), e.getMessage()), e);
                }
                catch (InvocationTargetException e) {
                    RuntimeException runtimeException;
                    Throwable throwable = e.getCause();
                    RuntimeException rte = throwable instanceof RuntimeException ? (runtimeException = (RuntimeException)throwable) : new RuntimeException(e.getCause());
                    Constants.LOG.error("The test {} failed to run!", (Object)testName, (Object)e);
                    throw rte;
                }
            }));
        }
    }

    private static <T> void testFromTags(Collection<class_4529> functions, String name, ISerializer<class_6862<T>> serializer, class_6862<T> ... tags) {
        BookshelfGameTests.testFrom(functions, new TestSerialization<class_6862<T>>(name, serializer, BookshelfGameTests::assertTagEqual, (T[])tags));
    }

    private static boolean assertEncantmentInstanceEqual(class_1889 a, class_1889 b) {
        if (Objects.equals(a, b)) {
            return true;
        }
        if (a.field_9093 != b.field_9093) {
            Constants.LOG.error("Enchantment {} != {}", (Object)a.field_9093, (Object)b.field_9093);
            return false;
        }
        if (a.field_9094 != b.field_9094) {
            Constants.LOG.error("Level {} != {}", (Object)a.field_9094, (Object)b.field_9094);
            return false;
        }
        return true;
    }

    private static <T> boolean assertTagEqual(class_6862<T> a, class_6862<T> b) {
        return Objects.equals(a, b) || Objects.equals(a.comp_327(), b.comp_327());
    }

    private static boolean assertEqual(class_1856 original, class_1856 result) {
        class_1799[] resultStacks;
        if (Objects.equals(original, result)) {
            return true;
        }
        class_1799[] originalStacks = original.method_8105();
        if (originalStacks.length != (resultStacks = result.method_8105()).length) {
            Constants.LOG.error("Size mismatch. original={} result={}", (Object)originalStacks.length, (Object)resultStacks.length);
            return false;
        }
        for (int index = 0; index < originalStacks.length; ++index) {
            if (ItemStackHelper.areStacksEquivalent(originalStacks[index], resultStacks[index])) continue;
            Constants.LOG.error("Mismatch at index {}. original={} result={}", new Object[]{index, originalStacks[index], resultStacks[index]});
            return false;
        }
        return true;
    }
}

