/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vendored.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.coderbot.iris.vendored.joml.AxisAngle4d;
import net.coderbot.iris.vendored.joml.AxisAngle4f;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.Matrix2dc;
import net.coderbot.iris.vendored.joml.Matrix2fc;
import net.coderbot.iris.vendored.joml.Matrix3dc;
import net.coderbot.iris.vendored.joml.Matrix3fc;
import net.coderbot.iris.vendored.joml.Matrix4dc;
import net.coderbot.iris.vendored.joml.Matrix4fc;
import net.coderbot.iris.vendored.joml.Matrix4x3dc;
import net.coderbot.iris.vendored.joml.MemUtil;
import net.coderbot.iris.vendored.joml.Quaterniond;
import net.coderbot.iris.vendored.joml.Quaterniondc;
import net.coderbot.iris.vendored.joml.Quaternionf;
import net.coderbot.iris.vendored.joml.Quaternionfc;
import net.coderbot.iris.vendored.joml.Runtime;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector3dc;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vendored.joml.Vector3fc;

public class Matrix3d
implements Externalizable,
Cloneable,
Matrix3dc {
    private static final long serialVersionUID = 1L;
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;

    public Matrix3d() {
        this.m00 = 1.0;
        this.m11 = 1.0;
        this.m22 = 1.0;
    }

    public Matrix3d(Matrix2dc matrix2dc) {
        this.set(matrix2dc);
    }

    public Matrix3d(Matrix2fc matrix2fc) {
        this.set(matrix2fc);
    }

    public Matrix3d(Matrix3dc matrix3dc) {
        this.set(matrix3dc);
    }

    public Matrix3d(Matrix3fc matrix3fc) {
        this.set(matrix3fc);
    }

    public Matrix3d(Matrix4fc matrix4fc) {
        this.set(matrix4fc);
    }

    public Matrix3d(Matrix4dc matrix4dc) {
        this.set(matrix4dc);
    }

    public Matrix3d(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        this.m20 = d7;
        this.m21 = d8;
        this.m22 = d9;
    }

    public Matrix3d(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
    }

    public Matrix3d(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        this.set(vector3dc, vector3dc2, vector3dc3);
    }

    @Override
    public double m00() {
        return this.m00;
    }

    @Override
    public double m01() {
        return this.m01;
    }

    @Override
    public double m02() {
        return this.m02;
    }

    @Override
    public double m10() {
        return this.m10;
    }

    @Override
    public double m11() {
        return this.m11;
    }

    @Override
    public double m12() {
        return this.m12;
    }

    @Override
    public double m20() {
        return this.m20;
    }

    @Override
    public double m21() {
        return this.m21;
    }

    @Override
    public double m22() {
        return this.m22;
    }

    public Matrix3d m00(double d) {
        this.m00 = d;
        return this;
    }

    public Matrix3d m01(double d) {
        this.m01 = d;
        return this;
    }

    public Matrix3d m02(double d) {
        this.m02 = d;
        return this;
    }

    public Matrix3d m10(double d) {
        this.m10 = d;
        return this;
    }

    public Matrix3d m11(double d) {
        this.m11 = d;
        return this;
    }

    public Matrix3d m12(double d) {
        this.m12 = d;
        return this;
    }

    public Matrix3d m20(double d) {
        this.m20 = d;
        return this;
    }

    public Matrix3d m21(double d) {
        this.m21 = d;
        return this;
    }

    public Matrix3d m22(double d) {
        this.m22 = d;
        return this;
    }

    Matrix3d _m00(double d) {
        this.m00 = d;
        return this;
    }

    Matrix3d _m01(double d) {
        this.m01 = d;
        return this;
    }

    Matrix3d _m02(double d) {
        this.m02 = d;
        return this;
    }

    Matrix3d _m10(double d) {
        this.m10 = d;
        return this;
    }

    Matrix3d _m11(double d) {
        this.m11 = d;
        return this;
    }

    Matrix3d _m12(double d) {
        this.m12 = d;
        return this;
    }

    Matrix3d _m20(double d) {
        this.m20 = d;
        return this;
    }

    Matrix3d _m21(double d) {
        this.m21 = d;
        return this;
    }

    Matrix3d _m22(double d) {
        this.m22 = d;
        return this;
    }

    public Matrix3d set(Matrix3dc matrix3dc) {
        this.m00 = matrix3dc.m00();
        this.m01 = matrix3dc.m01();
        this.m02 = matrix3dc.m02();
        this.m10 = matrix3dc.m10();
        this.m11 = matrix3dc.m11();
        this.m12 = matrix3dc.m12();
        this.m20 = matrix3dc.m20();
        this.m21 = matrix3dc.m21();
        this.m22 = matrix3dc.m22();
        return this;
    }

    public Matrix3d setTransposed(Matrix3dc matrix3dc) {
        double d = matrix3dc.m01();
        double d2 = matrix3dc.m21();
        double d3 = matrix3dc.m02();
        double d4 = matrix3dc.m12();
        return this._m00(matrix3dc.m00())._m01(matrix3dc.m10())._m02(matrix3dc.m20())._m10(d)._m11(matrix3dc.m11())._m12(d2)._m20(d3)._m21(d4)._m22(matrix3dc.m22());
    }

    public Matrix3d set(Matrix3fc matrix3fc) {
        this.m00 = matrix3fc.m00();
        this.m01 = matrix3fc.m01();
        this.m02 = matrix3fc.m02();
        this.m10 = matrix3fc.m10();
        this.m11 = matrix3fc.m11();
        this.m12 = matrix3fc.m12();
        this.m20 = matrix3fc.m20();
        this.m21 = matrix3fc.m21();
        this.m22 = matrix3fc.m22();
        return this;
    }

    public Matrix3d setTransposed(Matrix3fc matrix3fc) {
        float f = matrix3fc.m01();
        float f2 = matrix3fc.m21();
        float f3 = matrix3fc.m02();
        float f4 = matrix3fc.m12();
        return this._m00(matrix3fc.m00())._m01(matrix3fc.m10())._m02(matrix3fc.m20())._m10(f)._m11(matrix3fc.m11())._m12(f2)._m20(f3)._m21(f4)._m22(matrix3fc.m22());
    }

    public Matrix3d set(Matrix4x3dc matrix4x3dc) {
        this.m00 = matrix4x3dc.m00();
        this.m01 = matrix4x3dc.m01();
        this.m02 = matrix4x3dc.m02();
        this.m10 = matrix4x3dc.m10();
        this.m11 = matrix4x3dc.m11();
        this.m12 = matrix4x3dc.m12();
        this.m20 = matrix4x3dc.m20();
        this.m21 = matrix4x3dc.m21();
        this.m22 = matrix4x3dc.m22();
        return this;
    }

    public Matrix3d set(Matrix4fc matrix4fc) {
        this.m00 = matrix4fc.m00();
        this.m01 = matrix4fc.m01();
        this.m02 = matrix4fc.m02();
        this.m10 = matrix4fc.m10();
        this.m11 = matrix4fc.m11();
        this.m12 = matrix4fc.m12();
        this.m20 = matrix4fc.m20();
        this.m21 = matrix4fc.m21();
        this.m22 = matrix4fc.m22();
        return this;
    }

    public Matrix3d set(Matrix4dc matrix4dc) {
        this.m00 = matrix4dc.m00();
        this.m01 = matrix4dc.m01();
        this.m02 = matrix4dc.m02();
        this.m10 = matrix4dc.m10();
        this.m11 = matrix4dc.m11();
        this.m12 = matrix4dc.m12();
        this.m20 = matrix4dc.m20();
        this.m21 = matrix4dc.m21();
        this.m22 = matrix4dc.m22();
        return this;
    }

    public Matrix3d set(Matrix2fc matrix2fc) {
        this.m00 = matrix2fc.m00();
        this.m01 = matrix2fc.m01();
        this.m02 = 0.0;
        this.m10 = matrix2fc.m10();
        this.m11 = matrix2fc.m11();
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        return this;
    }

    public Matrix3d set(Matrix2dc matrix2dc) {
        this.m00 = matrix2dc.m00();
        this.m01 = matrix2dc.m01();
        this.m02 = 0.0;
        this.m10 = matrix2dc.m10();
        this.m11 = matrix2dc.m11();
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        return this;
    }

    public Matrix3d set(AxisAngle4f axisAngle4f) {
        double d = axisAngle4f.x;
        double d2 = axisAngle4f.y;
        double d3 = axisAngle4f.z;
        double d4 = axisAngle4f.angle;
        double d5 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        d *= d5;
        d2 *= d5;
        d3 *= d5;
        double d6 = Math.sin(d4);
        double d7 = Math.cosFromSin(d6, d4);
        double d8 = 1.0 - d7;
        this.m00 = d7 + d * d * d8;
        this.m11 = d7 + d2 * d2 * d8;
        this.m22 = d7 + d3 * d3 * d8;
        double d9 = d * d2 * d8;
        double d10 = d3 * d6;
        this.m10 = d9 - d10;
        this.m01 = d9 + d10;
        d9 = d * d3 * d8;
        d10 = d2 * d6;
        this.m20 = d9 + d10;
        this.m02 = d9 - d10;
        d9 = d2 * d3 * d8;
        d10 = d * d6;
        this.m21 = d9 - d10;
        this.m12 = d9 + d10;
        return this;
    }

    public Matrix3d set(AxisAngle4d axisAngle4d) {
        double d = axisAngle4d.x;
        double d2 = axisAngle4d.y;
        double d3 = axisAngle4d.z;
        double d4 = axisAngle4d.angle;
        double d5 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        d *= d5;
        d2 *= d5;
        d3 *= d5;
        double d6 = Math.sin(d4);
        double d7 = Math.cosFromSin(d6, d4);
        double d8 = 1.0 - d7;
        this.m00 = d7 + d * d * d8;
        this.m11 = d7 + d2 * d2 * d8;
        this.m22 = d7 + d3 * d3 * d8;
        double d9 = d * d2 * d8;
        double d10 = d3 * d6;
        this.m10 = d9 - d10;
        this.m01 = d9 + d10;
        d9 = d * d3 * d8;
        d10 = d2 * d6;
        this.m20 = d9 + d10;
        this.m02 = d9 - d10;
        d9 = d2 * d3 * d8;
        d10 = d * d6;
        this.m21 = d9 - d10;
        this.m12 = d9 + d10;
        return this;
    }

    public Matrix3d set(Quaternionfc quaternionfc) {
        return this.rotation(quaternionfc);
    }

    public Matrix3d set(Quaterniondc quaterniondc) {
        return this.rotation(quaterniondc);
    }

    public Matrix3d mul(Matrix3dc matrix3dc) {
        return this.mul(matrix3dc, this);
    }

    @Override
    public Matrix3d mul(Matrix3dc matrix3dc, Matrix3d matrix3d) {
        double d = Math.fma(this.m00, matrix3dc.m00(), Math.fma(this.m10, matrix3dc.m01(), this.m20 * matrix3dc.m02()));
        double d2 = Math.fma(this.m01, matrix3dc.m00(), Math.fma(this.m11, matrix3dc.m01(), this.m21 * matrix3dc.m02()));
        double d3 = Math.fma(this.m02, matrix3dc.m00(), Math.fma(this.m12, matrix3dc.m01(), this.m22 * matrix3dc.m02()));
        double d4 = Math.fma(this.m00, matrix3dc.m10(), Math.fma(this.m10, matrix3dc.m11(), this.m20 * matrix3dc.m12()));
        double d5 = Math.fma(this.m01, matrix3dc.m10(), Math.fma(this.m11, matrix3dc.m11(), this.m21 * matrix3dc.m12()));
        double d6 = Math.fma(this.m02, matrix3dc.m10(), Math.fma(this.m12, matrix3dc.m11(), this.m22 * matrix3dc.m12()));
        double d7 = Math.fma(this.m00, matrix3dc.m20(), Math.fma(this.m10, matrix3dc.m21(), this.m20 * matrix3dc.m22()));
        double d8 = Math.fma(this.m01, matrix3dc.m20(), Math.fma(this.m11, matrix3dc.m21(), this.m21 * matrix3dc.m22()));
        double d9 = Math.fma(this.m02, matrix3dc.m20(), Math.fma(this.m12, matrix3dc.m21(), this.m22 * matrix3dc.m22()));
        matrix3d.m00 = d;
        matrix3d.m01 = d2;
        matrix3d.m02 = d3;
        matrix3d.m10 = d4;
        matrix3d.m11 = d5;
        matrix3d.m12 = d6;
        matrix3d.m20 = d7;
        matrix3d.m21 = d8;
        matrix3d.m22 = d9;
        return matrix3d;
    }

    public Matrix3d mulLocal(Matrix3dc matrix3dc) {
        return this.mulLocal(matrix3dc, this);
    }

    @Override
    public Matrix3d mulLocal(Matrix3dc matrix3dc, Matrix3d matrix3d) {
        double d = matrix3dc.m00() * this.m00 + matrix3dc.m10() * this.m01 + matrix3dc.m20() * this.m02;
        double d2 = matrix3dc.m01() * this.m00 + matrix3dc.m11() * this.m01 + matrix3dc.m21() * this.m02;
        double d3 = matrix3dc.m02() * this.m00 + matrix3dc.m12() * this.m01 + matrix3dc.m22() * this.m02;
        double d4 = matrix3dc.m00() * this.m10 + matrix3dc.m10() * this.m11 + matrix3dc.m20() * this.m12;
        double d5 = matrix3dc.m01() * this.m10 + matrix3dc.m11() * this.m11 + matrix3dc.m21() * this.m12;
        double d6 = matrix3dc.m02() * this.m10 + matrix3dc.m12() * this.m11 + matrix3dc.m22() * this.m12;
        double d7 = matrix3dc.m00() * this.m20 + matrix3dc.m10() * this.m21 + matrix3dc.m20() * this.m22;
        double d8 = matrix3dc.m01() * this.m20 + matrix3dc.m11() * this.m21 + matrix3dc.m21() * this.m22;
        double d9 = matrix3dc.m02() * this.m20 + matrix3dc.m12() * this.m21 + matrix3dc.m22() * this.m22;
        matrix3d.m00 = d;
        matrix3d.m01 = d2;
        matrix3d.m02 = d3;
        matrix3d.m10 = d4;
        matrix3d.m11 = d5;
        matrix3d.m12 = d6;
        matrix3d.m20 = d7;
        matrix3d.m21 = d8;
        matrix3d.m22 = d9;
        return matrix3d;
    }

    public Matrix3d mul(Matrix3fc matrix3fc) {
        return this.mul(matrix3fc, this);
    }

    @Override
    public Matrix3d mul(Matrix3fc matrix3fc, Matrix3d matrix3d) {
        double d = Math.fma(this.m00, (double)matrix3fc.m00(), Math.fma(this.m10, (double)matrix3fc.m01(), this.m20 * (double)matrix3fc.m02()));
        double d2 = Math.fma(this.m01, (double)matrix3fc.m00(), Math.fma(this.m11, (double)matrix3fc.m01(), this.m21 * (double)matrix3fc.m02()));
        double d3 = Math.fma(this.m02, (double)matrix3fc.m00(), Math.fma(this.m12, (double)matrix3fc.m01(), this.m22 * (double)matrix3fc.m02()));
        double d4 = Math.fma(this.m00, (double)matrix3fc.m10(), Math.fma(this.m10, (double)matrix3fc.m11(), this.m20 * (double)matrix3fc.m12()));
        double d5 = Math.fma(this.m01, (double)matrix3fc.m10(), Math.fma(this.m11, (double)matrix3fc.m11(), this.m21 * (double)matrix3fc.m12()));
        double d6 = Math.fma(this.m02, (double)matrix3fc.m10(), Math.fma(this.m12, (double)matrix3fc.m11(), this.m22 * (double)matrix3fc.m12()));
        double d7 = Math.fma(this.m00, (double)matrix3fc.m20(), Math.fma(this.m10, (double)matrix3fc.m21(), this.m20 * (double)matrix3fc.m22()));
        double d8 = Math.fma(this.m01, (double)matrix3fc.m20(), Math.fma(this.m11, (double)matrix3fc.m21(), this.m21 * (double)matrix3fc.m22()));
        double d9 = Math.fma(this.m02, (double)matrix3fc.m20(), Math.fma(this.m12, (double)matrix3fc.m21(), this.m22 * (double)matrix3fc.m22()));
        matrix3d.m00 = d;
        matrix3d.m01 = d2;
        matrix3d.m02 = d3;
        matrix3d.m10 = d4;
        matrix3d.m11 = d5;
        matrix3d.m12 = d6;
        matrix3d.m20 = d7;
        matrix3d.m21 = d8;
        matrix3d.m22 = d9;
        return matrix3d;
    }

    public Matrix3d set(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        this.m20 = d7;
        this.m21 = d8;
        this.m22 = d9;
        return this;
    }

    public Matrix3d set(double[] dArray) {
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
        this.m20 = dArray[6];
        this.m21 = dArray[7];
        this.m22 = dArray[8];
        return this;
    }

    public Matrix3d set(float[] fArray) {
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m10 = fArray[3];
        this.m11 = fArray[4];
        this.m12 = fArray[5];
        this.m20 = fArray[6];
        this.m21 = fArray[7];
        this.m22 = fArray[8];
        return this;
    }

    @Override
    public double determinant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * this.m22 + (this.m02 * this.m10 - this.m00 * this.m12) * this.m21 + (this.m01 * this.m12 - this.m02 * this.m11) * this.m20;
    }

    public Matrix3d invert() {
        return this.invert(this);
    }

    @Override
    public Matrix3d invert(Matrix3d matrix3d) {
        double d = Math.fma(this.m00, this.m11, -this.m01 * this.m10);
        double d2 = Math.fma(this.m02, this.m10, -this.m00 * this.m12);
        double d3 = Math.fma(this.m01, this.m12, -this.m02 * this.m11);
        double d4 = Math.fma(d, this.m22, Math.fma(d2, this.m21, d3 * this.m20));
        double d5 = 1.0 / d4;
        double d6 = Math.fma(this.m11, this.m22, -this.m21 * this.m12) * d5;
        double d7 = Math.fma(this.m21, this.m02, -this.m01 * this.m22) * d5;
        double d8 = d3 * d5;
        double d9 = Math.fma(this.m20, this.m12, -this.m10 * this.m22) * d5;
        double d10 = Math.fma(this.m00, this.m22, -this.m20 * this.m02) * d5;
        double d11 = d2 * d5;
        double d12 = Math.fma(this.m10, this.m21, -this.m20 * this.m11) * d5;
        double d13 = Math.fma(this.m20, this.m01, -this.m00 * this.m21) * d5;
        double d14 = d * d5;
        matrix3d.m00 = d6;
        matrix3d.m01 = d7;
        matrix3d.m02 = d8;
        matrix3d.m10 = d9;
        matrix3d.m11 = d10;
        matrix3d.m12 = d11;
        matrix3d.m20 = d12;
        matrix3d.m21 = d13;
        matrix3d.m22 = d14;
        return matrix3d;
    }

    public Matrix3d transpose() {
        return this.transpose(this);
    }

    @Override
    public Matrix3d transpose(Matrix3d matrix3d) {
        matrix3d.set(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
        return matrix3d;
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat(" 0.000E0;-");
        String string = this.toString(decimalFormat);
        StringBuffer stringBuffer = new StringBuffer();
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == 'E') {
                n = i;
            } else {
                if (c == ' ' && n == i - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c) && n == i - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String toString(NumberFormat numberFormat) {
        return Runtime.format(this.m00, numberFormat) + " " + Runtime.format(this.m10, numberFormat) + " " + Runtime.format(this.m20, numberFormat) + "\n" + Runtime.format(this.m01, numberFormat) + " " + Runtime.format(this.m11, numberFormat) + " " + Runtime.format(this.m21, numberFormat) + "\n" + Runtime.format(this.m02, numberFormat) + " " + Runtime.format(this.m12, numberFormat) + " " + Runtime.format(this.m22, numberFormat) + "\n";
    }

    @Override
    public Matrix3d get(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    @Override
    public AxisAngle4f getRotation(AxisAngle4f axisAngle4f) {
        return axisAngle4f.set(this);
    }

    @Override
    public Quaternionf getUnnormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromUnnormalized(this);
    }

    @Override
    public Quaternionf getNormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromNormalized(this);
    }

    @Override
    public Quaterniond getUnnormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromUnnormalized(this);
    }

    @Override
    public Quaterniond getNormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromNormalized(this);
    }

    @Override
    public DoubleBuffer get(DoubleBuffer doubleBuffer) {
        return this.get(doubleBuffer.position(), doubleBuffer);
    }

    @Override
    public DoubleBuffer get(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, n, doubleBuffer);
        return doubleBuffer;
    }

    @Override
    public FloatBuffer get(FloatBuffer floatBuffer) {
        return this.get(floatBuffer.position(), floatBuffer);
    }

    @Override
    public FloatBuffer get(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putf(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer get(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer getFloats(ByteBuffer byteBuffer) {
        return this.getFloats(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer getFloats(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putf(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public double[] get(double[] dArray, int n) {
        dArray[n + 0] = this.m00;
        dArray[n + 1] = this.m01;
        dArray[n + 2] = this.m02;
        dArray[n + 3] = this.m10;
        dArray[n + 4] = this.m11;
        dArray[n + 5] = this.m12;
        dArray[n + 6] = this.m20;
        dArray[n + 7] = this.m21;
        dArray[n + 8] = this.m22;
        return dArray;
    }

    @Override
    public double[] get(double[] dArray) {
        return this.get(dArray, 0);
    }

    @Override
    public float[] get(float[] fArray, int n) {
        fArray[n + 0] = (float)this.m00;
        fArray[n + 1] = (float)this.m01;
        fArray[n + 2] = (float)this.m02;
        fArray[n + 3] = (float)this.m10;
        fArray[n + 4] = (float)this.m11;
        fArray[n + 5] = (float)this.m12;
        fArray[n + 6] = (float)this.m20;
        fArray[n + 7] = (float)this.m21;
        fArray[n + 8] = (float)this.m22;
        return fArray;
    }

    @Override
    public float[] get(float[] fArray) {
        return this.get(fArray, 0);
    }

    public Matrix3d set(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
        return this;
    }

    public Matrix3d set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.getf(this, floatBuffer.position(), floatBuffer);
        return this;
    }

    public Matrix3d set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Matrix3d setFloats(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.getf(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Matrix3d set(int n, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, n, doubleBuffer);
        return this;
    }

    public Matrix3d set(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.getf(this, n, floatBuffer);
        return this;
    }

    public Matrix3d set(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
        return this;
    }

    public Matrix3d setFloats(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.getf(this, n, byteBuffer);
        return this;
    }

    public Matrix3d set(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        this.m00 = vector3dc.x();
        this.m01 = vector3dc.y();
        this.m02 = vector3dc.z();
        this.m10 = vector3dc2.x();
        this.m11 = vector3dc2.y();
        this.m12 = vector3dc2.z();
        this.m20 = vector3dc3.x();
        this.m21 = vector3dc3.y();
        this.m22 = vector3dc3.z();
        return this;
    }

    public Matrix3d zero() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
        return this;
    }

    public Matrix3d identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        return this;
    }

    public Matrix3d scaling(double d) {
        this.m00 = d;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = d;
        return this;
    }

    public Matrix3d scaling(double d, double d2, double d3) {
        this.m00 = d;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d2;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = d3;
        return this;
    }

    public Matrix3d scaling(Vector3dc vector3dc) {
        this.m00 = vector3dc.x();
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = vector3dc.y();
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = vector3dc.z();
        return this;
    }

    @Override
    public Matrix3d scale(Vector3dc vector3dc, Matrix3d matrix3d) {
        return this.scale(vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix3d);
    }

    public Matrix3d scale(Vector3dc vector3dc) {
        return this.scale(vector3dc.x(), vector3dc.y(), vector3dc.z(), this);
    }

    @Override
    public Matrix3d scale(double d, double d2, double d3, Matrix3d matrix3d) {
        matrix3d.m00 = this.m00 * d;
        matrix3d.m01 = this.m01 * d;
        matrix3d.m02 = this.m02 * d;
        matrix3d.m10 = this.m10 * d2;
        matrix3d.m11 = this.m11 * d2;
        matrix3d.m12 = this.m12 * d2;
        matrix3d.m20 = this.m20 * d3;
        matrix3d.m21 = this.m21 * d3;
        matrix3d.m22 = this.m22 * d3;
        return matrix3d;
    }

    public Matrix3d scale(double d, double d2, double d3) {
        return this.scale(d, d2, d3, this);
    }

    @Override
    public Matrix3d scale(double d, Matrix3d matrix3d) {
        return this.scale(d, d, d, matrix3d);
    }

    public Matrix3d scale(double d) {
        return this.scale(d, d, d);
    }

    @Override
    public Matrix3d scaleLocal(double d, double d2, double d3, Matrix3d matrix3d) {
        double d4 = d * this.m00;
        double d5 = d2 * this.m01;
        double d6 = d3 * this.m02;
        double d7 = d * this.m10;
        double d8 = d2 * this.m11;
        double d9 = d3 * this.m12;
        double d10 = d * this.m20;
        double d11 = d2 * this.m21;
        double d12 = d3 * this.m22;
        matrix3d.m00 = d4;
        matrix3d.m01 = d5;
        matrix3d.m02 = d6;
        matrix3d.m10 = d7;
        matrix3d.m11 = d8;
        matrix3d.m12 = d9;
        matrix3d.m20 = d10;
        matrix3d.m21 = d11;
        matrix3d.m22 = d12;
        return matrix3d;
    }

    public Matrix3d scaleLocal(double d, double d2, double d3) {
        return this.scaleLocal(d, d2, d3, this);
    }

    public Matrix3d rotation(double d, Vector3dc vector3dc) {
        return this.rotation(d, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix3d rotation(double d, Vector3fc vector3fc) {
        return this.rotation(d, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3d rotation(AxisAngle4f axisAngle4f) {
        return this.rotation(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Matrix3d rotation(AxisAngle4d axisAngle4d) {
        return this.rotation(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z);
    }

    public Matrix3d rotation(double d, double d2, double d3, double d4) {
        double d5 = Math.sin(d);
        double d6 = Math.cosFromSin(d5, d);
        double d7 = 1.0 - d6;
        double d8 = d2 * d3;
        double d9 = d2 * d4;
        double d10 = d3 * d4;
        this.m00 = d6 + d2 * d2 * d7;
        this.m10 = d8 * d7 - d4 * d5;
        this.m20 = d9 * d7 + d3 * d5;
        this.m01 = d8 * d7 + d4 * d5;
        this.m11 = d6 + d3 * d3 * d7;
        this.m21 = d10 * d7 - d2 * d5;
        this.m02 = d9 * d7 - d3 * d5;
        this.m12 = d10 * d7 + d2 * d5;
        this.m22 = d6 + d4 * d4 * d7;
        return this;
    }

    public Matrix3d rotationX(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d3;
        this.m12 = d2;
        this.m20 = 0.0;
        this.m21 = -d2;
        this.m22 = d3;
        return this;
    }

    public Matrix3d rotationY(double d) {
        double d2;
        double d3 = Math.sin(d);
        this.m00 = d2 = Math.cosFromSin(d3, d);
        this.m01 = 0.0;
        this.m02 = -d3;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = d3;
        this.m21 = 0.0;
        this.m22 = d2;
        return this;
    }

    public Matrix3d rotationZ(double d) {
        double d2;
        double d3 = Math.sin(d);
        this.m00 = d2 = Math.cosFromSin(d3, d);
        this.m01 = d3;
        this.m02 = 0.0;
        this.m10 = -d3;
        this.m11 = d2;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        return this;
    }

    public Matrix3d rotationXYZ(double d, double d2, double d3) {
        double d4 = Math.sin(d);
        double d5 = Math.cosFromSin(d4, d);
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = Math.sin(d3);
        double d9 = Math.cosFromSin(d8, d3);
        double d10 = -d4;
        double d11 = -d6;
        double d12 = -d8;
        double d13 = d5;
        double d14 = d4;
        double d15 = d10;
        double d16 = d5;
        double d17 = d7;
        double d18 = d15 * d11;
        double d19 = d16 * d11;
        this.m20 = d6;
        this.m21 = d15 * d7;
        this.m22 = d16 * d7;
        this.m00 = d17 * d9;
        this.m01 = d18 * d9 + d13 * d8;
        this.m02 = d19 * d9 + d14 * d8;
        this.m10 = d17 * d12;
        this.m11 = d18 * d12 + d13 * d9;
        this.m12 = d19 * d12 + d14 * d9;
        return this;
    }

    public Matrix3d rotationZYX(double d, double d2, double d3) {
        double d4 = Math.sin(d3);
        double d5 = Math.cosFromSin(d4, d3);
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = Math.sin(d);
        double d9 = Math.cosFromSin(d8, d);
        double d10 = -d8;
        double d11 = -d6;
        double d12 = -d4;
        double d13 = d9;
        double d14 = d8;
        double d15 = d10;
        double d16 = d9;
        double d17 = d13 * d6;
        double d18 = d14 * d6;
        double d19 = d7;
        this.m00 = d13 * d7;
        this.m01 = d14 * d7;
        this.m02 = d11;
        this.m10 = d15 * d5 + d17 * d4;
        this.m11 = d16 * d5 + d18 * d4;
        this.m12 = d19 * d4;
        this.m20 = d15 * d12 + d17 * d5;
        this.m21 = d16 * d12 + d18 * d5;
        this.m22 = d19 * d5;
        return this;
    }

    public Matrix3d rotationYXZ(double d, double d2, double d3) {
        double d4 = Math.sin(d2);
        double d5 = Math.cosFromSin(d4, d2);
        double d6 = Math.sin(d);
        double d7 = Math.cosFromSin(d6, d);
        double d8 = Math.sin(d3);
        double d9 = Math.cosFromSin(d8, d3);
        double d10 = -d6;
        double d11 = -d4;
        double d12 = -d8;
        double d13 = d7;
        double d14 = d10;
        double d15 = d6;
        double d16 = d7;
        double d17 = d15 * d4;
        double d18 = d5;
        double d19 = d16 * d4;
        this.m20 = d15 * d5;
        this.m21 = d11;
        this.m22 = d16 * d5;
        this.m00 = d13 * d9 + d17 * d8;
        this.m01 = d18 * d8;
        this.m02 = d14 * d9 + d19 * d8;
        this.m10 = d13 * d12 + d17 * d9;
        this.m11 = d18 * d9;
        this.m12 = d14 * d12 + d19 * d9;
        return this;
    }

    public Matrix3d rotation(Quaterniondc quaterniondc) {
        double d = quaterniondc.w() * quaterniondc.w();
        double d2 = quaterniondc.x() * quaterniondc.x();
        double d3 = quaterniondc.y() * quaterniondc.y();
        double d4 = quaterniondc.z() * quaterniondc.z();
        double d5 = quaterniondc.z() * quaterniondc.w();
        double d6 = d5 + d5;
        double d7 = quaterniondc.x() * quaterniondc.y();
        double d8 = d7 + d7;
        double d9 = quaterniondc.x() * quaterniondc.z();
        double d10 = d9 + d9;
        double d11 = quaterniondc.y() * quaterniondc.w();
        double d12 = d11 + d11;
        double d13 = quaterniondc.y() * quaterniondc.z();
        double d14 = d13 + d13;
        double d15 = quaterniondc.x() * quaterniondc.w();
        double d16 = d15 + d15;
        this.m00 = d + d2 - d4 - d3;
        this.m01 = d8 + d6;
        this.m02 = d10 - d12;
        this.m10 = -d6 + d8;
        this.m11 = d3 - d4 + d - d2;
        this.m12 = d14 + d16;
        this.m20 = d12 + d10;
        this.m21 = d14 - d16;
        this.m22 = d4 - d3 - d2 + d;
        return this;
    }

    public Matrix3d rotation(Quaternionfc quaternionfc) {
        double d = quaternionfc.w() * quaternionfc.w();
        double d2 = quaternionfc.x() * quaternionfc.x();
        double d3 = quaternionfc.y() * quaternionfc.y();
        double d4 = quaternionfc.z() * quaternionfc.z();
        double d5 = quaternionfc.z() * quaternionfc.w();
        double d6 = d5 + d5;
        double d7 = quaternionfc.x() * quaternionfc.y();
        double d8 = d7 + d7;
        double d9 = quaternionfc.x() * quaternionfc.z();
        double d10 = d9 + d9;
        double d11 = quaternionfc.y() * quaternionfc.w();
        double d12 = d11 + d11;
        double d13 = quaternionfc.y() * quaternionfc.z();
        double d14 = d13 + d13;
        double d15 = quaternionfc.x() * quaternionfc.w();
        double d16 = d15 + d15;
        this.m00 = d + d2 - d4 - d3;
        this.m01 = d8 + d6;
        this.m02 = d10 - d12;
        this.m10 = -d6 + d8;
        this.m11 = d3 - d4 + d - d2;
        this.m12 = d14 + d16;
        this.m20 = d12 + d10;
        this.m21 = d14 - d16;
        this.m22 = d4 - d3 - d2 + d;
        return this;
    }

    @Override
    public Vector3d transform(Vector3d vector3d) {
        return vector3d.mul(this);
    }

    @Override
    public Vector3d transform(Vector3dc vector3dc, Vector3d vector3d) {
        vector3dc.mul((Matrix3dc)this, vector3d);
        return vector3d;
    }

    @Override
    public Vector3f transform(Vector3f vector3f) {
        return vector3f.mul(this);
    }

    @Override
    public Vector3f transform(Vector3fc vector3fc, Vector3f vector3f) {
        return vector3fc.mul(this, vector3f);
    }

    @Override
    public Vector3d transform(double d, double d2, double d3, Vector3d vector3d) {
        return vector3d.set(Math.fma(this.m00, d, Math.fma(this.m10, d2, this.m20 * d3)), Math.fma(this.m01, d, Math.fma(this.m11, d2, this.m21 * d3)), Math.fma(this.m02, d, Math.fma(this.m12, d2, this.m22 * d3)));
    }

    @Override
    public Vector3d transformTranspose(Vector3d vector3d) {
        return vector3d.mulTranspose(this);
    }

    @Override
    public Vector3d transformTranspose(Vector3dc vector3dc, Vector3d vector3d) {
        return vector3dc.mulTranspose(this, vector3d);
    }

    @Override
    public Vector3d transformTranspose(double d, double d2, double d3, Vector3d vector3d) {
        return vector3d.set(Math.fma(this.m00, d, Math.fma(this.m01, d2, this.m02 * d3)), Math.fma(this.m10, d, Math.fma(this.m11, d2, this.m12 * d3)), Math.fma(this.m20, d, Math.fma(this.m21, d2, this.m22 * d3)));
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.m00);
        objectOutput.writeDouble(this.m01);
        objectOutput.writeDouble(this.m02);
        objectOutput.writeDouble(this.m10);
        objectOutput.writeDouble(this.m11);
        objectOutput.writeDouble(this.m12);
        objectOutput.writeDouble(this.m20);
        objectOutput.writeDouble(this.m21);
        objectOutput.writeDouble(this.m22);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.m00 = objectInput.readDouble();
        this.m01 = objectInput.readDouble();
        this.m02 = objectInput.readDouble();
        this.m10 = objectInput.readDouble();
        this.m11 = objectInput.readDouble();
        this.m12 = objectInput.readDouble();
        this.m20 = objectInput.readDouble();
        this.m21 = objectInput.readDouble();
        this.m22 = objectInput.readDouble();
    }

    @Override
    public Matrix3d rotateX(double d, Matrix3d matrix3d) {
        double d2;
        double d3 = Math.sin(d);
        double d4 = d2 = Math.cosFromSin(d3, d);
        double d5 = -d3;
        double d6 = d3;
        double d7 = d2;
        double d8 = this.m10 * d4 + this.m20 * d6;
        double d9 = this.m11 * d4 + this.m21 * d6;
        double d10 = this.m12 * d4 + this.m22 * d6;
        matrix3d.m20 = this.m10 * d5 + this.m20 * d7;
        matrix3d.m21 = this.m11 * d5 + this.m21 * d7;
        matrix3d.m22 = this.m12 * d5 + this.m22 * d7;
        matrix3d.m10 = d8;
        matrix3d.m11 = d9;
        matrix3d.m12 = d10;
        matrix3d.m00 = this.m00;
        matrix3d.m01 = this.m01;
        matrix3d.m02 = this.m02;
        return matrix3d;
    }

    public Matrix3d rotateX(double d) {
        return this.rotateX(d, this);
    }

    @Override
    public Matrix3d rotateY(double d, Matrix3d matrix3d) {
        double d2;
        double d3 = Math.sin(d);
        double d4 = d2 = Math.cosFromSin(d3, d);
        double d5 = d3;
        double d6 = -d3;
        double d7 = d2;
        double d8 = this.m00 * d4 + this.m20 * d6;
        double d9 = this.m01 * d4 + this.m21 * d6;
        double d10 = this.m02 * d4 + this.m22 * d6;
        matrix3d.m20 = this.m00 * d5 + this.m20 * d7;
        matrix3d.m21 = this.m01 * d5 + this.m21 * d7;
        matrix3d.m22 = this.m02 * d5 + this.m22 * d7;
        matrix3d.m00 = d8;
        matrix3d.m01 = d9;
        matrix3d.m02 = d10;
        matrix3d.m10 = this.m10;
        matrix3d.m11 = this.m11;
        matrix3d.m12 = this.m12;
        return matrix3d;
    }

    public Matrix3d rotateY(double d) {
        return this.rotateY(d, this);
    }

    @Override
    public Matrix3d rotateZ(double d, Matrix3d matrix3d) {
        double d2;
        double d3 = Math.sin(d);
        double d4 = d2 = Math.cosFromSin(d3, d);
        double d5 = -d3;
        double d6 = d3;
        double d7 = d2;
        double d8 = this.m00 * d4 + this.m10 * d6;
        double d9 = this.m01 * d4 + this.m11 * d6;
        double d10 = this.m02 * d4 + this.m12 * d6;
        matrix3d.m10 = this.m00 * d5 + this.m10 * d7;
        matrix3d.m11 = this.m01 * d5 + this.m11 * d7;
        matrix3d.m12 = this.m02 * d5 + this.m12 * d7;
        matrix3d.m00 = d8;
        matrix3d.m01 = d9;
        matrix3d.m02 = d10;
        matrix3d.m20 = this.m20;
        matrix3d.m21 = this.m21;
        matrix3d.m22 = this.m22;
        return matrix3d;
    }

    public Matrix3d rotateZ(double d) {
        return this.rotateZ(d, this);
    }

    public Matrix3d rotateXYZ(double d, double d2, double d3) {
        return this.rotateXYZ(d, d2, d3, this);
    }

    @Override
    public Matrix3d rotateXYZ(double d, double d2, double d3, Matrix3d matrix3d) {
        double d4 = Math.sin(d);
        double d5 = Math.cosFromSin(d4, d);
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = Math.sin(d3);
        double d9 = Math.cosFromSin(d8, d3);
        double d10 = -d4;
        double d11 = -d6;
        double d12 = -d8;
        double d13 = this.m10 * d5 + this.m20 * d4;
        double d14 = this.m11 * d5 + this.m21 * d4;
        double d15 = this.m12 * d5 + this.m22 * d4;
        double d16 = this.m10 * d10 + this.m20 * d5;
        double d17 = this.m11 * d10 + this.m21 * d5;
        double d18 = this.m12 * d10 + this.m22 * d5;
        double d19 = this.m00 * d7 + d16 * d11;
        double d20 = this.m01 * d7 + d17 * d11;
        double d21 = this.m02 * d7 + d18 * d11;
        matrix3d.m20 = this.m00 * d6 + d16 * d7;
        matrix3d.m21 = this.m01 * d6 + d17 * d7;
        matrix3d.m22 = this.m02 * d6 + d18 * d7;
        matrix3d.m00 = d19 * d9 + d13 * d8;
        matrix3d.m01 = d20 * d9 + d14 * d8;
        matrix3d.m02 = d21 * d9 + d15 * d8;
        matrix3d.m10 = d19 * d12 + d13 * d9;
        matrix3d.m11 = d20 * d12 + d14 * d9;
        matrix3d.m12 = d21 * d12 + d15 * d9;
        return matrix3d;
    }

    public Matrix3d rotateZYX(double d, double d2, double d3) {
        return this.rotateZYX(d, d2, d3, this);
    }

    @Override
    public Matrix3d rotateZYX(double d, double d2, double d3, Matrix3d matrix3d) {
        double d4 = Math.sin(d3);
        double d5 = Math.cosFromSin(d4, d3);
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = Math.sin(d);
        double d9 = Math.cosFromSin(d8, d);
        double d10 = -d8;
        double d11 = -d6;
        double d12 = -d4;
        double d13 = this.m00 * d9 + this.m10 * d8;
        double d14 = this.m01 * d9 + this.m11 * d8;
        double d15 = this.m02 * d9 + this.m12 * d8;
        double d16 = this.m00 * d10 + this.m10 * d9;
        double d17 = this.m01 * d10 + this.m11 * d9;
        double d18 = this.m02 * d10 + this.m12 * d9;
        double d19 = d13 * d6 + this.m20 * d7;
        double d20 = d14 * d6 + this.m21 * d7;
        double d21 = d15 * d6 + this.m22 * d7;
        matrix3d.m00 = d13 * d7 + this.m20 * d11;
        matrix3d.m01 = d14 * d7 + this.m21 * d11;
        matrix3d.m02 = d15 * d7 + this.m22 * d11;
        matrix3d.m10 = d16 * d5 + d19 * d4;
        matrix3d.m11 = d17 * d5 + d20 * d4;
        matrix3d.m12 = d18 * d5 + d21 * d4;
        matrix3d.m20 = d16 * d12 + d19 * d5;
        matrix3d.m21 = d17 * d12 + d20 * d5;
        matrix3d.m22 = d18 * d12 + d21 * d5;
        return matrix3d;
    }

    public Matrix3d rotateYXZ(Vector3d vector3d) {
        return this.rotateYXZ(vector3d.y, vector3d.x, vector3d.z);
    }

    public Matrix3d rotateYXZ(double d, double d2, double d3) {
        return this.rotateYXZ(d, d2, d3, this);
    }

    @Override
    public Matrix3d rotateYXZ(double d, double d2, double d3, Matrix3d matrix3d) {
        double d4 = Math.sin(d2);
        double d5 = Math.cosFromSin(d4, d2);
        double d6 = Math.sin(d);
        double d7 = Math.cosFromSin(d6, d);
        double d8 = Math.sin(d3);
        double d9 = Math.cosFromSin(d8, d3);
        double d10 = -d6;
        double d11 = -d4;
        double d12 = -d8;
        double d13 = this.m00 * d6 + this.m20 * d7;
        double d14 = this.m01 * d6 + this.m21 * d7;
        double d15 = this.m02 * d6 + this.m22 * d7;
        double d16 = this.m00 * d7 + this.m20 * d10;
        double d17 = this.m01 * d7 + this.m21 * d10;
        double d18 = this.m02 * d7 + this.m22 * d10;
        double d19 = this.m10 * d5 + d13 * d4;
        double d20 = this.m11 * d5 + d14 * d4;
        double d21 = this.m12 * d5 + d15 * d4;
        matrix3d.m20 = this.m10 * d11 + d13 * d5;
        matrix3d.m21 = this.m11 * d11 + d14 * d5;
        matrix3d.m22 = this.m12 * d11 + d15 * d5;
        matrix3d.m00 = d16 * d9 + d19 * d8;
        matrix3d.m01 = d17 * d9 + d20 * d8;
        matrix3d.m02 = d18 * d9 + d21 * d8;
        matrix3d.m10 = d16 * d12 + d19 * d9;
        matrix3d.m11 = d17 * d12 + d20 * d9;
        matrix3d.m12 = d18 * d12 + d21 * d9;
        return matrix3d;
    }

    public Matrix3d rotate(double d, double d2, double d3, double d4) {
        return this.rotate(d, d2, d3, d4, this);
    }

    @Override
    public Matrix3d rotate(double d, double d2, double d3, double d4, Matrix3d matrix3d) {
        double d5 = Math.sin(d);
        double d6 = Math.cosFromSin(d5, d);
        double d7 = 1.0 - d6;
        double d8 = d2 * d2;
        double d9 = d2 * d3;
        double d10 = d2 * d4;
        double d11 = d3 * d3;
        double d12 = d3 * d4;
        double d13 = d4 * d4;
        double d14 = d8 * d7 + d6;
        double d15 = d9 * d7 + d4 * d5;
        double d16 = d10 * d7 - d3 * d5;
        double d17 = d9 * d7 - d4 * d5;
        double d18 = d11 * d7 + d6;
        double d19 = d12 * d7 + d2 * d5;
        double d20 = d10 * d7 + d3 * d5;
        double d21 = d12 * d7 - d2 * d5;
        double d22 = d13 * d7 + d6;
        double d23 = this.m00 * d14 + this.m10 * d15 + this.m20 * d16;
        double d24 = this.m01 * d14 + this.m11 * d15 + this.m21 * d16;
        double d25 = this.m02 * d14 + this.m12 * d15 + this.m22 * d16;
        double d26 = this.m00 * d17 + this.m10 * d18 + this.m20 * d19;
        double d27 = this.m01 * d17 + this.m11 * d18 + this.m21 * d19;
        double d28 = this.m02 * d17 + this.m12 * d18 + this.m22 * d19;
        matrix3d.m20 = this.m00 * d20 + this.m10 * d21 + this.m20 * d22;
        matrix3d.m21 = this.m01 * d20 + this.m11 * d21 + this.m21 * d22;
        matrix3d.m22 = this.m02 * d20 + this.m12 * d21 + this.m22 * d22;
        matrix3d.m00 = d23;
        matrix3d.m01 = d24;
        matrix3d.m02 = d25;
        matrix3d.m10 = d26;
        matrix3d.m11 = d27;
        matrix3d.m12 = d28;
        return matrix3d;
    }

    @Override
    public Matrix3d rotateLocal(double d, double d2, double d3, double d4, Matrix3d matrix3d) {
        double d5 = Math.sin(d);
        double d6 = Math.cosFromSin(d5, d);
        double d7 = 1.0 - d6;
        double d8 = d2 * d2;
        double d9 = d2 * d3;
        double d10 = d2 * d4;
        double d11 = d3 * d3;
        double d12 = d3 * d4;
        double d13 = d4 * d4;
        double d14 = d8 * d7 + d6;
        double d15 = d9 * d7 + d4 * d5;
        double d16 = d10 * d7 - d3 * d5;
        double d17 = d9 * d7 - d4 * d5;
        double d18 = d11 * d7 + d6;
        double d19 = d12 * d7 + d2 * d5;
        double d20 = d10 * d7 + d3 * d5;
        double d21 = d12 * d7 - d2 * d5;
        double d22 = d13 * d7 + d6;
        double d23 = d14 * this.m00 + d17 * this.m01 + d20 * this.m02;
        double d24 = d15 * this.m00 + d18 * this.m01 + d21 * this.m02;
        double d25 = d16 * this.m00 + d19 * this.m01 + d22 * this.m02;
        double d26 = d14 * this.m10 + d17 * this.m11 + d20 * this.m12;
        double d27 = d15 * this.m10 + d18 * this.m11 + d21 * this.m12;
        double d28 = d16 * this.m10 + d19 * this.m11 + d22 * this.m12;
        double d29 = d14 * this.m20 + d17 * this.m21 + d20 * this.m22;
        double d30 = d15 * this.m20 + d18 * this.m21 + d21 * this.m22;
        double d31 = d16 * this.m20 + d19 * this.m21 + d22 * this.m22;
        matrix3d.m00 = d23;
        matrix3d.m01 = d24;
        matrix3d.m02 = d25;
        matrix3d.m10 = d26;
        matrix3d.m11 = d27;
        matrix3d.m12 = d28;
        matrix3d.m20 = d29;
        matrix3d.m21 = d30;
        matrix3d.m22 = d31;
        return matrix3d;
    }

    public Matrix3d rotateLocal(double d, double d2, double d3, double d4) {
        return this.rotateLocal(d, d2, d3, d4, this);
    }

    @Override
    public Matrix3d rotateLocalX(double d, Matrix3d matrix3d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = d3 * this.m01 - d2 * this.m02;
        double d5 = d2 * this.m01 + d3 * this.m02;
        double d6 = d3 * this.m11 - d2 * this.m12;
        double d7 = d2 * this.m11 + d3 * this.m12;
        double d8 = d3 * this.m21 - d2 * this.m22;
        double d9 = d2 * this.m21 + d3 * this.m22;
        matrix3d.m00 = this.m00;
        matrix3d.m01 = d4;
        matrix3d.m02 = d5;
        matrix3d.m10 = this.m10;
        matrix3d.m11 = d6;
        matrix3d.m12 = d7;
        matrix3d.m20 = this.m20;
        matrix3d.m21 = d8;
        matrix3d.m22 = d9;
        return matrix3d;
    }

    public Matrix3d rotateLocalX(double d) {
        return this.rotateLocalX(d, this);
    }

    @Override
    public Matrix3d rotateLocalY(double d, Matrix3d matrix3d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = d3 * this.m00 + d2 * this.m02;
        double d5 = -d2 * this.m00 + d3 * this.m02;
        double d6 = d3 * this.m10 + d2 * this.m12;
        double d7 = -d2 * this.m10 + d3 * this.m12;
        double d8 = d3 * this.m20 + d2 * this.m22;
        double d9 = -d2 * this.m20 + d3 * this.m22;
        matrix3d.m00 = d4;
        matrix3d.m01 = this.m01;
        matrix3d.m02 = d5;
        matrix3d.m10 = d6;
        matrix3d.m11 = this.m11;
        matrix3d.m12 = d7;
        matrix3d.m20 = d8;
        matrix3d.m21 = this.m21;
        matrix3d.m22 = d9;
        return matrix3d;
    }

    public Matrix3d rotateLocalY(double d) {
        return this.rotateLocalY(d, this);
    }

    @Override
    public Matrix3d rotateLocalZ(double d, Matrix3d matrix3d) {
        double d2 = Math.sin(d);
        double d3 = Math.cosFromSin(d2, d);
        double d4 = d3 * this.m00 - d2 * this.m01;
        double d5 = d2 * this.m00 + d3 * this.m01;
        double d6 = d3 * this.m10 - d2 * this.m11;
        double d7 = d2 * this.m10 + d3 * this.m11;
        double d8 = d3 * this.m20 - d2 * this.m21;
        double d9 = d2 * this.m20 + d3 * this.m21;
        matrix3d.m00 = d4;
        matrix3d.m01 = d5;
        matrix3d.m02 = this.m02;
        matrix3d.m10 = d6;
        matrix3d.m11 = d7;
        matrix3d.m12 = this.m12;
        matrix3d.m20 = d8;
        matrix3d.m21 = d9;
        matrix3d.m22 = this.m22;
        return matrix3d;
    }

    public Matrix3d rotateLocalZ(double d) {
        return this.rotateLocalZ(d, this);
    }

    @Override
    public Matrix3d rotateLocal(Quaterniondc quaterniondc, Matrix3d matrix3d) {
        double d = quaterniondc.w() * quaterniondc.w();
        double d2 = quaterniondc.x() * quaterniondc.x();
        double d3 = quaterniondc.y() * quaterniondc.y();
        double d4 = quaterniondc.z() * quaterniondc.z();
        double d5 = quaterniondc.z() * quaterniondc.w();
        double d6 = d5 + d5;
        double d7 = quaterniondc.x() * quaterniondc.y();
        double d8 = d7 + d7;
        double d9 = quaterniondc.x() * quaterniondc.z();
        double d10 = d9 + d9;
        double d11 = quaterniondc.y() * quaterniondc.w();
        double d12 = d11 + d11;
        double d13 = quaterniondc.y() * quaterniondc.z();
        double d14 = d13 + d13;
        double d15 = quaterniondc.x() * quaterniondc.w();
        double d16 = d15 + d15;
        double d17 = d + d2 - d4 - d3;
        double d18 = d8 + d6;
        double d19 = d10 - d12;
        double d20 = d8 - d6;
        double d21 = d3 - d4 + d - d2;
        double d22 = d14 + d16;
        double d23 = d12 + d10;
        double d24 = d14 - d16;
        double d25 = d4 - d3 - d2 + d;
        double d26 = d17 * this.m00 + d20 * this.m01 + d23 * this.m02;
        double d27 = d18 * this.m00 + d21 * this.m01 + d24 * this.m02;
        double d28 = d19 * this.m00 + d22 * this.m01 + d25 * this.m02;
        double d29 = d17 * this.m10 + d20 * this.m11 + d23 * this.m12;
        double d30 = d18 * this.m10 + d21 * this.m11 + d24 * this.m12;
        double d31 = d19 * this.m10 + d22 * this.m11 + d25 * this.m12;
        double d32 = d17 * this.m20 + d20 * this.m21 + d23 * this.m22;
        double d33 = d18 * this.m20 + d21 * this.m21 + d24 * this.m22;
        double d34 = d19 * this.m20 + d22 * this.m21 + d25 * this.m22;
        matrix3d.m00 = d26;
        matrix3d.m01 = d27;
        matrix3d.m02 = d28;
        matrix3d.m10 = d29;
        matrix3d.m11 = d30;
        matrix3d.m12 = d31;
        matrix3d.m20 = d32;
        matrix3d.m21 = d33;
        matrix3d.m22 = d34;
        return matrix3d;
    }

    public Matrix3d rotateLocal(Quaterniondc quaterniondc) {
        return this.rotateLocal(quaterniondc, this);
    }

    @Override
    public Matrix3d rotateLocal(Quaternionfc quaternionfc, Matrix3d matrix3d) {
        double d = quaternionfc.w() * quaternionfc.w();
        double d2 = quaternionfc.x() * quaternionfc.x();
        double d3 = quaternionfc.y() * quaternionfc.y();
        double d4 = quaternionfc.z() * quaternionfc.z();
        double d5 = quaternionfc.z() * quaternionfc.w();
        double d6 = d5 + d5;
        double d7 = quaternionfc.x() * quaternionfc.y();
        double d8 = d7 + d7;
        double d9 = quaternionfc.x() * quaternionfc.z();
        double d10 = d9 + d9;
        double d11 = quaternionfc.y() * quaternionfc.w();
        double d12 = d11 + d11;
        double d13 = quaternionfc.y() * quaternionfc.z();
        double d14 = d13 + d13;
        double d15 = quaternionfc.x() * quaternionfc.w();
        double d16 = d15 + d15;
        double d17 = d + d2 - d4 - d3;
        double d18 = d8 + d6;
        double d19 = d10 - d12;
        double d20 = d8 - d6;
        double d21 = d3 - d4 + d - d2;
        double d22 = d14 + d16;
        double d23 = d12 + d10;
        double d24 = d14 - d16;
        double d25 = d4 - d3 - d2 + d;
        double d26 = d17 * this.m00 + d20 * this.m01 + d23 * this.m02;
        double d27 = d18 * this.m00 + d21 * this.m01 + d24 * this.m02;
        double d28 = d19 * this.m00 + d22 * this.m01 + d25 * this.m02;
        double d29 = d17 * this.m10 + d20 * this.m11 + d23 * this.m12;
        double d30 = d18 * this.m10 + d21 * this.m11 + d24 * this.m12;
        double d31 = d19 * this.m10 + d22 * this.m11 + d25 * this.m12;
        double d32 = d17 * this.m20 + d20 * this.m21 + d23 * this.m22;
        double d33 = d18 * this.m20 + d21 * this.m21 + d24 * this.m22;
        double d34 = d19 * this.m20 + d22 * this.m21 + d25 * this.m22;
        matrix3d.m00 = d26;
        matrix3d.m01 = d27;
        matrix3d.m02 = d28;
        matrix3d.m10 = d29;
        matrix3d.m11 = d30;
        matrix3d.m12 = d31;
        matrix3d.m20 = d32;
        matrix3d.m21 = d33;
        matrix3d.m22 = d34;
        return matrix3d;
    }

    public Matrix3d rotateLocal(Quaternionfc quaternionfc) {
        return this.rotateLocal(quaternionfc, this);
    }

    public Matrix3d rotate(Quaterniondc quaterniondc) {
        return this.rotate(quaterniondc, this);
    }

    @Override
    public Matrix3d rotate(Quaterniondc quaterniondc, Matrix3d matrix3d) {
        double d = quaterniondc.w() * quaterniondc.w();
        double d2 = quaterniondc.x() * quaterniondc.x();
        double d3 = quaterniondc.y() * quaterniondc.y();
        double d4 = quaterniondc.z() * quaterniondc.z();
        double d5 = quaterniondc.z() * quaterniondc.w();
        double d6 = d5 + d5;
        double d7 = quaterniondc.x() * quaterniondc.y();
        double d8 = d7 + d7;
        double d9 = quaterniondc.x() * quaterniondc.z();
        double d10 = d9 + d9;
        double d11 = quaterniondc.y() * quaterniondc.w();
        double d12 = d11 + d11;
        double d13 = quaterniondc.y() * quaterniondc.z();
        double d14 = d13 + d13;
        double d15 = quaterniondc.x() * quaterniondc.w();
        double d16 = d15 + d15;
        double d17 = d + d2 - d4 - d3;
        double d18 = d8 + d6;
        double d19 = d10 - d12;
        double d20 = d8 - d6;
        double d21 = d3 - d4 + d - d2;
        double d22 = d14 + d16;
        double d23 = d12 + d10;
        double d24 = d14 - d16;
        double d25 = d4 - d3 - d2 + d;
        double d26 = this.m00 * d17 + this.m10 * d18 + this.m20 * d19;
        double d27 = this.m01 * d17 + this.m11 * d18 + this.m21 * d19;
        double d28 = this.m02 * d17 + this.m12 * d18 + this.m22 * d19;
        double d29 = this.m00 * d20 + this.m10 * d21 + this.m20 * d22;
        double d30 = this.m01 * d20 + this.m11 * d21 + this.m21 * d22;
        double d31 = this.m02 * d20 + this.m12 * d21 + this.m22 * d22;
        matrix3d.m20 = this.m00 * d23 + this.m10 * d24 + this.m20 * d25;
        matrix3d.m21 = this.m01 * d23 + this.m11 * d24 + this.m21 * d25;
        matrix3d.m22 = this.m02 * d23 + this.m12 * d24 + this.m22 * d25;
        matrix3d.m00 = d26;
        matrix3d.m01 = d27;
        matrix3d.m02 = d28;
        matrix3d.m10 = d29;
        matrix3d.m11 = d30;
        matrix3d.m12 = d31;
        return matrix3d;
    }

    public Matrix3d rotate(Quaternionfc quaternionfc) {
        return this.rotate(quaternionfc, this);
    }

    @Override
    public Matrix3d rotate(Quaternionfc quaternionfc, Matrix3d matrix3d) {
        double d = quaternionfc.w() * quaternionfc.w();
        double d2 = quaternionfc.x() * quaternionfc.x();
        double d3 = quaternionfc.y() * quaternionfc.y();
        double d4 = quaternionfc.z() * quaternionfc.z();
        double d5 = quaternionfc.z() * quaternionfc.w();
        double d6 = d5 + d5;
        double d7 = quaternionfc.x() * quaternionfc.y();
        double d8 = d7 + d7;
        double d9 = quaternionfc.x() * quaternionfc.z();
        double d10 = d9 + d9;
        double d11 = quaternionfc.y() * quaternionfc.w();
        double d12 = d11 + d11;
        double d13 = quaternionfc.y() * quaternionfc.z();
        double d14 = d13 + d13;
        double d15 = quaternionfc.x() * quaternionfc.w();
        double d16 = d15 + d15;
        double d17 = d + d2 - d4 - d3;
        double d18 = d8 + d6;
        double d19 = d10 - d12;
        double d20 = d8 - d6;
        double d21 = d3 - d4 + d - d2;
        double d22 = d14 + d16;
        double d23 = d12 + d10;
        double d24 = d14 - d16;
        double d25 = d4 - d3 - d2 + d;
        double d26 = this.m00 * d17 + this.m10 * d18 + this.m20 * d19;
        double d27 = this.m01 * d17 + this.m11 * d18 + this.m21 * d19;
        double d28 = this.m02 * d17 + this.m12 * d18 + this.m22 * d19;
        double d29 = this.m00 * d20 + this.m10 * d21 + this.m20 * d22;
        double d30 = this.m01 * d20 + this.m11 * d21 + this.m21 * d22;
        double d31 = this.m02 * d20 + this.m12 * d21 + this.m22 * d22;
        matrix3d.m20 = this.m00 * d23 + this.m10 * d24 + this.m20 * d25;
        matrix3d.m21 = this.m01 * d23 + this.m11 * d24 + this.m21 * d25;
        matrix3d.m22 = this.m02 * d23 + this.m12 * d24 + this.m22 * d25;
        matrix3d.m00 = d26;
        matrix3d.m01 = d27;
        matrix3d.m02 = d28;
        matrix3d.m10 = d29;
        matrix3d.m11 = d30;
        matrix3d.m12 = d31;
        return matrix3d;
    }

    public Matrix3d rotate(AxisAngle4f axisAngle4f) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    @Override
    public Matrix3d rotate(AxisAngle4f axisAngle4f, Matrix3d matrix3d) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z, matrix3d);
    }

    public Matrix3d rotate(AxisAngle4d axisAngle4d) {
        return this.rotate(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z);
    }

    @Override
    public Matrix3d rotate(AxisAngle4d axisAngle4d, Matrix3d matrix3d) {
        return this.rotate(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z, matrix3d);
    }

    public Matrix3d rotate(double d, Vector3dc vector3dc) {
        return this.rotate(d, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    @Override
    public Matrix3d rotate(double d, Vector3dc vector3dc, Matrix3d matrix3d) {
        return this.rotate(d, vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix3d);
    }

    public Matrix3d rotate(double d, Vector3fc vector3fc) {
        return this.rotate(d, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    @Override
    public Matrix3d rotate(double d, Vector3fc vector3fc, Matrix3d matrix3d) {
        return this.rotate(d, vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix3d);
    }

    @Override
    public Vector3d getRow(int n, Vector3d vector3d) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return vector3d.set(this.m00, this.m10, this.m20);
            }
            case 1: {
                return vector3d.set(this.m01, this.m11, this.m21);
            }
            case 2: {
                return vector3d.set(this.m02, this.m12, this.m22);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix3d setRow(int n, Vector3dc vector3dc) throws IndexOutOfBoundsException {
        return this.setRow(n, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix3d setRow(int n, double d, double d2, double d3) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                this.m00 = d;
                this.m10 = d2;
                this.m20 = d3;
                break;
            }
            case 1: {
                this.m01 = d;
                this.m11 = d2;
                this.m21 = d3;
                break;
            }
            case 2: {
                this.m02 = d;
                this.m12 = d2;
                this.m22 = d3;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    @Override
    public Vector3d getColumn(int n, Vector3d vector3d) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return vector3d.set(this.m00, this.m01, this.m02);
            }
            case 1: {
                return vector3d.set(this.m10, this.m11, this.m12);
            }
            case 2: {
                return vector3d.set(this.m20, this.m21, this.m22);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix3d setColumn(int n, Vector3dc vector3dc) throws IndexOutOfBoundsException {
        return this.setColumn(n, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix3d setColumn(int n, double d, double d2, double d3) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                this.m00 = d;
                this.m01 = d2;
                this.m02 = d3;
                break;
            }
            case 1: {
                this.m10 = d;
                this.m11 = d2;
                this.m12 = d3;
                break;
            }
            case 2: {
                this.m20 = d;
                this.m21 = d2;
                this.m22 = d3;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    @Override
    public double get(int n, int n2) {
        return MemUtil.INSTANCE.get(this, n, n2);
    }

    public Matrix3d set(int n, int n2, double d) {
        return MemUtil.INSTANCE.set(this, n, n2, d);
    }

    @Override
    public double getRowColumn(int n, int n2) {
        return MemUtil.INSTANCE.get(this, n2, n);
    }

    public Matrix3d setRowColumn(int n, int n2, double d) {
        return MemUtil.INSTANCE.set(this, n2, n, d);
    }

    public Matrix3d normal() {
        return this.normal(this);
    }

    @Override
    public Matrix3d normal(Matrix3d matrix3d) {
        double d = this.m00 * this.m11;
        double d2 = this.m01 * this.m10;
        double d3 = this.m02 * this.m10;
        double d4 = this.m00 * this.m12;
        double d5 = this.m01 * this.m12;
        double d6 = this.m02 * this.m11;
        double d7 = (d - d2) * this.m22 + (d3 - d4) * this.m21 + (d5 - d6) * this.m20;
        double d8 = 1.0 / d7;
        double d9 = (this.m11 * this.m22 - this.m21 * this.m12) * d8;
        double d10 = (this.m20 * this.m12 - this.m10 * this.m22) * d8;
        double d11 = (this.m10 * this.m21 - this.m20 * this.m11) * d8;
        double d12 = (this.m21 * this.m02 - this.m01 * this.m22) * d8;
        double d13 = (this.m00 * this.m22 - this.m20 * this.m02) * d8;
        double d14 = (this.m20 * this.m01 - this.m00 * this.m21) * d8;
        double d15 = (d5 - d6) * d8;
        double d16 = (d3 - d4) * d8;
        double d17 = (d - d2) * d8;
        matrix3d.m00 = d9;
        matrix3d.m01 = d10;
        matrix3d.m02 = d11;
        matrix3d.m10 = d12;
        matrix3d.m11 = d13;
        matrix3d.m12 = d14;
        matrix3d.m20 = d15;
        matrix3d.m21 = d16;
        matrix3d.m22 = d17;
        return matrix3d;
    }

    public Matrix3d cofactor() {
        return this.cofactor(this);
    }

    @Override
    public Matrix3d cofactor(Matrix3d matrix3d) {
        double d = this.m11 * this.m22 - this.m21 * this.m12;
        double d2 = this.m20 * this.m12 - this.m10 * this.m22;
        double d3 = this.m10 * this.m21 - this.m20 * this.m11;
        double d4 = this.m21 * this.m02 - this.m01 * this.m22;
        double d5 = this.m00 * this.m22 - this.m20 * this.m02;
        double d6 = this.m20 * this.m01 - this.m00 * this.m21;
        double d7 = this.m01 * this.m12 - this.m11 * this.m02;
        double d8 = this.m02 * this.m10 - this.m12 * this.m00;
        double d9 = this.m00 * this.m11 - this.m10 * this.m01;
        matrix3d.m00 = d;
        matrix3d.m01 = d2;
        matrix3d.m02 = d3;
        matrix3d.m10 = d4;
        matrix3d.m11 = d5;
        matrix3d.m12 = d6;
        matrix3d.m20 = d7;
        matrix3d.m21 = d8;
        matrix3d.m22 = d9;
        return matrix3d;
    }

    public Matrix3d lookAlong(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.lookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), this);
    }

    @Override
    public Matrix3d lookAlong(Vector3dc vector3dc, Vector3dc vector3dc2, Matrix3d matrix3d) {
        return this.lookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), matrix3d);
    }

    @Override
    public Matrix3d lookAlong(double d, double d2, double d3, double d4, double d5, double d6, Matrix3d matrix3d) {
        double d7 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        double d8 = d5 * (d3 *= -d7) - d6 * (d2 *= -d7);
        double d9 = d6 * (d *= -d7) - d4 * d3;
        double d10 = d4 * d2 - d5 * d;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d2 * (d10 *= d11) - d3 * (d9 *= d11);
        double d13 = d3 * (d8 *= d11) - d * d10;
        double d14 = d * d9 - d2 * d8;
        double d15 = d8;
        double d16 = d12;
        double d17 = d;
        double d18 = d9;
        double d19 = d13;
        double d20 = d2;
        double d21 = d10;
        double d22 = d14;
        double d23 = d3;
        double d24 = this.m00 * d15 + this.m10 * d16 + this.m20 * d17;
        double d25 = this.m01 * d15 + this.m11 * d16 + this.m21 * d17;
        double d26 = this.m02 * d15 + this.m12 * d16 + this.m22 * d17;
        double d27 = this.m00 * d18 + this.m10 * d19 + this.m20 * d20;
        double d28 = this.m01 * d18 + this.m11 * d19 + this.m21 * d20;
        double d29 = this.m02 * d18 + this.m12 * d19 + this.m22 * d20;
        matrix3d.m20 = this.m00 * d21 + this.m10 * d22 + this.m20 * d23;
        matrix3d.m21 = this.m01 * d21 + this.m11 * d22 + this.m21 * d23;
        matrix3d.m22 = this.m02 * d21 + this.m12 * d22 + this.m22 * d23;
        matrix3d.m00 = d24;
        matrix3d.m01 = d25;
        matrix3d.m02 = d26;
        matrix3d.m10 = d27;
        matrix3d.m11 = d28;
        matrix3d.m12 = d29;
        return matrix3d;
    }

    public Matrix3d lookAlong(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.lookAlong(d, d2, d3, d4, d5, d6, this);
    }

    public Matrix3d setLookAlong(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.setLookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Matrix3d setLookAlong(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        double d8 = d5 * (d3 *= -d7) - d6 * (d2 *= -d7);
        double d9 = d6 * (d *= -d7) - d4 * d3;
        double d10 = d4 * d2 - d5 * d;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d2 * (d10 *= d11) - d3 * (d9 *= d11);
        double d13 = d3 * (d8 *= d11) - d * d10;
        double d14 = d * d9 - d2 * d8;
        this.m00 = d8;
        this.m01 = d12;
        this.m02 = d;
        this.m10 = d9;
        this.m11 = d13;
        this.m12 = d2;
        this.m20 = d10;
        this.m21 = d14;
        this.m22 = d3;
        return this;
    }

    @Override
    public Vector3d getScale(Vector3d vector3d) {
        vector3d.x = Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        vector3d.y = Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        vector3d.z = Math.sqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        return vector3d;
    }

    @Override
    public Vector3d positiveZ(Vector3d vector3d) {
        vector3d.x = this.m10 * this.m21 - this.m11 * this.m20;
        vector3d.y = this.m20 * this.m01 - this.m21 * this.m00;
        vector3d.z = this.m00 * this.m11 - this.m01 * this.m10;
        return vector3d.normalize(vector3d);
    }

    @Override
    public Vector3d normalizedPositiveZ(Vector3d vector3d) {
        vector3d.x = this.m02;
        vector3d.y = this.m12;
        vector3d.z = this.m22;
        return vector3d;
    }

    @Override
    public Vector3d positiveX(Vector3d vector3d) {
        vector3d.x = this.m11 * this.m22 - this.m12 * this.m21;
        vector3d.y = this.m02 * this.m21 - this.m01 * this.m22;
        vector3d.z = this.m01 * this.m12 - this.m02 * this.m11;
        return vector3d.normalize(vector3d);
    }

    @Override
    public Vector3d normalizedPositiveX(Vector3d vector3d) {
        vector3d.x = this.m00;
        vector3d.y = this.m10;
        vector3d.z = this.m20;
        return vector3d;
    }

    @Override
    public Vector3d positiveY(Vector3d vector3d) {
        vector3d.x = this.m12 * this.m20 - this.m10 * this.m22;
        vector3d.y = this.m00 * this.m22 - this.m02 * this.m20;
        vector3d.z = this.m02 * this.m10 - this.m00 * this.m12;
        return vector3d.normalize(vector3d);
    }

    @Override
    public Vector3d normalizedPositiveY(Vector3d vector3d) {
        vector3d.x = this.m01;
        vector3d.y = this.m11;
        vector3d.z = this.m21;
        return vector3d;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.m00);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m01);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m02);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m10);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m11);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m12);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m20);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m21);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m22);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Matrix3d matrix3d = (Matrix3d)object;
        if (Double.doubleToLongBits(this.m00) != Double.doubleToLongBits(matrix3d.m00)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m01) != Double.doubleToLongBits(matrix3d.m01)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m02) != Double.doubleToLongBits(matrix3d.m02)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m10) != Double.doubleToLongBits(matrix3d.m10)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m11) != Double.doubleToLongBits(matrix3d.m11)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m12) != Double.doubleToLongBits(matrix3d.m12)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m20) != Double.doubleToLongBits(matrix3d.m20)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m21) != Double.doubleToLongBits(matrix3d.m21)) {
            return false;
        }
        return Double.doubleToLongBits(this.m22) == Double.doubleToLongBits(matrix3d.m22);
    }

    @Override
    public boolean equals(Matrix3dc matrix3dc, double d) {
        if (this == matrix3dc) {
            return true;
        }
        if (matrix3dc == null) {
            return false;
        }
        if (!(matrix3dc instanceof Matrix3d)) {
            return false;
        }
        if (!Runtime.equals(this.m00, matrix3dc.m00(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m01, matrix3dc.m01(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m02, matrix3dc.m02(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m10, matrix3dc.m10(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m11, matrix3dc.m11(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m12, matrix3dc.m12(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m20, matrix3dc.m20(), d)) {
            return false;
        }
        if (!Runtime.equals(this.m21, matrix3dc.m21(), d)) {
            return false;
        }
        return Runtime.equals(this.m22, matrix3dc.m22(), d);
    }

    public Matrix3d swap(Matrix3d matrix3d) {
        double d = this.m00;
        this.m00 = matrix3d.m00;
        matrix3d.m00 = d;
        d = this.m01;
        this.m01 = matrix3d.m01;
        matrix3d.m01 = d;
        d = this.m02;
        this.m02 = matrix3d.m02;
        matrix3d.m02 = d;
        d = this.m10;
        this.m10 = matrix3d.m10;
        matrix3d.m10 = d;
        d = this.m11;
        this.m11 = matrix3d.m11;
        matrix3d.m11 = d;
        d = this.m12;
        this.m12 = matrix3d.m12;
        matrix3d.m12 = d;
        d = this.m20;
        this.m20 = matrix3d.m20;
        matrix3d.m20 = d;
        d = this.m21;
        this.m21 = matrix3d.m21;
        matrix3d.m21 = d;
        d = this.m22;
        this.m22 = matrix3d.m22;
        matrix3d.m22 = d;
        return this;
    }

    public Matrix3d add(Matrix3dc matrix3dc) {
        return this.add(matrix3dc, this);
    }

    @Override
    public Matrix3d add(Matrix3dc matrix3dc, Matrix3d matrix3d) {
        matrix3d.m00 = this.m00 + matrix3dc.m00();
        matrix3d.m01 = this.m01 + matrix3dc.m01();
        matrix3d.m02 = this.m02 + matrix3dc.m02();
        matrix3d.m10 = this.m10 + matrix3dc.m10();
        matrix3d.m11 = this.m11 + matrix3dc.m11();
        matrix3d.m12 = this.m12 + matrix3dc.m12();
        matrix3d.m20 = this.m20 + matrix3dc.m20();
        matrix3d.m21 = this.m21 + matrix3dc.m21();
        matrix3d.m22 = this.m22 + matrix3dc.m22();
        return matrix3d;
    }

    public Matrix3d sub(Matrix3dc matrix3dc) {
        return this.sub(matrix3dc, this);
    }

    @Override
    public Matrix3d sub(Matrix3dc matrix3dc, Matrix3d matrix3d) {
        matrix3d.m00 = this.m00 - matrix3dc.m00();
        matrix3d.m01 = this.m01 - matrix3dc.m01();
        matrix3d.m02 = this.m02 - matrix3dc.m02();
        matrix3d.m10 = this.m10 - matrix3dc.m10();
        matrix3d.m11 = this.m11 - matrix3dc.m11();
        matrix3d.m12 = this.m12 - matrix3dc.m12();
        matrix3d.m20 = this.m20 - matrix3dc.m20();
        matrix3d.m21 = this.m21 - matrix3dc.m21();
        matrix3d.m22 = this.m22 - matrix3dc.m22();
        return matrix3d;
    }

    public Matrix3d mulComponentWise(Matrix3dc matrix3dc) {
        return this.mulComponentWise(matrix3dc, this);
    }

    @Override
    public Matrix3d mulComponentWise(Matrix3dc matrix3dc, Matrix3d matrix3d) {
        matrix3d.m00 = this.m00 * matrix3dc.m00();
        matrix3d.m01 = this.m01 * matrix3dc.m01();
        matrix3d.m02 = this.m02 * matrix3dc.m02();
        matrix3d.m10 = this.m10 * matrix3dc.m10();
        matrix3d.m11 = this.m11 * matrix3dc.m11();
        matrix3d.m12 = this.m12 * matrix3dc.m12();
        matrix3d.m20 = this.m20 * matrix3dc.m20();
        matrix3d.m21 = this.m21 * matrix3dc.m21();
        matrix3d.m22 = this.m22 * matrix3dc.m22();
        return matrix3d;
    }

    public Matrix3d setSkewSymmetric(double d, double d2, double d3) {
        this.m22 = 0.0;
        this.m11 = 0.0;
        this.m00 = 0.0;
        this.m01 = -d;
        this.m02 = d2;
        this.m10 = d;
        this.m12 = -d3;
        this.m20 = -d2;
        this.m21 = d3;
        return this;
    }

    public Matrix3d lerp(Matrix3dc matrix3dc, double d) {
        return this.lerp(matrix3dc, d, this);
    }

    @Override
    public Matrix3d lerp(Matrix3dc matrix3dc, double d, Matrix3d matrix3d) {
        matrix3d.m00 = Math.fma(matrix3dc.m00() - this.m00, d, this.m00);
        matrix3d.m01 = Math.fma(matrix3dc.m01() - this.m01, d, this.m01);
        matrix3d.m02 = Math.fma(matrix3dc.m02() - this.m02, d, this.m02);
        matrix3d.m10 = Math.fma(matrix3dc.m10() - this.m10, d, this.m10);
        matrix3d.m11 = Math.fma(matrix3dc.m11() - this.m11, d, this.m11);
        matrix3d.m12 = Math.fma(matrix3dc.m12() - this.m12, d, this.m12);
        matrix3d.m20 = Math.fma(matrix3dc.m20() - this.m20, d, this.m20);
        matrix3d.m21 = Math.fma(matrix3dc.m21() - this.m21, d, this.m21);
        matrix3d.m22 = Math.fma(matrix3dc.m22() - this.m22, d, this.m22);
        return matrix3d;
    }

    @Override
    public Matrix3d rotateTowards(Vector3dc vector3dc, Vector3dc vector3dc2, Matrix3d matrix3d) {
        return this.rotateTowards(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), matrix3d);
    }

    public Matrix3d rotateTowards(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.rotateTowards(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), this);
    }

    public Matrix3d rotateTowards(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.rotateTowards(d, d2, d3, d4, d5, d6, this);
    }

    @Override
    public Matrix3d rotateTowards(double d, double d2, double d3, double d4, double d5, double d6, Matrix3d matrix3d) {
        double d7 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        double d8 = d * d7;
        double d9 = d2 * d7;
        double d10 = d3 * d7;
        double d11 = d5 * d10 - d6 * d9;
        double d12 = d6 * d8 - d4 * d10;
        double d13 = d4 * d9 - d5 * d8;
        double d14 = Math.invsqrt(d11 * d11 + d12 * d12 + d13 * d13);
        double d15 = d9 * (d13 *= d14) - d10 * (d12 *= d14);
        double d16 = d10 * (d11 *= d14) - d8 * d13;
        double d17 = d8 * d12 - d9 * d11;
        double d18 = d11;
        double d19 = d12;
        double d20 = d13;
        double d21 = d15;
        double d22 = d16;
        double d23 = d17;
        double d24 = d8;
        double d25 = d9;
        double d26 = d10;
        double d27 = this.m00 * d18 + this.m10 * d19 + this.m20 * d20;
        double d28 = this.m01 * d18 + this.m11 * d19 + this.m21 * d20;
        double d29 = this.m02 * d18 + this.m12 * d19 + this.m22 * d20;
        double d30 = this.m00 * d21 + this.m10 * d22 + this.m20 * d23;
        double d31 = this.m01 * d21 + this.m11 * d22 + this.m21 * d23;
        double d32 = this.m02 * d21 + this.m12 * d22 + this.m22 * d23;
        matrix3d.m20 = this.m00 * d24 + this.m10 * d25 + this.m20 * d26;
        matrix3d.m21 = this.m01 * d24 + this.m11 * d25 + this.m21 * d26;
        matrix3d.m22 = this.m02 * d24 + this.m12 * d25 + this.m22 * d26;
        matrix3d.m00 = d27;
        matrix3d.m01 = d28;
        matrix3d.m02 = d29;
        matrix3d.m10 = d30;
        matrix3d.m11 = d31;
        matrix3d.m12 = d32;
        return matrix3d;
    }

    public Matrix3d rotationTowards(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.rotationTowards(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Matrix3d rotationTowards(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.invsqrt(d * d + d2 * d2 + d3 * d3);
        double d8 = d * d7;
        double d9 = d2 * d7;
        double d10 = d3 * d7;
        double d11 = d5 * d10 - d6 * d9;
        double d12 = d6 * d8 - d4 * d10;
        double d13 = d4 * d9 - d5 * d8;
        double d14 = Math.invsqrt(d11 * d11 + d12 * d12 + d13 * d13);
        double d15 = d9 * (d13 *= d14) - d10 * (d12 *= d14);
        double d16 = d10 * (d11 *= d14) - d8 * d13;
        double d17 = d8 * d12 - d9 * d11;
        this.m00 = d11;
        this.m01 = d12;
        this.m02 = d13;
        this.m10 = d15;
        this.m11 = d16;
        this.m12 = d17;
        this.m20 = d8;
        this.m21 = d9;
        this.m22 = d10;
        return this;
    }

    @Override
    public Vector3d getEulerAnglesZYX(Vector3d vector3d) {
        vector3d.x = (float)Math.atan2(this.m12, this.m22);
        vector3d.y = (float)Math.atan2(-this.m02, Math.sqrt(this.m12 * this.m12 + this.m22 * this.m22));
        vector3d.z = (float)Math.atan2(this.m01, this.m00);
        return vector3d;
    }

    public Matrix3d obliqueZ(double d, double d2) {
        this.m20 = this.m00 * d + this.m10 * d2 + this.m20;
        this.m21 = this.m01 * d + this.m11 * d2 + this.m21;
        this.m22 = this.m02 * d + this.m12 * d2 + this.m22;
        return this;
    }

    @Override
    public Matrix3d obliqueZ(double d, double d2, Matrix3d matrix3d) {
        matrix3d.m00 = this.m00;
        matrix3d.m01 = this.m01;
        matrix3d.m02 = this.m02;
        matrix3d.m10 = this.m10;
        matrix3d.m11 = this.m11;
        matrix3d.m12 = this.m12;
        matrix3d.m20 = this.m00 * d + this.m10 * d2 + this.m20;
        matrix3d.m21 = this.m01 * d + this.m11 * d2 + this.m21;
        matrix3d.m22 = this.m02 * d + this.m12 * d2 + this.m22;
        return matrix3d;
    }

    @Override
    public Matrix3d reflect(double d, double d2, double d3, Matrix3d matrix3d) {
        double d4 = d + d;
        double d5 = d2 + d2;
        double d6 = d3 + d3;
        double d7 = 1.0 - d4 * d;
        double d8 = -d4 * d2;
        double d9 = -d4 * d3;
        double d10 = -d5 * d;
        double d11 = 1.0 - d5 * d2;
        double d12 = -d5 * d3;
        double d13 = -d6 * d;
        double d14 = -d6 * d2;
        double d15 = 1.0 - d6 * d3;
        double d16 = this.m00 * d7 + this.m10 * d8 + this.m20 * d9;
        double d17 = this.m01 * d7 + this.m11 * d8 + this.m21 * d9;
        double d18 = this.m02 * d7 + this.m12 * d8 + this.m22 * d9;
        double d19 = this.m00 * d10 + this.m10 * d11 + this.m20 * d12;
        double d20 = this.m01 * d10 + this.m11 * d11 + this.m21 * d12;
        double d21 = this.m02 * d10 + this.m12 * d11 + this.m22 * d12;
        return matrix3d._m20(this.m00 * d13 + this.m10 * d14 + this.m20 * d15)._m21(this.m01 * d13 + this.m11 * d14 + this.m21 * d15)._m22(this.m02 * d13 + this.m12 * d14 + this.m22 * d15)._m00(d16)._m01(d17)._m02(d18)._m10(d19)._m11(d20)._m12(d21);
    }

    public Matrix3d reflect(double d, double d2, double d3) {
        return this.reflect(d, d2, d3, this);
    }

    public Matrix3d reflect(Vector3dc vector3dc) {
        return this.reflect(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix3d reflect(Quaterniondc quaterniondc) {
        return this.reflect(quaterniondc, this);
    }

    @Override
    public Matrix3d reflect(Quaterniondc quaterniondc, Matrix3d matrix3d) {
        double d = quaterniondc.x() + quaterniondc.x();
        double d2 = quaterniondc.y() + quaterniondc.y();
        double d3 = quaterniondc.z() + quaterniondc.z();
        double d4 = quaterniondc.x() * d3 + quaterniondc.w() * d2;
        double d5 = quaterniondc.y() * d3 - quaterniondc.w() * d;
        double d6 = 1.0 - (quaterniondc.x() * d + quaterniondc.y() * d2);
        return this.reflect(d4, d5, d6, matrix3d);
    }

    @Override
    public Matrix3d reflect(Vector3dc vector3dc, Matrix3d matrix3d) {
        return this.reflect(vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix3d);
    }

    public Matrix3d reflection(double d, double d2, double d3) {
        double d4 = d + d;
        double d5 = d2 + d2;
        double d6 = d3 + d3;
        this._m00(1.0 - d4 * d);
        this._m01(-d4 * d2);
        this._m02(-d4 * d3);
        this._m10(-d5 * d);
        this._m11(1.0 - d5 * d2);
        this._m12(-d5 * d3);
        this._m20(-d6 * d);
        this._m21(-d6 * d2);
        this._m22(1.0 - d6 * d3);
        return this;
    }

    public Matrix3d reflection(Vector3dc vector3dc) {
        return this.reflection(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix3d reflection(Quaterniondc quaterniondc) {
        double d = quaterniondc.x() + quaterniondc.x();
        double d2 = quaterniondc.y() + quaterniondc.y();
        double d3 = quaterniondc.z() + quaterniondc.z();
        double d4 = quaterniondc.x() * d3 + quaterniondc.w() * d2;
        double d5 = quaterniondc.y() * d3 - quaterniondc.w() * d;
        double d6 = 1.0 - (quaterniondc.x() * d + quaterniondc.y() * d2);
        return this.reflection(d4, d5, d6);
    }

    @Override
    public boolean isFinite() {
        return Math.isFinite(this.m00) && Math.isFinite(this.m01) && Math.isFinite(this.m02) && Math.isFinite(this.m10) && Math.isFinite(this.m11) && Math.isFinite(this.m12) && Math.isFinite(this.m20) && Math.isFinite(this.m21) && Math.isFinite(this.m22);
    }

    @Override
    public double quadraticFormProduct(double d, double d2, double d3) {
        double d4 = this.m00 * d + this.m10 * d2 + this.m20 * d3;
        double d5 = this.m01 * d + this.m11 * d2 + this.m21 * d3;
        double d6 = this.m02 * d + this.m12 * d2 + this.m22 * d3;
        return d * d4 + d2 * d5 + d3 * d6;
    }

    @Override
    public double quadraticFormProduct(Vector3dc vector3dc) {
        return this.quadraticFormProduct(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    @Override
    public double quadraticFormProduct(Vector3fc vector3fc) {
        return this.quadraticFormProduct(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

