/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows.frustum.advanced;

import net.coderbot.iris.shadows.frustum.BoxCuller;
import net.coderbot.iris.shadows.frustum.advanced.BaseClippingPlanes;
import net.coderbot.iris.shadows.frustum.advanced.NeighboringPlaneSet;
import net.coderbot.iris.vendored.joml.Math;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_238;
import net.minecraft.class_4604;

public class AdvancedShadowCullingFrustum
extends class_4604 {
    private static final int MAX_CLIPPING_PLANES = 30;
    private final class_1162[] planes = new class_1162[30];
    private int planeCount = 0;
    private double x;
    private double y;
    private double z;
    private final class_1160 shadowLightVectorFromOrigin;
    private final BoxCuller boxCuller;

    public AdvancedShadowCullingFrustum(class_1159 class_11592, class_1159 class_11593, class_1160 class_11602, BoxCuller boxCuller) {
        super(new class_1159(), new class_1159());
        this.shadowLightVectorFromOrigin = class_11602;
        BaseClippingPlanes baseClippingPlanes = new BaseClippingPlanes(class_11592, class_11593);
        boolean[] blArray = this.addBackPlanes(baseClippingPlanes);
        this.addEdgePlanes(baseClippingPlanes, blArray);
        this.boxCuller = boxCuller;
    }

    private void addPlane(class_1162 class_11622) {
        this.planes[this.planeCount] = class_11622;
        ++this.planeCount;
    }

    private boolean[] addBackPlanes(BaseClippingPlanes baseClippingPlanes) {
        class_1162[] class_1162Array = baseClippingPlanes.getPlanes();
        boolean[] blArray = new boolean[class_1162Array.length];
        for (int i = 0; i < class_1162Array.length; ++i) {
            class_1162 class_11622 = class_1162Array[i];
            class_1160 class_11602 = this.truncate(class_11622);
            float f = class_11602.method_4950(this.shadowLightVectorFromOrigin);
            boolean bl = (double)f > 0.0;
            boolean bl2 = (double)f == 0.0;
            blArray[i] = bl;
            if (!bl && !bl2) continue;
            this.addPlane(class_11622);
        }
        return blArray;
    }

    private void addEdgePlanes(BaseClippingPlanes baseClippingPlanes, boolean[] blArray) {
        class_1162[] class_1162Array = baseClippingPlanes.getPlanes();
        for (int i = 0; i < class_1162Array.length; ++i) {
            if (!blArray[i]) continue;
            class_1162 class_11622 = class_1162Array[i];
            NeighboringPlaneSet neighboringPlaneSet = NeighboringPlaneSet.forPlane(i);
            if (!blArray[neighboringPlaneSet.getPlane0()]) {
                this.addEdgePlane(class_11622, class_1162Array[neighboringPlaneSet.getPlane0()]);
            }
            if (!blArray[neighboringPlaneSet.getPlane1()]) {
                this.addEdgePlane(class_11622, class_1162Array[neighboringPlaneSet.getPlane1()]);
            }
            if (!blArray[neighboringPlaneSet.getPlane2()]) {
                this.addEdgePlane(class_11622, class_1162Array[neighboringPlaneSet.getPlane2()]);
            }
            if (blArray[neighboringPlaneSet.getPlane3()]) continue;
            this.addEdgePlane(class_11622, class_1162Array[neighboringPlaneSet.getPlane3()]);
        }
    }

    private class_1160 truncate(class_1162 class_11622) {
        return new class_1160(class_11622.method_4953(), class_11622.method_4956(), class_11622.method_4957());
    }

    private class_1162 extend(class_1160 class_11602, float f) {
        return new class_1162(class_11602.method_4943(), class_11602.method_4945(), class_11602.method_4947(), f);
    }

    private float lengthSquared(class_1160 class_11602) {
        float f = class_11602.method_4943();
        float f2 = class_11602.method_4945();
        float f3 = class_11602.method_4947();
        return f * f + f2 * f2 + f3 * f3;
    }

    private class_1160 cross(class_1160 class_11602, class_1160 class_11603) {
        class_1160 class_11604 = new class_1160(class_11602.method_4943(), class_11602.method_4945(), class_11602.method_4947());
        class_11604.method_4951(class_11603);
        return class_11604;
    }

    private void addEdgePlane(class_1162 class_11622, class_1162 class_11623) {
        class_1160 class_11602 = this.truncate(class_11622);
        class_1160 class_11603 = this.truncate(class_11623);
        class_1160 class_11604 = this.cross(class_11602, class_11603);
        class_1160 class_11605 = this.cross(class_11604, this.shadowLightVectorFromOrigin);
        class_1160 class_11606 = this.cross(class_11604, class_11602);
        class_1160 class_11607 = this.cross(class_11603, class_11604);
        class_11606.method_4942(-class_11623.method_23853());
        class_11607.method_4942(-class_11622.method_23853());
        class_11606.method_23846(class_11607);
        class_1160 class_11608 = class_11606;
        class_11608.method_4942(1.0f / this.lengthSquared(class_11604));
        float f = class_11605.method_4950(class_11608);
        float f2 = -f;
        class_11606 = this.extend(class_11605, f2);
        this.addPlane((class_1162)class_11606);
    }

    public void method_23088(double d, double d2, double d3) {
        if (this.boxCuller != null) {
            this.boxCuller.setPosition(d, d2, d3);
        }
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public boolean method_23093(class_238 class_2382) {
        if (this.boxCuller != null && this.boxCuller.isCulled(class_2382)) {
            return false;
        }
        return this.isVisible(class_2382.field_1323, class_2382.field_1322, class_2382.field_1321, class_2382.field_1320, class_2382.field_1325, class_2382.field_1324);
    }

    public boolean fastAabbTest(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.boxCuller != null && this.boxCuller.isCulled(f, f2, f3, f4, f5, f6)) {
            return false;
        }
        return this.isVisible(f, f2, f3, f4, f5, f6);
    }

    public boolean canDetermineInvisible(double d, double d2, double d3, double d4, double d5, double d6) {
        return false;
    }

    private boolean isVisible(double d, double d2, double d3, double d4, double d5, double d6) {
        float f = (float)(d - this.x);
        float f2 = (float)(d2 - this.y);
        float f3 = (float)(d3 - this.z);
        float f4 = (float)(d4 - this.x);
        float f5 = (float)(d5 - this.y);
        float f6 = (float)(d6 - this.z);
        return this.isAnyCornerVisible(f, f2, f3, f4, f5, f6);
    }

    private boolean isAnyCornerVisible(float f, float f2, float f3, float f4, float f5, float f6) {
        for (int i = 0; i < this.planeCount; ++i) {
            class_1162 class_11622 = this.planes[i];
            if (this.dot(class_11622, f, f2, f3) > 0.0f || this.dot(class_11622, f4, f2, f3) > 0.0f || this.dot(class_11622, f, f5, f3) > 0.0f || this.dot(class_11622, f4, f5, f3) > 0.0f || this.dot(class_11622, f, f2, f6) > 0.0f || this.dot(class_11622, f4, f2, f6) > 0.0f || this.dot(class_11622, f, f5, f6) > 0.0f || this.dot(class_11622, f4, f5, f6) > 0.0f) continue;
            return false;
        }
        return true;
    }

    private float dot(class_1162 class_11622, float f, float f2, float f3) {
        return Math.fma(class_11622.method_4953(), f, Math.fma(class_11622.method_4956(), f2, Math.fma(class_11622.method_4957(), f3, class_11622.method_23853())));
    }
}

