/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.samplers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.minecraft.class_1044;

public class IrisSamplers {
    public static final int ALBEDO_TEXTURE_UNIT = 0;
    public static final int OVERLAY_TEXTURE_UNIT = 1;
    public static final int LIGHTMAP_TEXTURE_UNIT = 2;
    public static final ImmutableSet<Integer> WORLD_RESERVED_TEXTURE_UNITS = ImmutableSet.of((Object)0, (Object)1, (Object)2);
    public static final ImmutableSet<Integer> COMPOSITE_RESERVED_TEXTURE_UNITS = ImmutableSet.of((Object)1, (Object)2);

    private IrisSamplers() {
    }

    public static void addRenderTargetSamplers(SamplerHolder samplerHolder, Supplier<ImmutableSet<Integer>> supplier, RenderTargets renderTargets, boolean bl) {
        int n;
        for (int i = n = bl ? 0 : 4; i < renderTargets.getRenderTargetCount(); ++i) {
            int n2 = i;
            IntSupplier intSupplier = () -> {
                ImmutableSet immutableSet = (ImmutableSet)supplier.get();
                RenderTarget renderTarget = renderTargets.get(n2);
                if (immutableSet.contains((Object)n2)) {
                    return renderTarget.getAltTexture();
                }
                return renderTarget.getMainTexture();
            };
            String string = "colortex" + i;
            if (i < PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.size()) {
                String string2 = (String)PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.get(i);
                if (i == 0 && bl) {
                    samplerHolder.addDefaultSampler(intSupplier, string, string2);
                    continue;
                }
                samplerHolder.addDynamicSampler(intSupplier, string, string2);
                continue;
            }
            samplerHolder.addDynamicSampler(intSupplier, string);
        }
    }

    public static void addNoiseSampler(SamplerHolder samplerHolder, IntSupplier intSupplier) {
        samplerHolder.addDynamicSampler(intSupplier, "noisetex");
    }

    public static boolean hasShadowSamplers(SamplerHolder samplerHolder) {
        ImmutableList immutableList = ImmutableList.of((Object)"shadowtex0", (Object)"shadowtex0HW", (Object)"shadowtex1", (Object)"shadowtex1HW", (Object)"shadow", (Object)"watershadow", (Object)"shadowcolor", (Object)"shadowcolor0", (Object)"shadowcolor1", (Object)"shadowcolorimg0", (Object)"shadowcolorimg1");
        for (String string : immutableList) {
            if (!samplerHolder.hasSampler(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean addShadowSamplers(SamplerHolder samplerHolder, ShadowRenderTargets shadowRenderTargets) {
        boolean bl;
        boolean bl2 = samplerHolder.hasSampler("watershadow");
        if (bl2) {
            bl = true;
            samplerHolder.addDynamicSampler(shadowRenderTargets.getDepthTexture()::getTextureId, "shadowtex0", "watershadow");
            samplerHolder.addDynamicSampler(shadowRenderTargets.getDepthTextureNoTranslucents()::getTextureId, "shadowtex1", "shadow");
        } else {
            bl = samplerHolder.addDynamicSampler(shadowRenderTargets.getDepthTexture()::getTextureId, "shadowtex0", "shadow");
            bl |= samplerHolder.addDynamicSampler(shadowRenderTargets.getDepthTextureNoTranslucents()::getTextureId, "shadowtex1");
        }
        samplerHolder.addDynamicSampler(() -> shadowRenderTargets.getColorTextureId(0), "shadowcolor", "shadowcolor0");
        samplerHolder.addDynamicSampler(() -> shadowRenderTargets.getColorTextureId(1), "shadowcolor1");
        if (shadowRenderTargets.isHardwareFiltered(0)) {
            samplerHolder.addDynamicSampler(shadowRenderTargets.getDepthTexture()::getTextureId, "shadowtex0HW");
        }
        if (shadowRenderTargets.isHardwareFiltered(1)) {
            samplerHolder.addDynamicSampler(shadowRenderTargets.getDepthTextureNoTranslucents()::getTextureId, "shadowtex1HW");
        }
        return bl;
    }

    public static void addLevelSamplers(SamplerHolder samplerHolder, class_1044 class_10442, class_1044 class_10443, class_1044 class_10444, InputAvailability inputAvailability) {
        if (inputAvailability.texture) {
            samplerHolder.addExternalSampler(0, "tex", "texture", "gtexture");
        } else {
            samplerHolder.addDynamicSampler(() -> ((class_1044)class_10444).method_4624(), "tex", "texture", "gtexture", "gcolor", "colortex0");
        }
        if (inputAvailability.lightmap) {
            samplerHolder.addExternalSampler(2, "lightmap");
        } else {
            samplerHolder.addDynamicSampler(() -> ((class_1044)class_10444).method_4624(), "lightmap");
        }
        if (inputAvailability.overlay) {
            samplerHolder.addExternalSampler(1, "iris_overlay");
        } else {
            samplerHolder.addDynamicSampler(() -> ((class_1044)class_10444).method_4624(), "iris_overlay");
        }
        samplerHolder.addDynamicSampler(() -> ((class_1044)class_10442).method_4624(), "normals");
        samplerHolder.addDynamicSampler(() -> ((class_1044)class_10443).method_4624(), "specular");
    }

    public static void addWorldDepthSamplers(SamplerHolder samplerHolder, RenderTargets renderTargets) {
        samplerHolder.addDynamicSampler(renderTargets::getDepthTexture, "depthtex0");
        samplerHolder.addDynamicSampler(renderTargets.getDepthTextureNoTranslucents()::getTextureId, "depthtex1");
    }

    public static void addCompositeSamplers(SamplerHolder samplerHolder, RenderTargets renderTargets) {
        samplerHolder.addDynamicSampler(renderTargets::getDepthTexture, "gdepthtex", "depthtex0");
        samplerHolder.addDynamicSampler(renderTargets.getDepthTextureNoTranslucents()::getTextureId, "depthtex1");
        samplerHolder.addDynamicSampler(renderTargets.getDepthTextureNoHand()::getTextureId, "depthtex2");
    }
}

