/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_773;
import net.minecraft.class_777;
import org.jetbrains.annotations.ApiStatus;

public final class SpriteCalculator {
    private static final class_773 MODELS = class_310.method_1551().method_1554().method_4743();
    private static final Supplier<class_5819> RANDOM_SUPPLIER = new Supplier<class_5819>(){
        private final class_5819 random = class_5819.method_43047();

        @Override
        public class_5819 get() {
            this.random.method_43052(42L);
            return this.random;
        }
    };
    private static final ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock();
    private static final EnumMap<class_2350, Map<class_2680, class_1058>> SPRITE_CACHE = new EnumMap(class_2350.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static class_1058 getSprite(class_2680 state, class_2350 face) {
        class_1058 sprite;
        Map<class_2680, class_1058> map = SPRITE_CACHE.get(face);
        LOCK.readLock().lock();
        try {
            sprite = map.get(state);
        }
        finally {
            LOCK.readLock().unlock();
        }
        if (sprite == null) {
            LOCK.writeLock().lock();
            try {
                sprite = SpriteCalculator.calculateSprite(state, face, RANDOM_SUPPLIER);
                map.put(state, sprite);
            }
            finally {
                LOCK.writeLock().unlock();
            }
        }
        return sprite;
    }

    public static class_1058 calculateSprite(class_2680 state, class_2350 face, Supplier<class_5819> randomSupplier) {
        class_1087 model = MODELS.method_3335(state);
        try {
            List quads = model.method_4707(state, face, randomSupplier.get());
            if (!quads.isEmpty()) {
                return ((class_777)quads.get(0)).method_35788();
            }
            quads = model.method_4707(state, null, randomSupplier.get());
            if (!quads.isEmpty()) {
                int amount = quads.size();
                for (int i = 0; i < amount; ++i) {
                    class_777 quad = (class_777)quads.get(i);
                    if (quad.method_3358() != face) continue;
                    return quad.method_35788();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return model.method_4711();
    }

    @ApiStatus.Internal
    public static void clearCache() {
        for (Map<class_2680, class_1058> map : SPRITE_CACHE.values()) {
            map.clear();
        }
    }

    static {
        for (class_2350 direction : class_2350.values()) {
            SPRITE_CACHE.put(direction, (Map<class_2680, class_1058>)new Object2ObjectOpenHashMap());
        }
    }
}

