/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.properties.PropertiesParsingHelper;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1921;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class CustomBlockLayers {
    public static final class_2960 LOCATION = new class_2960("optifine/block.properties");
    private static final Predicate<class_2680>[] EMPTY_LAYER_PREDICATES = new Predicate[BlockLayer.VALUES.length];
    private static final Predicate<class_2680>[] LAYER_PREDICATES = new Predicate[BlockLayer.VALUES.length];

    @Nullable
    public static class_1921 getLayer(class_2680 state) {
        for (int i = 0; i < BlockLayer.VALUES.length; ++i) {
            Predicate<class_2680> predicate = LAYER_PREDICATES[i];
            if (predicate == null || !predicate.test(state)) continue;
            return BlockLayer.VALUES[i].getLayer();
        }
        return null;
    }

    private static void reload(class_3300 manager) {
        System.arraycopy(EMPTY_LAYER_PREDICATES, 0, LAYER_PREDICATES, 0, EMPTY_LAYER_PREDICATES.length);
        Optional optionalResource = manager.method_14486(LOCATION);
        if (optionalResource.isPresent()) {
            class_3298 resource = (class_3298)optionalResource.get();
            try (InputStream inputStream = resource.method_14482();){
                Properties properties = new Properties();
                properties.load(inputStream);
                CustomBlockLayers.reload(properties, LOCATION, resource.method_14480());
            }
            catch (IOException e) {
                ContinuityClient.LOGGER.error("Failed to load custom block layers from file '" + LOCATION + "'", (Throwable)e);
            }
        }
    }

    private static void reload(Properties properties, class_2960 fileLocation, String packName) {
        for (BlockLayer blockLayer : BlockLayer.VALUES) {
            String propertyKey = "layer." + blockLayer.getKey();
            Predicate<class_2680> predicate = PropertiesParsingHelper.parseBlockStates(properties, propertyKey, fileLocation, packName, true);
            CustomBlockLayers.LAYER_PREDICATES[blockLayer.ordinal()] = predicate;
        }
    }

    private static enum BlockLayer {
        SOLID(class_1921.method_23577()),
        CUTOUT(class_1921.method_23581()),
        CUTOUT_MIPPED(class_1921.method_23579()),
        TRANSLUCENT(class_1921.method_23583());

        public static final BlockLayer[] VALUES;
        private final class_1921 layer;
        private final String key;

        private BlockLayer(class_1921 layer) {
            this.layer = layer;
            this.key = this.name().toLowerCase(Locale.ROOT);
        }

        public class_1921 getLayer() {
            return this.layer;
        }

        public String getKey() {
            return this.key;
        }

        static {
            VALUES = BlockLayer.values();
        }
    }

    public static class ReloadListener
    implements SimpleSynchronousResourceReloadListener {
        public static final class_2960 ID = ContinuityClient.asId("custom_block_layers");
        private static final ReloadListener INSTANCE = new ReloadListener();

        @ApiStatus.Internal
        public static void init() {
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)INSTANCE);
        }

        public void method_14491(class_3300 manager) {
            CustomBlockLayers.reload(manager);
        }

        public class_2960 getFabricId() {
            return ID;
        }
    }
}

